/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.sequencing;

import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.sequencing.Sequencer;
import org.ikasan.framework.component.sequencing.SequencerException;
import org.ikasan.framework.event.service.EventAggregator;

public class EventAggregatingSequencer
implements Sequencer {
    protected EventAggregator aggregator;

    public EventAggregatingSequencer(EventAggregator aggregator) {
        this.aggregator = aggregator;
        if (this.aggregator == null) {
            throw new IllegalArgumentException("EventAggregator cannot be 'null'");
        }
    }

    @Override
    public List<Event> onEvent(Event event, String moduleName, String componentName) throws SequencerException {
        try {
            Event aggregatedEvent = this.aggregator.aggregate(event);
            if (aggregatedEvent != null) {
                ArrayList<Event> events = new ArrayList<Event>();
                events.add(aggregatedEvent);
                return events;
            }
            return null;
        }
        catch (ResourceException e) {
            throw new SequencerException(e);
        }
    }
}

