/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.transformation.TransformationException;
import org.ikasan.framework.component.transformation.Transformer;
import org.xml.sax.InputSource;

public class SimpleXslTransformer
implements Transformer {
    private Templates templates;

    public SimpleXslTransformer(TransformerFactory transformerFactory, String classpathXslResource) throws TransformerConfigurationException {
        this.templates = transformerFactory.newTemplates(new StreamSource(this.getInputStreamFromClassPath(classpathXslResource)));
    }

    private InputStream getInputStreamFromClassPath(String classpathXslResource) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(classpathXslResource);
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        return inputStream;
    }

    public SimpleXslTransformer(TransformerFactory transformerFactory, StreamSource streamSource) throws TransformerConfigurationException {
        this.templates = transformerFactory.newTemplates(streamSource);
    }

    @Override
    public void onEvent(Event event) throws TransformationException {
        for (Payload payload : event.getPayloads()) {
            this.transformPayload(payload);
        }
    }

    private void transformPayload(Payload payload) {
        ByteArrayOutputStream transformedDataStream = new ByteArrayOutputStream();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(payload.getContent()));
        SAXSource saxSource = new SAXSource(inputSource);
        try {
            this.templates.newTransformer().transform(saxSource, new StreamResult(transformedDataStream));
            payload.setContent(transformedDataStream.toByteArray());
        }
        catch (TransformerConfigurationException e) {
            throw new TransformationException(e);
        }
        catch (TransformerException e) {
            throw new TransformationException(e);
        }
    }
}

