/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.transformation.ExceptionThrowingErrorHandler;
import org.ikasan.framework.component.transformation.TransformationException;
import org.ikasan.framework.component.transformation.Transformer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XMLValidator
implements Transformer {
    private static Logger logger = Logger.getLogger(XMLValidator.class);
    private DocumentBuilderFactory factory;
    private ErrorHandler errorHandler = new ExceptionThrowingErrorHandler();

    public XMLValidator(DocumentBuilderFactory factory) {
        this.factory = factory;
        if (this.factory == null) {
            throw new IllegalArgumentException("document builder factory cannot be 'null'.");
        }
    }

    @Override
    public void onEvent(Event event) throws TransformationException {
        List<Payload> payloads = event.getPayloads();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)event.idToString());
        }
        try {
            for (Payload payload : payloads) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Payload [" + payload.getId() + "]"));
                }
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                ByteArrayInputStream payloadContentAsInputStream = new ByteArrayInputStream(payload.getContent());
                builder.parse(payloadContentAsInputStream);
            }
        }
        catch (SAXException e) {
            throw new TransformationException(e);
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new TransformationException(e);
        }
    }
}

