/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation.flatfile.reader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ikasan.framework.component.transformation.flatfile.reader.BaseFlatFileReader;
import org.ikasan.framework.component.transformation.flatfile.reader.field.BaseFieldDefinition;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseStringHandlingFlatFileReader
extends BaseFlatFileReader {
    protected boolean trimTrailingWhitespace;

    public BaseStringHandlingFlatFileReader(String rootElementName, boolean trimTrailingWhitespace) {
        super(rootElementName);
        this.trimTrailingWhitespace = trimTrailingWhitespace;
    }

    @Override
    public void parseInputSource(InputSource source) throws IOException, SAXException {
        InputStream is = source.getByteStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int read = 0;
        while (read > -1) {
            read = is.read();
            if (read == -1) continue;
            byteArrayOutputStream.write(read);
        }
        this.parseString(new String(byteArrayOutputStream.toByteArray()));
    }

    protected abstract void parseString(String var1) throws IOException, SAXException;

    protected String format(String fieldValue) {
        String formattedValue = fieldValue;
        if (this.trimTrailingWhitespace) {
            formattedValue = formattedValue.trim();
        }
        formattedValue = formattedValue.replaceAll("\n", "");
        return formattedValue;
    }

    protected boolean isEmpty(String fieldValue) {
        boolean result = false;
        if (fieldValue.trim().length() == 0) {
            result = true;
        }
        return result;
    }

    protected void reportField(BaseFieldDefinition fieldDefinition, String rawFieldContent) throws SAXException {
        String fieldValue = this.format(rawFieldContent);
        if (!fieldDefinition.isSkipIfEmpty() || !this.isEmpty(fieldValue)) {
            String fieldName = fieldDefinition.getFieldName();
            this.contentHandler.startElement(this.namespaceURI, fieldName, fieldName, this.attributes);
            this.contentHandler.characters(fieldValue.toCharArray(), 0, fieldValue.length());
            this.contentHandler.endElement(this.namespaceURI, fieldName, fieldName);
        }
    }
}

