/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.component.transformation.flatfile.reader;

import java.util.List;
import org.ikasan.framework.component.transformation.flatfile.reader.BaseStringHandlingFlatFileReader;
import org.ikasan.framework.component.transformation.flatfile.reader.FlatFileLocator;
import org.ikasan.framework.component.transformation.flatfile.reader.field.FixedLengthFieldDefinition;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FixedLengthFieldFlatFileReader
extends BaseStringHandlingFlatFileReader {
    private List<FixedLengthFieldDefinition> fieldDefinitions;

    public FixedLengthFieldFlatFileReader(String rootElementName, boolean trimTrailingWhitespace) {
        super(rootElementName, trimTrailingWhitespace);
    }

    public FixedLengthFieldFlatFileReader(String rootElementName, List<FixedLengthFieldDefinition> fieldDefinitions, boolean trimTrailingWhitespace) {
        super(rootElementName, trimTrailingWhitespace);
        this.fieldDefinitions = fieldDefinitions;
    }

    @Override
    protected void parseString(String fileContent) throws SAXException {
        String tempFileContent = fileContent;
        int consumedIndex = 0;
        for (FixedLengthFieldDefinition fieldDefinition : this.fieldDefinitions) {
            if (tempFileContent.length() < fieldDefinition.getFieldLength()) {
                if (tempFileContent.length() == 0 && fieldDefinition.isOptionalField()) break;
                throw new SAXParseException("content is too short for fixed length field [" + fieldDefinition + "]", new FlatFileLocator(consumedIndex));
            }
            String rawFieldContent = tempFileContent.substring(0, fieldDefinition.getFieldLength());
            this.reportField(fieldDefinition, rawFieldContent);
            tempFileContent = tempFileContent.substring(fieldDefinition.getFieldLength());
            consumedIndex += fieldDefinition.getFieldLength();
        }
    }
}

