/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.error.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.ikasan.framework.error.dao.ErrorOccurrenceDao;
import org.ikasan.framework.error.model.ErrorOccurrence;
import org.ikasan.framework.management.search.ArrayListPagedSearchResult;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateErrorOccurrenceDao
extends HibernateDaoSupport
implements ErrorOccurrenceDao {
    private static final String HOUSEKEEP_QUERY = "delete ErrorOccurrence e where e.expiry <= ?";
    private static final String FOR_EVENT_QUERY = "from ErrorOccurrence e where e.eventId = ?";
    private static final Logger logger = Logger.getLogger(HibernateErrorOccurrenceDao.class);

    @Override
    public void save(ErrorOccurrence errorOccurrence) {
        logger.info((Object)("Summary of ErrorOccurence we are saving [" + errorOccurrence.getErrorSummary() + "]"));
        this.getHibernateTemplate().save((Object)errorOccurrence);
    }

    @Override
    public ErrorOccurrence getErrorOccurrence(Long id) {
        return (ErrorOccurrence)this.getHibernateTemplate().get(ErrorOccurrence.class, (Serializable)id);
    }

    @Override
    public PagedSearchResult<ErrorOccurrence> findErrorOccurrences(final int pageNo, final int pageSize, final String orderBy, final boolean orderAscending, final String moduleName, final String flowName) {
        return (PagedSearchResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ErrorOccurrence.class);
                criteria.setMaxResults(pageSize);
                int firstResult = pageNo * pageSize;
                criteria.setFirstResult(firstResult);
                if (orderBy != null) {
                    if (orderAscending) {
                        criteria.addOrder(Order.asc((String)orderBy));
                    } else {
                        criteria.addOrder(Order.desc((String)orderBy));
                    }
                }
                if (moduleName != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"moduleName", (Object)moduleName));
                }
                if (flowName != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"flowName", (Object)flowName));
                }
                List wiretapResults = criteria.list();
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                return new ArrayListPagedSearchResult(wiretapResults, firstResult, rowCount);
            }
        });
    }

    @Override
    public void deleteAllExpired() {
        this.getHibernateTemplate().bulkUpdate(HOUSEKEEP_QUERY, (Object)new Date());
    }

    @Override
    public List<ErrorOccurrence> getErrorOccurrences(String eventId) {
        return this.getHibernateTemplate().find(FOR_EVENT_QUERY, (Object)eventId);
    }
}

