/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.error.serialisation;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.error.model.ErrorOccurrence;
import org.ikasan.framework.error.serialisation.ErrorOccurrenceXmlConverter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultErrorOccurrenceXmlConverter
implements ErrorOccurrenceXmlConverter {
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");

    public DefaultErrorOccurrenceXmlConverter() throws ParserConfigurationException, TransformerConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.transformerFactory = this.transformerFactory = TransformerFactory.newInstance();
    }

    @Override
    public String toXml(ErrorOccurrence errorOccurence) throws TransformerException {
        Document dom = this.documentBuilder.newDocument();
        Element errorOccurrenceElement = dom.createElement("errorOccurrence");
        dom.appendChild(errorOccurrenceElement);
        this.addChildTextElement(dom, errorOccurrenceElement, "errorDetail", errorOccurence.getErrorDetail());
        this.addChildTextElement(dom, errorOccurrenceElement, "actionTaken", errorOccurence.getActionTaken());
        this.addChildTextElement(dom, errorOccurrenceElement, "eventId", errorOccurence.getEventId());
        this.addChildTextElement(dom, errorOccurrenceElement, "flowElementName", errorOccurence.getFlowElementName());
        this.addChildTextElement(dom, errorOccurrenceElement, "flowName", errorOccurence.getFlowName());
        this.addChildTextElement(dom, errorOccurrenceElement, "initiatorName", errorOccurence.getInitiatorName());
        this.addChildTextElement(dom, errorOccurrenceElement, "logTime", this.dateFormat.format(errorOccurence.getLogTime()));
        this.addChildTextElement(dom, errorOccurrenceElement, "moduleName", errorOccurence.getModuleName());
        this.addChildTextElement(dom, errorOccurrenceElement, "url", errorOccurence.getUrl());
        Event errorEvent = errorOccurence.getErrorEvent();
        if (errorEvent != null) {
            Element errorEventElement = dom.createElement("errorEvent");
            errorOccurrenceElement.appendChild(errorEventElement);
            this.addChildTextElement(dom, errorEventElement, "id", errorEvent.getId());
            this.addChildTextElement(dom, errorEventElement, "priority", "" + errorEvent.getPriority());
            this.addChildTextElement(dom, errorEventElement, "timestamp", this.dateFormat.format(errorEvent.getTimestamp()));
            List<Payload> payloads = errorEvent.getPayloads();
            for (int i = 0; i < payloads.size(); ++i) {
                Payload payload = payloads.get(i);
                Element payloadElement = dom.createElement("payload");
                payloadElement.setAttribute("ordinal", "" + i);
                this.addChildTextElement(dom, payloadElement, "id", payload.getId());
                Element payloadContent = dom.createElement("content");
                CDATASection payloadContentCDATASection = null;
                try {
                    payloadContentCDATASection = dom.createCDATASection(new String(payload.getContent(), "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                payloadContent.appendChild(payloadContentCDATASection);
                payloadElement.appendChild(payloadContent);
                for (String payloadAttributeName : payload.getAttributeNames()) {
                    String payloadAttributeValue = payload.getAttribute(payloadAttributeName);
                    Element payloadAttributeElement = dom.createElement("attribute");
                    payloadAttributeElement.setAttribute("name", payloadAttributeName);
                    payloadAttributeElement.setAttribute("value", payloadAttributeValue);
                    payloadElement.appendChild(payloadAttributeElement);
                }
                errorEventElement.appendChild(payloadElement);
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        this.transformerFactory.newTransformer().transform(new DOMSource(dom), streamResult);
        return stringWriter.toString();
    }

    private void addChildTextElement(Document dom, Element parentElement, String elementName, String text) {
        Element element = dom.createElement(elementName);
        if (text != null) {
            element.appendChild(dom.createTextNode(text));
        }
        parentElement.appendChild(element);
    }
}

