/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.error.service;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.ikasan.framework.error.model.ErrorOccurrence;
import org.ikasan.framework.error.serialisation.ErrorOccurrenceXmlConverter;
import org.ikasan.framework.error.service.ErrorOccurrenceListener;

public class ErrorOccurrenceTextMessagePublisher
implements ErrorOccurrenceListener {
    private static Logger logger = Logger.getLogger(ErrorOccurrenceTextMessagePublisher.class);
    private Destination errorOccurrenceChannel;
    private ConnectionFactory connectionFactory;
    private Long timeToLive;
    private ErrorOccurrenceXmlConverter converter;

    public ErrorOccurrenceTextMessagePublisher(ConnectionFactory connectionFactory, Destination errorOccurrenceChannel, ErrorOccurrenceXmlConverter errorOccurrenceXmlConverter) {
        this.connectionFactory = connectionFactory;
        this.errorOccurrenceChannel = errorOccurrenceChannel;
        this.converter = errorOccurrenceXmlConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyErrorOccurrence(ErrorOccurrence errorOccurrence) {
        logger.info((Object)"invoked");
        Connection connection = null;
        try {
            connection = this.connectionFactory.createConnection();
            Session session = connection.createSession(true, 1);
            try {
                TextMessage message = session.createTextMessage(this.converter.toXml(errorOccurrence));
                MessageProducer messageProducer = session.createProducer(this.errorOccurrenceChannel);
                if (this.timeToLive != null) {
                    messageProducer.setTimeToLive(this.timeToLive.longValue());
                }
                messageProducer.send((Message)message);
                logger.info((Object)("Successfully published ErrorOccurrence[" + errorOccurrence.getId() + "] to ErrorOccurrenceChannel"));
            }
            catch (TransformerException e) {
                logger.error((Object)("Could not transform ErrorOccurrence to XML [" + errorOccurrence + "]"));
            }
        }
        catch (JMSException e) {
            this.handleJmsExcption(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    this.handleJmsExcption(e);
                }
            }
        }
    }

    private void handleJmsExcption(JMSException e) {
        logger.error((Object)e);
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }
}

