/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.exclusion.dao;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.ikasan.common.Payload;
import org.ikasan.common.component.DefaultPayload;
import org.ikasan.framework.event.exclusion.dao.ExcludedEventDao;
import org.ikasan.framework.event.exclusion.model.ExcludedEvent;
import org.ikasan.framework.management.search.ArrayListPagedSearchResult;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateExcludedEventDao
extends HibernateDaoSupport
implements ExcludedEventDao {
    private Logger logger = Logger.getLogger(HibernateExcludedEventDao.class);

    @Override
    public void save(ExcludedEvent excludedEvent) {
        this.logger.info((Object)("saving [" + excludedEvent + "]"));
        this.getHibernateTemplate().save((Object)excludedEvent);
    }

    @Override
    public ExcludedEvent load(Long excludedEventId) {
        return (ExcludedEvent)this.getHibernateTemplate().get(ExcludedEvent.class, (Serializable)excludedEventId);
    }

    @Override
    public PagedSearchResult<ExcludedEvent> findExcludedEvents(final int pageNo, final int pageSize, final String orderBy, final boolean orderAscending, final String moduleName, final String flowName) {
        return (PagedSearchResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ExcludedEvent.class);
                criteria.setMaxResults(pageSize);
                int firstResult = pageNo * pageSize;
                criteria.setFirstResult(firstResult);
                if (orderBy != null) {
                    if (orderAscending) {
                        criteria.addOrder(Order.asc((String)orderBy));
                    } else {
                        criteria.addOrder(Order.desc((String)orderBy));
                    }
                }
                if (moduleName != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"moduleName", (Object)moduleName));
                }
                if (flowName != null) {
                    criteria.add((Criterion)Restrictions.eq((String)"flowName", (Object)flowName));
                }
                List results = criteria.list();
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                return new ArrayListPagedSearchResult(results, firstResult, rowCount);
            }
        });
    }

    public ExcludedEvent getExcludedEvent(long excludedEventId) {
        return (ExcludedEvent)this.getHibernateTemplate().get(ExcludedEvent.class, (Serializable)Long.valueOf(excludedEventId));
    }

    @Override
    public void delete(ExcludedEvent excludedEvent) {
        this.getHibernateTemplate().delete((Object)excludedEvent);
    }

    @Override
    public ExcludedEvent getExcludedEvent(String eventId, boolean mutable) {
        ExcludedEvent result = null;
        List excludedEvents = this.getHibernateTemplate().find("from ExcludedEvent e where e.event.id = ?", (Object)eventId);
        if (excludedEvents.size() > 0) {
            result = (ExcludedEvent)excludedEvents.get(0);
            if (!mutable) {
                this.getHibernateTemplate().evict((Object)result);
                for (Payload payload : result.getEvent().getPayloads()) {
                    ((DefaultPayload)payload).setPersistenceId(null);
                }
            }
        }
        return result;
    }
}

