/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.exclusion.model;

import java.util.Date;
import java.util.List;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.error.model.ErrorOccurrence;

public class ExcludedEvent {
    public static final String RESOLUTION_RESUBMITTED = "Resubmitted";
    public static final String RESOLUTION_CANCELLED = "Cancelled";
    private Long id;
    private Event event;
    private String moduleName;
    private String flowName;
    private Date exclusionTime;
    private Date lastUpdatedTime;
    private String resolution = null;
    private String lastUpdatedBy;
    private List<ErrorOccurrence> errorOccurrences;

    private ExcludedEvent() {
    }

    public ExcludedEvent(Event event, String moduleName, String flowName, Date exclusionTime) {
        this.event = event;
        this.moduleName = moduleName;
        this.flowName = flowName;
        this.exclusionTime = exclusionTime;
    }

    public void resolveAsResubmitted(String resolver) {
        this.resolve(resolver, RESOLUTION_RESUBMITTED);
    }

    public void resolveAsCancelled(String resolver) {
        this.resolve(resolver, RESOLUTION_CANCELLED);
    }

    private void resolve(String resolver, String resolution) throws IllegalStateException {
        if (this.isResolved()) {
            throw new IllegalStateException("Cannot resolve excludedEvent [" + this.id + "], as it was previously resolved as [" + resolution + "]");
        }
        this.setLastUpdatedTime(new Date());
        this.setLastUpdatedBy(resolver);
        this.setResolution(resolution);
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Event getEvent() {
        return this.event;
    }

    private void setEvent(Event event) {
        this.event = event;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    private void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    private void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Date getExclusionTime() {
        return this.exclusionTime;
    }

    private void setExclusionTime(Date exclusionTime) {
        this.exclusionTime = exclusionTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public List<ErrorOccurrence> getErrorOccurrences() {
        return this.errorOccurrences;
    }

    public void setErrorOccurrences(List<ErrorOccurrence> errorOccurrences) {
        this.errorOccurrences = errorOccurrences;
    }

    public boolean isResolved() {
        return this.resolution != null;
    }

    public String getResolution() {
        return this.resolution;
    }

    private void setResolution(String resolution) {
        this.resolution = resolution;
    }
}

