/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.serialisation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Session;
import org.ikasan.common.Payload;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.event.serialisation.EventDeserialisationException;
import org.ikasan.framework.event.serialisation.JmsMessageEventSerialiser;

public class DefaultMapMessageEventSerialiser
implements JmsMessageEventSerialiser<MapMessage> {
    protected static final String PAYLOAD_PREFIX = "PAYLOAD_";
    protected static final String ATTRIBUTE_PREFIX = "_ATTRIBUTE_";
    protected static final String PAYLOAD_CONTENT_SUFFIX = "_CONTENT";
    protected static final String PAYLOAD_SRC_SYSTEM_SUFFIX = "_SRC_SYSTEM";
    protected static final String PAYLOAD_ID_SUFFIX = "_ID";
    protected static final String PAYLOAD_SPEC_SUFFIX = "_SPEC";
    protected static final String EVENT_FIELD_ID = "EVENT_ID";
    protected static final String EVENT_FIELD_PRIORITY = "EVENT_PRIORITY";
    protected static final String EVENT_FIELD_TIMESTAMP = "EVENT_TIMESTAMP";
    protected static final String EVENT_FIELD_SRC_SYSTEM = "EVENT_FIELD_SRC_SYSTEM";
    protected PayloadFactory payloadFactory;

    @Override
    public Event fromMessage(MapMessage mapMessage, String moduleName, String componentName) throws JMSException, EventDeserialisationException {
        Event result = null;
        Enumeration mapNames = mapMessage.getMapNames();
        List<List<String>> groupedKeys = this.groupMapNames(mapNames);
        List<String> eventFieldNames = groupedKeys.get(0);
        List<List<String>> payloadFieldNameLists = groupedKeys.subList(1, groupedKeys.size());
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (int payloadOrdinal = 0; payloadOrdinal < payloadFieldNameLists.size(); ++payloadOrdinal) {
            List<String> payloadFieldNames = payloadFieldNameLists.get(payloadOrdinal);
            payloads.add(this.demapPayload(payloadOrdinal, mapMessage, payloadFieldNames));
        }
        result = this.demapEvent(mapMessage, moduleName, componentName, payloads, eventFieldNames);
        return result;
    }

    protected Event demapEvent(MapMessage mapMessage, String moduleName, String componentName, List<Payload> payloads, List<String> eventFieldNames) throws JMSException, EventDeserialisationException {
        String eventId = null;
        int priority = -1;
        Date timestamp = null;
        for (String fieldName : eventFieldNames) {
            if (fieldName.equals(EVENT_FIELD_ID)) {
                eventId = mapMessage.getString(EVENT_FIELD_ID);
                continue;
            }
            if (fieldName.equals(EVENT_FIELD_PRIORITY)) {
                priority = mapMessage.getInt(EVENT_FIELD_PRIORITY);
                continue;
            }
            if (fieldName.equals(EVENT_FIELD_TIMESTAMP)) {
                timestamp = new Date(mapMessage.getLong(EVENT_FIELD_TIMESTAMP));
                continue;
            }
            throw new EventDeserialisationException("Unknown map entry [" + fieldName + "]");
        }
        return new Event(eventId, priority, timestamp, payloads);
    }

    protected Payload demapPayload(int payloadOrdinal, MapMessage mapMessage, List<String> payloadFieldNames) throws JMSException, EventDeserialisationException {
        String fullPayloadPrefix = PAYLOAD_PREFIX + payloadOrdinal;
        String payloadId = null;
        byte[] payloadContent = null;
        HashMap<String, String> payloadAttributes = new HashMap<String, String>();
        for (String fieldName : payloadFieldNames) {
            if (fieldName.equals(fullPayloadPrefix + PAYLOAD_CONTENT_SUFFIX)) {
                payloadContent = mapMessage.getBytes(fullPayloadPrefix + PAYLOAD_CONTENT_SUFFIX);
                continue;
            }
            if (fieldName.equals(fullPayloadPrefix + PAYLOAD_ID_SUFFIX)) {
                payloadId = mapMessage.getString(fullPayloadPrefix + PAYLOAD_ID_SUFFIX);
                continue;
            }
            if (fieldName.startsWith(fullPayloadPrefix + ATTRIBUTE_PREFIX)) {
                payloadAttributes.put(fieldName.substring((fullPayloadPrefix + ATTRIBUTE_PREFIX).length()), mapMessage.getString(fieldName));
                continue;
            }
            throw new EventDeserialisationException("Unknown map entry [" + fieldName + "]");
        }
        Payload payload = this.payloadFactory.newPayload(payloadId, payloadContent);
        for (String attributeName : payloadAttributes.keySet()) {
            payload.setAttribute(attributeName, (String)payloadAttributes.get(attributeName));
        }
        return payload;
    }

    protected List<List<String>> groupMapNames(Enumeration<String> mapNames) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> eventFields = new ArrayList<String>();
        result.add(eventFields);
        HashMap payloadFieldNameLists = new HashMap();
        while (mapNames.hasMoreElements()) {
            String mapName = mapNames.nextElement();
            if (mapName.startsWith(PAYLOAD_PREFIX)) {
                String fullPayloadPrefix = mapName.substring(0, mapName.indexOf(95, PAYLOAD_PREFIX.length()));
                if (payloadFieldNameLists.get(fullPayloadPrefix) == null) {
                    payloadFieldNameLists.put(fullPayloadPrefix, new ArrayList());
                }
                List payloadFields = (List)payloadFieldNameLists.get(fullPayloadPrefix);
                payloadFields.add(mapName);
                continue;
            }
            eventFields.add(mapName);
        }
        ArrayList fullPayloadPrefixes = new ArrayList(payloadFieldNameLists.keySet());
        Collections.sort(fullPayloadPrefixes);
        for (int i = 0; i < fullPayloadPrefixes.size(); ++i) {
            String fullPayloadPrefix = (String)fullPayloadPrefixes.get(i);
            if (!fullPayloadPrefix.equals(PAYLOAD_PREFIX + i)) {
                throw new RuntimeException("Non-continuous payload sequence! was expecting [PAYLOAD_" + i + "] but got [" + fullPayloadPrefix + "]");
            }
            result.add((List<String>)payloadFieldNameLists.get(fullPayloadPrefix));
        }
        return result;
    }

    @Override
    public MapMessage toMessage(Event event, Session session) throws JMSException {
        MapMessage mapMessage = session.createMapMessage();
        List<Payload> payloads = event.getPayloads();
        for (int i = 0; i < payloads.size(); ++i) {
            Payload payload = payloads.get(i);
            mapMessage.setBytes(PAYLOAD_PREFIX + i + PAYLOAD_CONTENT_SUFFIX, payload.getContent());
            mapMessage.setString(PAYLOAD_PREFIX + i + PAYLOAD_ID_SUFFIX, payload.getId());
            for (String attributeName : payload.getAttributeNames()) {
                mapMessage.setString(PAYLOAD_PREFIX + i + ATTRIBUTE_PREFIX + attributeName, payload.getAttribute(attributeName));
            }
        }
        mapMessage.setString(EVENT_FIELD_ID, event.getId());
        mapMessage.setInt(EVENT_FIELD_PRIORITY, event.getPriority());
        mapMessage.setLong(EVENT_FIELD_TIMESTAMP, event.getTimestamp().getTime());
        return mapMessage;
    }

    public void setPayloadFactory(PayloadFactory payloadFactory) {
        this.payloadFactory = payloadFactory;
    }
}

