/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.service;

import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.event.service.EventProvider;
import org.ikasan.framework.payload.service.PayloadProvider;

public class MultiPayloadPerEventProvider
implements EventProvider {
    private PayloadProvider payloadProvider;
    private String moduleName;
    private String componentName;

    public MultiPayloadPerEventProvider(PayloadProvider payloadProvider, String moduleName, String componentName) {
        this.payloadProvider = payloadProvider;
        if (this.payloadProvider == null) {
            throw new IllegalArgumentException("'payloadProvider' cannot be 'null'.");
        }
        this.moduleName = moduleName;
        this.componentName = componentName;
    }

    @Override
    public List<Event> getEvents() throws ResourceException {
        List<Payload> payloads = this.payloadProvider.getNextRelatedPayloads();
        if (payloads == null || payloads.isEmpty()) {
            return null;
        }
        Event event = new Event(this.moduleName, this.componentName, this.hashPayloadIds(payloads), payloads);
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event);
        return events;
    }

    private String hashPayloadIds(List<Payload> payloads) {
        StringBuffer aggregatedId = new StringBuffer();
        for (Payload payload : payloads) {
            aggregatedId.append(payload.getId());
        }
        return "" + aggregatedId.toString().hashCode();
    }
}

