/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.wiretap.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.ikasan.framework.event.wiretap.dao.WiretapDao;
import org.ikasan.framework.event.wiretap.model.PagedWiretapSearchResult;
import org.ikasan.framework.event.wiretap.model.WiretapEvent;
import org.ikasan.framework.management.search.ArrayListPagedSearchResult;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateWiretapDao
extends HibernateDaoSupport
implements WiretapDao {
    private static final String HOUSEKEEP_QUERY = "delete WiretapEvent w where w.expiry <= ?";
    private static final String WIRETAP_EVENT_IDS_FOR_PAYLOAD_ID = "select w.id from WiretapEvent w where w.payloadId = ?";
    private static final String BATCHED_HOUSEKEEP_QUERY = "delete WiretapEvent s where s.id in (:event_ids)";
    private boolean batchHousekeepDelete = false;
    private Integer housekeepingBatchSize = null;

    public HibernateWiretapDao() {
    }

    public HibernateWiretapDao(boolean batchHousekeepDelete, Integer housekeepingBatchSize) {
        this();
        this.batchHousekeepDelete = batchHousekeepDelete;
        this.housekeepingBatchSize = housekeepingBatchSize;
    }

    @Override
    public void save(WiretapEvent wiretapEvent) {
        this.getHibernateTemplate().save((Object)wiretapEvent);
    }

    @Override
    public WiretapEvent findById(Long id) {
        WiretapEvent wiretapEvent = (WiretapEvent)this.getHibernateTemplate().get(WiretapEvent.class, (Serializable)id);
        List relatedIds = this.getHibernateTemplate().find(WIRETAP_EVENT_IDS_FOR_PAYLOAD_ID, (Object)wiretapEvent.getPayloadId());
        Collections.sort(relatedIds);
        int thisWiretapsIndex = relatedIds.indexOf(wiretapEvent.getId());
        Long nextEvent = null;
        Long previousEvent = null;
        if (thisWiretapsIndex > 0) {
            previousEvent = (Long)relatedIds.get(thisWiretapsIndex - 1);
        }
        if (thisWiretapsIndex < relatedIds.size() - 1) {
            nextEvent = (Long)relatedIds.get(thisWiretapsIndex + 1);
        }
        wiretapEvent.setNextByPayload(nextEvent);
        wiretapEvent.setPreviousByPayload(previousEvent);
        return wiretapEvent;
    }

    @Override
    @Deprecated
    public PagedWiretapSearchResult findPaging(final Set<String> moduleNames, final String moduleFlow, final String componentName, final String eventId, final String payloadId, final Date fromDate, final Date untilDate, final String payloadContent, final int maxResults, final int firstResult) throws DataAccessException {
        return (PagedWiretapSearchResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(WiretapEvent.class, "event");
                criteria.add(Restrictions.in((String)"moduleName", (Collection)moduleNames));
                if (HibernateWiretapDao.restrictionExists(moduleFlow)) {
                    criteria.add((Criterion)Restrictions.eq((String)"flowName", (Object)moduleFlow));
                }
                if (HibernateWiretapDao.restrictionExists(componentName)) {
                    criteria.add((Criterion)Restrictions.eq((String)"componentName", (Object)componentName));
                }
                if (HibernateWiretapDao.restrictionExists(eventId)) {
                    criteria.add((Criterion)Restrictions.eq((String)"eventId", (Object)eventId));
                }
                if (HibernateWiretapDao.restrictionExists(payloadId)) {
                    criteria.add((Criterion)Restrictions.eq((String)"payloadId", (Object)payloadId));
                }
                if (HibernateWiretapDao.restrictionExists(payloadContent)) {
                    criteria.add((Criterion)Restrictions.like((String)"payloadContent", (String)payloadContent, (MatchMode)MatchMode.ANYWHERE));
                }
                if (HibernateWiretapDao.restrictionExists(fromDate)) {
                    criteria.add((Criterion)Restrictions.gt((String)"created", (Object)fromDate));
                }
                if (HibernateWiretapDao.restrictionExists(untilDate)) {
                    criteria.add((Criterion)Restrictions.lt((String)"created", (Object)untilDate));
                }
                criteria.setMaxResults(maxResults);
                criteria.setFirstResult(firstResult);
                criteria.addOrder(Order.desc((String)"id"));
                List wiretapResults = criteria.list();
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                return new PagedWiretapSearchResult(wiretapResults, rowCount, firstResult);
            }
        });
    }

    @Override
    public PagedSearchResult<WiretapEvent> findWiretapEvents(final int pageNo, final int pageSize, final String orderBy, final boolean orderAscending, final Set<String> moduleNames, final String moduleFlow, final String componentName, final String eventId, final String payloadId, final Date fromDate, final Date untilDate, final String payloadContent) {
        return (PagedSearchResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(WiretapEvent.class);
                criteria.setMaxResults(pageSize);
                int firstResult = pageNo * pageSize;
                criteria.setFirstResult(firstResult);
                if (orderBy != null) {
                    if (orderAscending) {
                        criteria.addOrder(Order.asc((String)orderBy));
                    } else {
                        criteria.addOrder(Order.desc((String)orderBy));
                    }
                }
                if (HibernateWiretapDao.restrictionExists(moduleNames)) {
                    criteria.add(Restrictions.in((String)"moduleName", (Collection)moduleNames));
                }
                if (HibernateWiretapDao.restrictionExists(moduleFlow)) {
                    criteria.add((Criterion)Restrictions.eq((String)"flowName", (Object)moduleFlow));
                }
                if (HibernateWiretapDao.restrictionExists(componentName)) {
                    criteria.add((Criterion)Restrictions.eq((String)"componentName", (Object)componentName));
                }
                if (HibernateWiretapDao.restrictionExists(eventId)) {
                    criteria.add((Criterion)Restrictions.eq((String)"eventId", (Object)eventId));
                }
                if (HibernateWiretapDao.restrictionExists(payloadId)) {
                    criteria.add((Criterion)Restrictions.eq((String)"payloadId", (Object)payloadId));
                }
                if (HibernateWiretapDao.restrictionExists(payloadContent)) {
                    criteria.add((Criterion)Restrictions.like((String)"payloadContent", (String)payloadContent, (MatchMode)MatchMode.ANYWHERE));
                }
                if (HibernateWiretapDao.restrictionExists(fromDate)) {
                    criteria.add((Criterion)Restrictions.gt((String)"created", (Object)fromDate));
                }
                if (HibernateWiretapDao.restrictionExists(untilDate)) {
                    criteria.add((Criterion)Restrictions.lt((String)"created", (Object)untilDate));
                }
                List wiretapResults = criteria.list();
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                return new ArrayListPagedSearchResult(wiretapResults, firstResult, rowCount);
            }
        });
    }

    static final boolean restrictionExists(Object restrictionValue) {
        return restrictionValue != null && !"".equals(restrictionValue);
    }

    @Override
    public void deleteAllExpired() {
        if (!this.batchHousekeepDelete) {
            this.getHibernateTemplate().bulkUpdate(HOUSEKEEP_QUERY, (Object)new Date());
        } else {
            this.batchHousekeepDelete();
        }
    }

    private void batchHousekeepDelete() {
        this.logger.info((Object)"called");
        while (this.housekeepablesExist()) {
            final List<Long> housekeepableBatch = this.getHousekeepableBatch();
            this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(HibernateWiretapDao.BATCHED_HOUSEKEEP_QUERY);
                    query.setParameterList("event_ids", (Collection)housekeepableBatch);
                    query.executeUpdate();
                    return null;
                }
            });
        }
    }

    private List<Long> getHousekeepableBatch() {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ArrayList<Long> ids = new ArrayList<Long>();
                Criteria criteria = session.createCriteria(WiretapEvent.class);
                criteria.add((Criterion)Restrictions.lt((String)"expiry", (Object)new Date()));
                criteria.setMaxResults(HibernateWiretapDao.this.housekeepingBatchSize.intValue());
                for (Object wiretapEventObj : criteria.list()) {
                    WiretapEvent wiretapEvent = (WiretapEvent)wiretapEventObj;
                    ids.add(wiretapEvent.getId());
                }
                return ids;
            }
        });
    }

    private boolean housekeepablesExist() {
        return (Boolean)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(WiretapEvent.class);
                criteria.add((Criterion)Restrictions.lt((String)"expiry", (Object)new Date()));
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                HibernateWiretapDao.this.logger.info((Object)(rowCount + ", housekeepables exist"));
                return new Boolean(rowCount > 0L);
            }
        });
    }
}

