/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.event.wiretap.service;

import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.event.wiretap.dao.WiretapDao;
import org.ikasan.framework.event.wiretap.model.PagedWiretapSearchResult;
import org.ikasan.framework.event.wiretap.model.WiretapEvent;
import org.ikasan.framework.event.wiretap.service.WiretapService;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.ikasan.framework.module.service.ModuleService;

public class WiretapServiceImpl
implements WiretapService {
    private WiretapDao wiretapDao;
    private static Logger logger = Logger.getLogger(WiretapServiceImpl.class);
    private ModuleService moduleService;

    public WiretapServiceImpl(WiretapDao wiretapDao, ModuleService moduleService) {
        this.wiretapDao = wiretapDao;
        this.moduleService = moduleService;
        logger.info((Object)"created");
    }

    @Override
    public PagedSearchResult<WiretapEvent> findWiretapEvents(int pageNo, int pageSize, String orderBy, boolean orderAscending, Set<String> moduleNames, String moduleFlow, String componentName, String eventId, String payloadId, Date fromDate, Date untilDate, String payloadContent) {
        if (pageNo < 0) {
            throw new IllegalArgumentException("pageNo must be >= 0");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        return this.wiretapDao.findWiretapEvents(pageNo, pageSize, orderBy, orderAscending, moduleNames, moduleFlow, componentName, eventId, payloadId, fromDate, untilDate, payloadContent);
    }

    @Override
    public PagedWiretapSearchResult findWiretapEvents(Set<String> moduleNames, String moduleFlow, String componentName, String eventId, String payloadId, Date fromDate, Date untilDate, String payloadContent, int pageSize, int pageNo) {
        if (moduleNames == null || moduleNames.isEmpty()) {
            throw new IllegalArgumentException("moduleNames must be nonEmpty");
        }
        return this.wiretapDao.findPaging(moduleNames, moduleFlow, componentName, eventId, payloadId, fromDate, untilDate, payloadContent, pageSize, pageSize * (pageNo - 1));
    }

    @Override
    public WiretapEvent getWiretapEvent(Long wiretapEventId) {
        WiretapEvent wiretapEvent = this.wiretapDao.findById(wiretapEventId);
        if (wiretapEvent != null) {
            this.moduleService.getModule(wiretapEvent.getModuleName());
        }
        return wiretapEvent;
    }

    @Override
    public void tapEvent(Event event, String componentName, String moduleName, String flowName, Long timeToLive) {
        String eventId = event.getId();
        Date expiry = new Date(System.currentTimeMillis() + timeToLive * 60000L);
        for (Payload payload : event.getPayloads()) {
            WiretapEvent wiretapEvent = new WiretapEvent(moduleName, flowName, componentName, eventId, payload.getId(), new String(payload.getContent()), expiry);
            this.wiretapDao.save(wiretapEvent);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Created wiretapEvent [" + wiretapEvent.toString() + "]"));
        }
    }

    @Override
    public void housekeep() {
        logger.info((Object)"wiretap housekeep called");
        long startTime = System.currentTimeMillis();
        this.wiretapDao.deleteAllExpired();
        long endTime = System.currentTimeMillis();
        logger.info((Object)("wiretap housekeep completed in [" + (endTime - startTime) + " ms]"));
    }
}

