/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.exception.matching;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ThrowableCauseMatcher
extends TypeSafeMatcher<Throwable> {
    private boolean directly;
    private Matcher<?> causeMatcher;

    public ThrowableCauseMatcher(Matcher<?> causeMatcher, boolean directly) {
        this.causeMatcher = causeMatcher;
        this.directly = directly;
    }

    public ThrowableCauseMatcher(Matcher<?> causeMatcher) {
        this(causeMatcher, true);
    }

    public boolean matchesSafely(Throwable throwable) {
        Throwable indirectCause;
        Throwable directCause;
        boolean result = this.causeMatcher.matches((Object)throwable);
        if (!(result || (directCause = throwable.getCause()) == null || (result = this.causeMatcher.matches((Object)directCause)) || this.directly || (indirectCause = throwable.getCause()) == null)) {
            result = this.matchesSafely(indirectCause);
        }
        return result;
    }

    public void describeTo(Description description) {
        description.appendText("throwable " + (this.directly ? "directly" : "indirectly") + " caused by ");
        this.causeMatcher.describeTo(description);
    }
}

