/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.flow;

import java.util.HashMap;
import java.util.Map;
import org.ikasan.framework.flow.FlowComponent;
import org.ikasan.framework.flow.FlowElement;

public class FlowElementImpl
implements FlowElement {
    private FlowComponent flowComponent;
    private String componentName;
    private Map<String, FlowElement> transitions;
    private String description;

    public FlowElementImpl(String componentName, FlowComponent flowComponent, Map<String, FlowElement> transitions) {
        this.componentName = componentName;
        this.flowComponent = flowComponent;
        this.transitions = transitions;
    }

    public FlowElementImpl(String componentName, FlowComponent flowComponent, FlowElement defaultTransition) {
        this(componentName, flowComponent, FlowElementImpl.createTransitionMap(defaultTransition));
    }

    public FlowElementImpl(String componentName, FlowComponent flowComponent) {
        this(componentName, flowComponent, (Map<String, FlowElement>)null);
    }

    private static Map<String, FlowElement> createTransitionMap(FlowElement defaultTransition) {
        HashMap<String, FlowElement> defaultTransitions = new HashMap<String, FlowElement>();
        defaultTransitions.put("default", defaultTransition);
        return defaultTransitions;
    }

    @Override
    public FlowComponent getFlowComponent() {
        return this.flowComponent;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public FlowElement getTransition(String transitionName) {
        FlowElement result = null;
        if (this.transitions != null) {
            result = this.transitions.get(transitionName);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName() + " [");
        sb.append("name=");
        sb.append(this.componentName);
        sb.append(",");
        sb.append("flowComponent=");
        sb.append(this.flowComponent);
        sb.append(",");
        sb.append("transitions=");
        sb.append(this.transitions);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Map<String, FlowElement> getTransitions() {
        HashMap<String, FlowElement> result = new HashMap<String, FlowElement>();
        if (this.transitions != null) {
            result.putAll(this.transitions);
        }
        return result;
    }
}

