/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.flow;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.configuration.ConfiguredResource;
import org.ikasan.framework.configuration.DynamicConfiguredResource;
import org.ikasan.framework.configuration.service.ConfigurationException;
import org.ikasan.framework.configuration.service.ConfigurationService;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.flow.FlowComponent;
import org.ikasan.framework.flow.FlowElement;
import org.ikasan.framework.flow.ManagedResource;
import org.ikasan.framework.flow.invoker.FlowElementInvoker;
import org.ikasan.framework.flow.invoker.FlowInvocationContext;

public class VisitingInvokerFlow
implements Flow {
    private static Logger logger = Logger.getLogger(VisitingInvokerFlow.class);
    private String name;
    private String moduleName;
    private FlowElement headElement;
    private FlowElementInvoker flowElementInvoker;
    private ConfigurationService configurationService;
    private List<DynamicConfiguredResource> dynamicConfiguredResources = new ArrayList<DynamicConfiguredResource>();

    public VisitingInvokerFlow(String name, String moduleName, FlowElement headElement, FlowElementInvoker visitingInvoker) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be 'null'");
        }
        this.moduleName = moduleName;
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be 'null'");
        }
        this.headElement = headElement;
        this.flowElementInvoker = visitingInvoker;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void invoke(FlowInvocationContext flowInvocationContext, Event event) {
        this.flowElementInvoker.invoke(flowInvocationContext, event, this.moduleName, this.name, this.headElement);
        for (DynamicConfiguredResource dynamicConfiguredResource : this.dynamicConfiguredResources) {
            this.configurationService.update(dynamicConfiguredResource);
        }
    }

    public List<FlowElement> getFlowElements() {
        ArrayList<FlowElement> result = new ArrayList<FlowElement>();
        ArrayList<FlowElement> elementsToVisit = new ArrayList<FlowElement>();
        elementsToVisit.add(this.headElement);
        while (!elementsToVisit.isEmpty()) {
            FlowElement thisFlowElement = (FlowElement)elementsToVisit.get(0);
            elementsToVisit.remove(0);
            if (!result.contains(thisFlowElement)) {
                result.add(thisFlowElement);
            }
            for (FlowElement subsequentElement : thisFlowElement.getTransitions().values()) {
                if (result.contains(subsequentElement)) continue;
                elementsToVisit.add(subsequentElement);
            }
        }
        return result;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void sync() {
        for (DynamicConfiguredResource dynamicConfiguredResource : this.dynamicConfiguredResources) {
            this.configurationService.configure(dynamicConfiguredResource);
        }
    }

    @Override
    public void start() {
        for (FlowElement flowElement : this.getFlowElements()) {
            FlowComponent flowComponent = flowElement.getFlowComponent();
            if (flowComponent instanceof ConfiguredResource) {
                if (this.configurationService == null) {
                    throw new ConfigurationException("Component " + flowElement.getComponentName() + " marked as a 'ConfiguredResource', but the configurationService has not been set on the module " + this.moduleName + " flow " + this.name);
                }
                this.configurationService.configure((ConfiguredResource)((Object)flowComponent));
                if (flowComponent instanceof DynamicConfiguredResource) {
                    this.dynamicConfiguredResources.add((DynamicConfiguredResource)((Object)flowComponent));
                }
            }
            if (!(flowComponent instanceof ManagedResource)) continue;
            try {
                ((ManagedResource)((Object)flowComponent)).startManagedResource();
            }
            catch (RuntimeException e) {
                logger.warn((Object)("Failed to start managed resource in component [" + flowElement.getComponentName() + "] " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        for (FlowElement flowElement : this.getFlowElements()) {
            FlowComponent flowComponent = flowElement.getFlowComponent();
            if (!(flowComponent instanceof ManagedResource)) continue;
            try {
                ((ManagedResource)((Object)flowComponent)).stopManagedResource();
            }
            catch (RuntimeException e) {
                logger.warn((Object)("Failed to stop managed resource in component [" + flowElement.getComponentName() + "] " + e.getMessage()), (Throwable)e);
            }
        }
        this.dynamicConfiguredResources.clear();
    }
}

