/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.event.serialisation.EventDeserialisationException;
import org.ikasan.framework.exception.IkasanExceptionAction;
import org.ikasan.framework.exception.RetryAction;
import org.ikasan.framework.exception.StopAction;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.AbortTransactionException;
import org.ikasan.framework.initiator.AbstractInitiator;
import org.ikasan.framework.initiator.messagedriven.JmsMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.ListenerSetupFailureListener;
import org.ikasan.framework.initiator.messagedriven.MessageListenerContainer;
import org.ikasan.framework.monitor.MonitorSubject;

public abstract class JmsMessageDrivenInitiatorImpl
extends AbstractInitiator
implements JmsMessageDrivenInitiator,
MonitorSubject,
ListenerSetupFailureListener {
    private int listenerSetupFailureRetryDelay = 10000;
    private int maxListenerSetupFailureRetries = RetryAction.RETRY_INFINITE;
    public static final String JMS_MESSAGE_DRIVEN_INITIATOR_TYPE = "JmsMessageDrivenInitiator";
    static Logger logger = Logger.getLogger(JmsMessageDrivenInitiatorImpl.class);
    protected MessageListenerContainer messageListenerContainer;
    protected Anesthetist anesthetist = null;

    public JmsMessageDrivenInitiatorImpl(String moduleName, String name, Flow flow, IkasanExceptionHandler exceptionHandler) {
        super(moduleName, name, flow, exceptionHandler);
    }

    @Override
    public String getType() {
        return JMS_MESSAGE_DRIVEN_INITIATOR_TYPE;
    }

    public void onMessage(Message message) {
        Event event = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("received message with id [" + message.getJMSMessageID() + "]"));
            }
            if (message instanceof TextMessage) {
                event = this.handleTextMessage((TextMessage)message);
            } else if (message instanceof MapMessage) {
                event = this.handleMapMessage((MapMessage)message);
            } else if (message instanceof ObjectMessage) {
                event = this.handleObjectMessage((ObjectMessage)message);
            } else if (message instanceof StreamMessage) {
                event = this.handleStreamMessage((StreamMessage)message);
            } else if (message instanceof BytesMessage) {
                event = this.handleBytesMessage((BytesMessage)message);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logError(null, unsupportedOperationException, this.name, StopAction.instance());
            this.stopInError();
            throw new AbortTransactionException("Exception Action implied rollback");
        }
        catch (EventDeserialisationException eventDeserialisationException) {
            this.logError(null, eventDeserialisationException, this.name, StopAction.instance());
            this.stopInError();
            throw new AbortTransactionException("Exception Action implied rollback");
        }
        catch (Throwable eventSourcingThrowable) {
            IkasanExceptionAction action = this.exceptionHandler.handleThrowable(this.name, eventSourcingThrowable);
            this.logError(null, eventSourcingThrowable, this.name, action);
            this.handleAction(action, null);
        }
        this.invokeFlow(event);
    }

    @Override
    protected void completeRetryCycle() {
        if (this.retryCount != null) {
            this.retryCount = null;
        }
    }

    @Override
    protected void startRetryCycle(Integer maxAttempts, long delay) {
        this.anesthetist = new Anesthetist(delay);
    }

    @Override
    protected void continueRetryCycle(long delay) {
        this.anesthetist = new Anesthetist(delay);
    }

    @Override
    protected void cancelRetryCycle() {
        if (this.anesthetist != null) {
            this.anesthetist.cancel();
            this.anesthetist = null;
        }
        this.retryCount = null;
    }

    @Override
    public boolean isRecovering() {
        return this.retryCount != null;
    }

    @Override
    public boolean isRunning() {
        return this.messageListenerContainer.isRunning() || this.anesthetistOperating();
    }

    protected boolean anesthetistOperating() {
        return this.anesthetist != null && this.anesthetist.isOperating();
    }

    @Override
    protected void startInitiator() {
        this.messageListenerContainer.start();
    }

    @Override
    protected void stopInitiator() {
        this.messageListenerContainer.stop();
    }

    public void setMessageListenerContainer(MessageListenerContainer messageListenerContainer) {
        this.messageListenerContainer = messageListenerContainer;
        messageListenerContainer.setListenerSetupExceptionListener(this);
    }

    @Override
    public MessageListenerContainer getMessageListenerContainer() {
        return this.messageListenerContainer;
    }

    @Override
    public void notifyListenerSetupFailure(Throwable throwable) {
        this.logError(null, throwable, this.name, new RetryAction(this.listenerSetupFailureRetryDelay, this.maxListenerSetupFailureRetries));
        this.handleRetry(this.maxListenerSetupFailureRetries, this.listenerSetupFailureRetryDelay);
    }

    protected Event handleBytesMessage(BytesMessage message) throws JMSException {
        throw new UnsupportedOperationException("This Initiator does not support BytesMessage [" + message.toString() + "]");
    }

    protected Event handleStreamMessage(StreamMessage message) throws JMSException, EventDeserialisationException {
        throw new UnsupportedOperationException("This Initiator does not support StreamMessage [" + message.toString() + "]");
    }

    protected Event handleObjectMessage(ObjectMessage message) throws JMSException, EventDeserialisationException {
        throw new UnsupportedOperationException("This Initiator does not support ObjectMessage [" + message.toString() + "]");
    }

    protected Event handleMapMessage(MapMessage message) throws JMSException, EventDeserialisationException {
        throw new UnsupportedOperationException("This Initiator does not support MapMessage [" + message.toString() + "]");
    }

    protected Event handleTextMessage(TextMessage message) throws JMSException, EventDeserialisationException {
        throw new UnsupportedOperationException("This Initiator does not support TextMessage [" + message.toString() + "]");
    }

    public void setListenerSetupFailureRetryDelay(int listenerSetupFailureRetryDelay) {
        this.listenerSetupFailureRetryDelay = listenerSetupFailureRetryDelay;
    }

    public void setMaxListenerSetupFailureRetries(int maxListenerSetupFailureRetries) {
        this.maxListenerSetupFailureRetries = maxListenerSetupFailureRetries;
    }

    private class Anesthetist
    extends Thread {
        long sleepPeriod;
        boolean operating = false;
        boolean cancelled = false;

        public Anesthetist(long sleepPeriod) {
            this.sleepPeriod = sleepPeriod;
            logger.info((Object)("setting anesthetist to sleep the messageListenerConatiner for " + sleepPeriod + "ms"));
            this.putToSleep();
            this.start();
        }

        @Override
        public void run() {
            try {
                Anesthetist.sleep(this.sleepPeriod);
                this.reawaken();
            }
            catch (InterruptedException e) {
                this.reawaken();
            }
        }

        private void putToSleep() {
            this.operating = true;
            JmsMessageDrivenInitiatorImpl.this.messageListenerContainer.stop();
        }

        private void reawaken() {
            if (!this.cancelled) {
                logger.info((Object)"reawakening sleeping messageListenerContainer");
                JmsMessageDrivenInitiatorImpl.this.messageListenerContainer.start();
            }
            this.operating = false;
        }

        public boolean isOperating() {
            return this.operating;
        }

        public void cancel() {
            logger.info((Object)"cancelling any anesthetist operation");
            this.cancelled = true;
        }
    }
}

