/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.error.service.ErrorLoggingService;
import org.ikasan.framework.event.exclusion.service.ExcludedEventService;
import org.ikasan.framework.event.serialisation.JmsMessageEventSerialiser;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.AbstractInitiator;
import org.ikasan.framework.initiator.messagedriven.EventMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.JmsMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.JmsMessageDrivenInitiatorImpl;
import org.ikasan.framework.initiator.messagedriven.RawMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.spring.SpringMessageListenerContainer;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class MessageDrivenInitiatorFactoryBean
implements FactoryBean,
BeanNameAware {
    private String name;
    private String moduleName;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private DestinationResolver destinationResolver;
    private String destinationName;
    private PlatformTransactionManager transactionManager;
    private Flow flow;
    private IkasanExceptionHandler exceptionHandler;
    private JmsMessageEventSerialiser eventDeserialiser;
    private PayloadFactory payloadFactory;
    private Class<? extends JmsMessageDrivenInitiatorImpl> objectType;
    private ErrorLoggingService errorLoggingService;
    private ExcludedEventService excludedEventService;
    private JmsMessageDrivenInitiator initiator;
    private boolean isSubscriptionDurable = true;
    private boolean pubSubDomain = true;
    private boolean respectPriority = false;

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setIsSubscriptionDurable(boolean isSubscriptionDurable) {
        this.isSubscriptionDurable = isSubscriptionDurable;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setEventDeserialiser(JmsMessageEventSerialiser jmsMessageEventSerialiser) {
        this.eventDeserialiser = jmsMessageEventSerialiser;
    }

    public void setExceptionHandler(IkasanExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setPayloadFactory(PayloadFactory payloadFactory) {
        this.payloadFactory = payloadFactory;
    }

    public void setExcludedEventService(ExcludedEventService excludedEventService) {
        this.excludedEventService = excludedEventService;
    }

    public void setRespectPriority(boolean respectPriority) {
        this.respectPriority = respectPriority;
    }

    public void setErrorLoggingService(ErrorLoggingService errorLoggingService) {
        this.errorLoggingService = errorLoggingService;
    }

    public Object getObject() throws Exception {
        if (this.initiator == null) {
            this.initiator = this.constructInitiator();
            if (this.connectionFactory == null) {
                throw new IllegalArgumentException("connectionFactory is mandatory for JmsMessageDrivenInitiator creation");
            }
            if (this.destination == null && this.destinationResolver == null) {
                throw new IllegalArgumentException("either destination or destinationResolver is mandatory for JmsMessageDrivenInitiator creation");
            }
            if (this.transactionManager == null) {
                throw new IllegalArgumentException("transactionManager is mandatory for JmsMessageDrivenInitiator creation");
            }
            SpringMessageListenerContainer springMessageListenerContainer = new SpringMessageListenerContainer();
            springMessageListenerContainer.setBeanName(this.moduleName + "-" + this.name);
            springMessageListenerContainer.setConnectionFactory(this.connectionFactory);
            if (this.destination != null) {
                springMessageListenerContainer.setDestination(this.destination);
            } else {
                springMessageListenerContainer.setDestinationResolver(this.destinationResolver);
                springMessageListenerContainer.setDestinationName(this.destinationName);
                springMessageListenerContainer.setPubSubDomain(this.pubSubDomain);
            }
            springMessageListenerContainer.setMessageListener(this.initiator);
            springMessageListenerContainer.setTransactionManager(this.transactionManager);
            springMessageListenerContainer.setSessionTransacted(true);
            springMessageListenerContainer.setSubscriptionDurable(this.isSubscriptionDurable);
            springMessageListenerContainer.setDurableSubscriptionName(this.moduleName + "-" + this.name + "-durableSubscription");
            ((JmsMessageDrivenInitiatorImpl)this.initiator).setMessageListenerContainer(springMessageListenerContainer);
            springMessageListenerContainer.setAutoStartup(false);
            springMessageListenerContainer.afterPropertiesSet();
        }
        return this.initiator;
    }

    private JmsMessageDrivenInitiator constructInitiator() {
        if (this.moduleName == null || "".equals(this.moduleName)) {
            throw new IllegalArgumentException("moduleName is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.name == null || "".equals(this.name)) {
            throw new IllegalArgumentException("name is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.flow == null) {
            throw new IllegalArgumentException("flow is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.exceptionHandler == null) {
            throw new IllegalArgumentException("exceptionHandler is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.eventDeserialiser == null && this.payloadFactory == null) {
            throw new IllegalArgumentException("payloadFactory is mandatory for JmsMessageDrivenInitiator creation, if no JmsMessageEventSerialiser has been set");
        }
        JmsMessageDrivenInitiatorImpl thisInitiator = null;
        if (this.eventDeserialiser != null) {
            thisInitiator = new EventMessageDrivenInitiator(this.moduleName, this.name, this.flow, this.exceptionHandler, this.eventDeserialiser);
        } else {
            thisInitiator = new RawMessageDrivenInitiator(this.moduleName, this.name, this.flow, this.exceptionHandler, this.payloadFactory);
            ((RawMessageDrivenInitiator)thisInitiator).setRespectPriority(this.respectPriority);
        }
        ((AbstractInitiator)thisInitiator).setExcludedEventService(this.excludedEventService);
        ((AbstractInitiator)thisInitiator).setErrorLoggingService(this.errorLoggingService);
        return thisInitiator;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        this.name = beanName;
    }
}

