/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven.jca;

import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.component.IkasanExceptionHandler;
import org.ikasan.framework.event.serialisation.JmsMessageEventSerialiser;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.messagedriven.EventMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.JmsMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.JmsMessageDrivenInitiatorImpl;
import org.ikasan.framework.initiator.messagedriven.RawMessageDrivenInitiator;
import org.ikasan.framework.initiator.messagedriven.jca.SpringMessageListenerContainer;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class JcaMessageDrivenInitiatorFactoryBean
implements FactoryBean,
BeanNameAware {
    private PlatformTransactionManager transactionManager;
    private JmsActivationSpecConfig jmsActivationSpecConfig;
    private JmsActivationSpecFactory jmsActivationSpecFactory;
    private DestinationResolver destinationResolver;
    private ActivationSpec jmsActivationSpec;
    private ResourceAdapter resourceAdapter;
    private String name;
    private String moduleName;
    private Flow flow;
    private IkasanExceptionHandler exceptionHandler;
    private JmsMessageEventSerialiser eventDeserialiser;
    private PayloadFactory payloadFactory;
    private Class<? extends JmsMessageDrivenInitiatorImpl> objectType;
    private JmsMessageDrivenInitiator initiator;
    private boolean respectPriority = false;

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setJmsActivationSpecConfig(JmsActivationSpecConfig jmsActivationSpecConfig) {
        this.jmsActivationSpecConfig = jmsActivationSpecConfig;
    }

    public void setJmsActivationSpecFactory(JmsActivationSpecFactory jmsActivationSpecFactory) {
        this.jmsActivationSpecFactory = jmsActivationSpecFactory;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setJmsActivationSpec(ActivationSpec jmsActivationSpec) {
        this.jmsActivationSpec = jmsActivationSpec;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setEventDeserialiser(JmsMessageEventSerialiser jmsMessageEventSerialiser) {
        this.eventDeserialiser = jmsMessageEventSerialiser;
    }

    public void setPayloadFactory(PayloadFactory payloadFactory) {
        this.payloadFactory = payloadFactory;
    }

    public void setRespectPriority(boolean respectPriority) {
        this.respectPriority = respectPriority;
    }

    public void setExceptionHandler(IkasanExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Object getObject() throws Exception {
        if (this.initiator == null) {
            this.initiator = this.constructInitiator();
            if (this.transactionManager == null) {
                throw new IllegalArgumentException("transactionManager is mandatory for JmsMessageDrivenInitiator creation");
            }
            SpringMessageListenerContainer springMessageListenerContainer = new SpringMessageListenerContainer();
            springMessageListenerContainer.setActivationSpec(this.jmsActivationSpec);
            springMessageListenerContainer.setResourceAdapter(this.resourceAdapter);
            springMessageListenerContainer.setMessageListener(this.initiator);
            springMessageListenerContainer.setTransactionManager(this.transactionManager);
            ((JmsMessageDrivenInitiatorImpl)this.initiator).setMessageListenerContainer(springMessageListenerContainer);
            springMessageListenerContainer.setAutoStartup(false);
            springMessageListenerContainer.afterPropertiesSet();
        }
        return this.initiator;
    }

    private JmsMessageDrivenInitiator constructInitiator() {
        if (this.moduleName == null || "".equals(this.moduleName)) {
            throw new IllegalArgumentException("moduleName is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.name == null || "".equals(this.name)) {
            throw new IllegalArgumentException("name is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.flow == null) {
            throw new IllegalArgumentException("flow is mandatory for JmsMessageDrivenInitiator creation");
        }
        if (this.eventDeserialiser == null && this.payloadFactory == null) {
            throw new IllegalArgumentException("payloadFactory is mandatory for JmsMessageDrivenInitiator creation, if no JmsMessageEventSerialiser has been set");
        }
        JmsMessageDrivenInitiatorImpl thisInitiator = null;
        if (this.eventDeserialiser != null) {
            thisInitiator = new EventMessageDrivenInitiator(this.moduleName, this.name, this.flow, this.exceptionHandler, this.eventDeserialiser);
        } else {
            thisInitiator = new RawMessageDrivenInitiator(this.moduleName, this.name, this.flow, this.exceptionHandler, this.payloadFactory);
            ((RawMessageDrivenInitiator)thisInitiator).setRespectPriority(this.respectPriority);
        }
        return thisInitiator;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        this.name = beanName;
    }
}

