/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven.jca.jboss;

import javax.resource.spi.ResourceAdapter;
import org.ikasan.framework.initiator.messagedriven.jca.jboss.JBossJmsActivationSpecConfig;
import org.springframework.beans.BeanWrapper;
import org.springframework.jms.listener.endpoint.DefaultJmsActivationSpecFactory;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;

public class JBossJmsActivationSpecFactory
extends DefaultJmsActivationSpecFactory {
    private final String jbossDefaultActivationSpecClassName = "org.jboss.resource.adapter.jms.inflow.JmsActivationSpec";

    protected Class<?> determineActivationSpecClass(ResourceAdapter adapter) {
        try {
            return adapter.getClass().getClassLoader().loadClass("org.jboss.resource.adapter.jms.inflow.JmsActivationSpec");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to load ActivationSpec class [org.jboss.resource.adapter.jms.inflow.JmsActivationSpec]", ex);
        }
    }

    protected void populateActivationSpecProperties(BeanWrapper bw, JmsActivationSpecConfig config) {
        super.populateActivationSpecProperties(bw, config);
        if (config instanceof JBossJmsActivationSpecConfig) {
            this.populateJBossActivationSpecProperties(bw, (JBossJmsActivationSpecConfig)config);
        }
    }

    private void populateJBossActivationSpecProperties(BeanWrapper bw, JBossJmsActivationSpecConfig config) {
        if (bw.isWritableProperty("providerAdapterJNDI")) {
            bw.setPropertyValue("providerAdapterJNDI", (Object)config.getProviderAdapterJNDI());
        }
        if (bw.isWritableProperty("user")) {
            bw.setPropertyValue("user", (Object)config.getUser());
        }
        if (bw.isWritableProperty("password")) {
            bw.setPropertyValue("password", (Object)config.getPassword());
        }
        if (bw.isWritableProperty("maxSession")) {
            bw.setPropertyValue("maxSession", (Object)new Integer(config.getMaxConcurrency()));
        }
        if (bw.isWritableProperty("maxMessages")) {
            bw.setPropertyValue("maxMessages", (Object)new Integer(config.getPrefetchSize()));
        }
        if (bw.isWritableProperty("keepAlive")) {
            bw.setPropertyValue("keepAlive", (Object)config.getKeepAlive());
        }
        if (bw.isWritableProperty("reconnectInterval")) {
            bw.setPropertyValue("reconnectInterval", (Object)config.getReconnectInterval());
        }
        if (config.isSubscriptionDurable() && bw.isWritableProperty("subscriptionDurability")) {
            bw.setPropertyValue("subscriptionDurability", (Object)"Durable");
        }
        if (bw.isWritableProperty("subscriptionName")) {
            bw.setPropertyValue("subscriptionName", (Object)config.getDurableSubscriptionName());
        }
        if (bw.isWritableProperty("useDLQ")) {
            bw.setPropertyValue("useDLQ", (Object)config.isUseDLQ());
        }
        if (bw.isWritableProperty("dlqHandler")) {
            bw.setPropertyValue("dlqHandler", (Object)config.getDlqHandler());
        }
        if (bw.isWritableProperty("dlqUser")) {
            bw.setPropertyValue("dlqUser", (Object)config.getDlqUser());
        }
        if (bw.isWritableProperty("dlqPassword")) {
            bw.setPropertyValue("dlqPassword", (Object)config.getDlqPassword());
        }
        if (bw.isWritableProperty("dlqClientId")) {
            bw.setPropertyValue("dlqClientId", (Object)config.getDlqClientId());
        }
        if (bw.isWritableProperty("forceTransacted")) {
            bw.setPropertyValue("forceTransacted", (Object)config.isForceTransacted());
        }
    }
}

