/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.messagedriven.spring;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.log4j.Logger;
import org.ikasan.framework.initiator.messagedriven.ListenerSetupFailureListener;
import org.ikasan.framework.initiator.messagedriven.MessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class SpringMessageListenerContainer
extends DefaultMessageListenerContainer
implements MessageListenerContainer {
    private Logger logger = Logger.getLogger(SpringMessageListenerContainer.class);
    private boolean listenerSetupFailure = false;
    private ListenerSetupFailureListener listenerSetupExceptionListener;

    @Override
    public void setListenerSetupExceptionListener(ListenerSetupFailureListener listenerSetupExceptionListener) {
        this.listenerSetupExceptionListener = listenerSetupExceptionListener;
    }

    public boolean isListenerSetupFailure() {
        return this.listenerSetupFailure;
    }

    protected void handleListenerSetupFailure(Throwable ex, boolean alreadyRecovered) {
        super.handleListenerSetupFailure(ex, alreadyRecovered);
        this.logger.info((Object)("already recovered:" + alreadyRecovered + ", ex:" + ex));
        this.listenerSetupFailure = true;
        if (this.listenerSetupExceptionListener != null) {
            this.listenerSetupExceptionListener.notifyListenerSetupFailure(ex);
        }
    }

    protected boolean receiveAndExecute(Object invoker, Session session, MessageConsumer consumer) throws JMSException {
        boolean result = super.receiveAndExecute(invoker, session, consumer);
        this.listenerSetupFailure = false;
        return result;
    }
}

