/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.initiator.scheduled.quartz;

import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.impl.calendar.HolidayCalendar;
import org.springframework.beans.factory.FactoryBean;

public class HolidayCalendarFactory
implements FactoryBean {
    private static Logger logger = Logger.getLogger(HolidayCalendarFactory.class);
    private org.quartz.Calendar baseCalendar;
    private List<Calendar> excludedDates;

    public void setExcludedDates(List<Calendar> excludedDates) {
        this.excludedDates = excludedDates;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HolidayCalendar excluded date list [" + this.excludedDates.toString() + "]"));
        }
    }

    public void setBaseCalendar(org.quartz.Calendar baseCalendar) {
        this.baseCalendar = baseCalendar;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HolidayCalendar baseCalendar description [" + this.baseCalendar.getDescription() + "]"));
        }
    }

    public Object getObject() {
        HolidayCalendar holidayCalendar = new HolidayCalendar();
        if (this.baseCalendar != null) {
            holidayCalendar.setBaseCalendar(this.baseCalendar);
        }
        if (this.excludedDates != null) {
            for (Calendar excludedDate : this.excludedDates) {
                holidayCalendar.addExcludedDate(excludedDate.getTime());
            }
        }
        return holidayCalendar;
    }

    public Class<?> getObjectType() {
        return HolidayCalendar.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

