/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ikasan.framework.flow.Flow;
import org.ikasan.framework.initiator.Initiator;
import org.ikasan.framework.module.Module;

public class SimpleModule
implements Module {
    private List<Initiator> initiators;
    protected String name;
    private String description;

    public SimpleModule(String name, List<Initiator> initiators) {
        this(name);
        this.initiators = new ArrayList<Initiator>(initiators);
    }

    public SimpleModule(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Initiator getInitiator(String initiatorName) {
        Initiator initiator = null;
        for (Initiator thisInitiator : this.initiators) {
            if (!thisInitiator.getName().equals(initiatorName)) continue;
            initiator = thisInitiator;
            break;
        }
        return initiator;
    }

    @Override
    public List<Initiator> getInitiators() {
        return new ArrayList<Initiator>(this.initiators);
    }

    @Override
    public Map<String, Flow> getFlows() {
        HashMap<String, Flow> result = new HashMap<String, Flow>();
        for (Initiator initiator : this.initiators) {
            Flow flow = initiator.getFlow();
            result.put(flow.getName(), flow);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + " [");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",");
        sb.append("description=");
        sb.append(this.description);
        sb.append(",");
        sb.append("initiators=");
        sb.append(this.initiators);
        sb.append("]");
        return sb.toString();
    }
}

