/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.module.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.flow.initiator.dao.InitiatorStartupControlDao;
import org.ikasan.framework.initiator.Initiator;
import org.ikasan.framework.initiator.InitiatorStartupControl;
import org.ikasan.framework.module.Module;
import org.ikasan.framework.module.container.ModuleContainer;
import org.ikasan.framework.module.service.ModuleService;
import org.ikasan.framework.systemevent.service.SystemEventService;

public class ModuleServiceImpl
implements ModuleService {
    private SystemEventService systemEventService;
    private InitiatorStartupControlDao initiatorStartupControlDao;
    public static final String INITIATOR_START_REQUEST_SYSTEM_EVENT_ACTION = "Initiator start requested";
    public static final String INITIATOR_STOP_REQUEST_SYSTEM_EVENT_ACTION = "Initiator stop requested";
    public static final String INITIATOR_SET_STARTUP_TYPE_EVENT_ACTION = "Initiator StartupType set to: ";
    private Logger logger = Logger.getLogger(ModuleServiceImpl.class);
    private ModuleContainer moduleContainer;

    public ModuleServiceImpl(ModuleContainer moduleContainer, InitiatorStartupControlDao initiatorStartupControlDao, SystemEventService systemEventService) {
        this.moduleContainer = moduleContainer;
        this.initiatorStartupControlDao = initiatorStartupControlDao;
        this.systemEventService = systemEventService;
    }

    @Override
    public List<Module> getModules() {
        return this.moduleContainer.getModules();
    }

    @Override
    public Module getModule(String moduleName) {
        return this.moduleContainer.getModule(moduleName);
    }

    @Override
    public void stopInitiator(String moduleName, String initiatorName, String actor) {
        this.logger.info((Object)("stopInitiator : " + moduleName + "." + initiatorName + " requested by [" + actor + "]"));
        Initiator initiator = this.resolveInitiator(moduleName, initiatorName);
        this.systemEventService.logSystemEvent(moduleName + "." + initiatorName, INITIATOR_STOP_REQUEST_SYSTEM_EVENT_ACTION, actor);
        initiator.stop();
    }

    @Override
    public void startInitiator(String moduleName, String initiatorName, String actor) {
        this.logger.info((Object)("startInitiator : " + moduleName + "." + initiatorName + " requested by [" + actor + "]"));
        Initiator initiator = this.resolveInitiator(moduleName, initiatorName);
        InitiatorStartupControl initiatorStartupControl = this.initiatorStartupControlDao.getInitiatorStartupControl(moduleName, initiatorName);
        if (initiatorStartupControl.isDisabled()) {
            throw new IllegalStateException("Cannot start a disabled Initiator");
        }
        this.systemEventService.logSystemEvent(moduleName + "." + initiatorName, INITIATOR_START_REQUEST_SYSTEM_EVENT_ACTION, actor);
        initiator.start();
    }

    private Initiator resolveInitiator(String moduleName, String initiatorName) {
        Module module = this.getModule(moduleName);
        if (module == null) {
            throw new IllegalArgumentException("no such Module [" + moduleName + "]");
        }
        Initiator initiator = module.getInitiator(initiatorName);
        if (initiator == null) {
            throw new IllegalArgumentException("no such Initiator [" + initiatorName + "] for Module [" + moduleName + "]");
        }
        return initiator;
    }

    @Override
    public void updateInitiatorStartupType(String moduleName, String initiatorName, InitiatorStartupControl.StartupType startupType, String comment, String actor) {
        this.systemEventService.logSystemEvent(moduleName + "." + initiatorName, INITIATOR_SET_STARTUP_TYPE_EVENT_ACTION + startupType.toString(), actor);
        InitiatorStartupControl initiatorStartupControl = this.initiatorStartupControlDao.getInitiatorStartupControl(moduleName, initiatorName);
        initiatorStartupControl.setStartupType(startupType);
        initiatorStartupControl.setComment(comment);
        this.initiatorStartupControlDao.save(initiatorStartupControl);
    }

    @Override
    public InitiatorStartupControl getInitiatorStartupControl(String moduleName, String initiatorName) {
        return this.initiatorStartupControlDao.getInitiatorStartupControl(moduleName, initiatorName);
    }
}

