/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.ikasan.framework.initiator.InitiatorState;
import org.ikasan.framework.monitor.AbstractMonitorListener;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MonitorEmailNotifier
extends AbstractMonitorListener {
    private static final Logger logger = Logger.getLogger(MonitorEmailNotifier.class);
    private JavaMailSender mailSender;
    private String from;
    private String body;
    private String environment;
    private Map<String, List<String>> stateToDistributionListMap;

    public MonitorEmailNotifier(String name, JavaMailSender mailSender, String to, String environment) {
        super(name);
        this.environment = environment;
        this.mailSender = mailSender;
        ArrayList<String> toList = new ArrayList<String>();
        toList.add(to);
        this.stateToDistributionListMap = new HashMap<String, List<String>>();
        this.stateToDistributionListMap.put(InitiatorState.ERROR.getName(), toList);
    }

    public MonitorEmailNotifier(String name, JavaMailSender mailSender, List<String> to, String environment) {
        super(name);
        this.environment = environment;
        this.mailSender = mailSender;
        this.stateToDistributionListMap = new HashMap<String, List<String>>();
        this.stateToDistributionListMap.put(InitiatorState.ERROR.getName(), to);
    }

    public MonitorEmailNotifier(String name, JavaMailSender mailSender, Map<String, List<String>> stateToDistributionListMap, String environment) {
        super(name);
        this.environment = environment;
        this.mailSender = mailSender;
        this.stateToDistributionListMap = stateToDistributionListMap;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public void notify(String state) {
        try {
            if (this.stateToDistributionListMap.containsKey(state)) {
                List<String> recipientList = this.stateToDistributionListMap.get(state);
                MimeMessage email = this.mailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(email);
                if (this.from != null) {
                    helper.setFrom(this.from);
                }
                helper.setTo(recipientList.toArray(new String[recipientList.size()]));
                helper.setSubject("[" + this.environment + "] Initiator Email Notifier");
                String text = "Initiator [" + this.getName() + "] is reporting status [" + state + "].";
                if (this.body != null) {
                    text = text + this.body;
                }
                helper.setText(text);
                this.mailSender.send(email);
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Monitor failed to create email notification.");
        }
    }
}

