/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.monitor;

import java.util.Calendar;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.ikasan.common.component.ComponentState;
import org.ikasan.common.component.Status;
import org.ikasan.framework.monitor.AbstractMonitorListener;

public class MonitorJNDINotifier
extends AbstractMonitorListener {
    private static Logger logger = Logger.getLogger(MonitorJNDINotifier.class);
    protected Context context;
    protected String url;
    protected Status status;

    public MonitorJNDINotifier(String name, Context context, String url) {
        super(name);
        this.context = context;
        this.url = url;
    }

    @Override
    public void notify(String text) {
        ComponentState componentState = MonitorJNDINotifier.getComponentState(text);
        this.status = new Status(componentState, new Long(Calendar.getInstance().getTimeInMillis()));
        try {
            this.bindStatus(this.status);
        }
        catch (NamingException e) {
            logger.warn((Object)("Monitor listener [" + this.getName() + "] failed to set initiator state."), (Throwable)e);
        }
    }

    protected static ComponentState getComponentState(String state) {
        if (state != null) {
            if (state.equals("stoppedInError")) {
                return ComponentState.ERROR;
            }
            if (state.equals("stopped")) {
                return ComponentState.STOPPED;
            }
            if (state.equals("runningInRecovery")) {
                return ComponentState.RECOVERING;
            }
            if (state.equals("running")) {
                return ComponentState.RUNNING;
            }
        }
        logger.warn((Object)("State [" + state + "] not supported. Defaulting to 'Unknown' state."));
        return ComponentState.UNKNOWN;
    }

    protected void bindStatus(Status statusToBind) throws NamingException {
        try {
            this.context.bind(this.url, (Object)statusToBind);
        }
        catch (NameNotFoundException e) {
            this.createContext();
            this.context.rebind(this.url, (Object)statusToBind);
        }
        catch (NameAlreadyBoundException e) {
            this.context.rebind(this.url, (Object)statusToBind);
        }
    }

    private void createContext() throws NamingException {
        Name parsedUrl = this.context.getNameParser("").parse(this.url);
        Context subctx = this.context;
        for (int pos = 0; pos < parsedUrl.size(); ++pos) {
            String ctxName = parsedUrl.get(pos);
            try {
                subctx = (Context)subctx.lookup(ctxName);
                continue;
            }
            catch (NameNotFoundException e) {
                subctx = subctx.createSubcontext(ctxName);
            }
        }
    }
}

