/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.payload.dao;

import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.framework.payload.service.DatabaseHousekeeper;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateDatabaseHousekeeper
extends HibernateDaoSupport
implements DatabaseHousekeeper {
    private static final int ALL_RECORDS = -1;
    private String hibernateQuery;
    private int maxResultSetSize = -1;
    private Logger localLogger = Logger.getLogger(HibernateDatabaseHousekeeper.class);

    public HibernateDatabaseHousekeeper(int maxResultSetSize, String hibernateQuery) {
        this.maxResultSetSize = maxResultSetSize;
        this.hibernateQuery = hibernateQuery;
    }

    @Override
    public void housekeep() {
        this.localLogger.info((Object)"Querying for housekeepables...");
        if (this.maxResultSetSize != -1) {
            this.localLogger.info((Object)("Limiting the size of housekeepables to [" + this.maxResultSetSize + "]"));
            this.getHibernateTemplate().setMaxResults(this.maxResultSetSize);
        }
        List housekeepables = this.getHibernateTemplate().find(this.hibernateQuery);
        this.localLogger.info((Object)("found [" + housekeepables.size() + "] housekeepables"));
        for (Object housekeepable : housekeepables) {
            this.localLogger.debug((Object)("about to housekeep [" + housekeepable + "]"));
            this.getHibernateTemplate().delete(housekeepable);
        }
    }
}

