/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.payload.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.common.factory.PayloadFactory;
import org.ikasan.framework.payload.dao.DatabasePayloadDao;
import org.ikasan.framework.payload.model.DatabasePayload;
import org.ikasan.framework.payload.service.DatabaseHousekeeper;
import org.ikasan.framework.payload.service.PayloadProvider;

public class DatabasePayloadProvider
implements PayloadProvider {
    private DatabasePayloadDao dao;
    private PayloadFactory payloadFactory;
    private boolean destructiveRead;
    private DatabaseHousekeeper housekeeper;
    private Logger logger = Logger.getLogger(DatabasePayloadProvider.class);

    public DatabasePayloadProvider(DatabasePayloadDao dao, PayloadFactory payloadFactory, DatabaseHousekeeper databasePayloadHouseKeepingMatcher, boolean destructiveRead) {
        if (databasePayloadHouseKeepingMatcher != null && destructiveRead) {
            throw new IllegalArgumentException("Destructive Read and housekeeping are mutually exclusive");
        }
        this.dao = dao;
        if (this.dao == null) {
            throw new IllegalArgumentException("dao cannot be 'null'");
        }
        this.payloadFactory = payloadFactory;
        if (this.payloadFactory == null) {
            throw new IllegalArgumentException("payloadFactory cannot be 'null'");
        }
        this.housekeeper = databasePayloadHouseKeepingMatcher;
        this.destructiveRead = destructiveRead;
    }

    @Override
    public List<Payload> getNextRelatedPayloads() {
        ArrayList<Payload> result = null;
        this.logger.debug((Object)"about to request unconsumed from dao");
        List<DatabasePayload> unconsumedPayloads = this.dao.findUnconsumed();
        this.logger.debug((Object)"back from request for unconsumed from dao");
        if (!unconsumedPayloads.isEmpty()) {
            result = new ArrayList<Payload>();
            for (DatabasePayload databasePayload : unconsumedPayloads) {
                this.logger.info((Object)("consuming DatabasePayload with id [" + databasePayload.getId() + "]"));
                byte[] payloadContent = databasePayload.getEvent().getBytes();
                Payload payload = this.payloadFactory.newPayload(databasePayload.getId().toString(), payloadContent);
                payload.setContent(payloadContent);
                result.add(payload);
                databasePayload.setConsumed(true);
                databasePayload.setLastUpdated(new Date());
                if (this.destructiveRead) {
                    this.logger.info((Object)("deleting (destructive read) DatabasePayload with id [" + databasePayload.getId() + "]"));
                    this.dao.delete(databasePayload);
                    continue;
                }
                this.dao.save(databasePayload);
            }
        }
        if (this.housekeeper != null) {
            this.logger.debug((Object)"attempting to housekeep");
            this.housekeeper.housekeep();
        } else {
            this.logger.debug((Object)"housekeeping not configured");
        }
        return result;
    }
}

