/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.payload.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.resource.ResourceException;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.payload.service.PayloadInputStreamAcquirer;
import org.ikasan.framework.payload.service.PayloadPublisher;

public class FileSystemInputStreamPayloadPublisher
implements PayloadPublisher {
    private PayloadInputStreamAcquirer payloadInputStreamProvider;
    private String outputDir;
    private Logger logger = Logger.getLogger(FileSystemInputStreamPayloadPublisher.class);

    public FileSystemInputStreamPayloadPublisher(String outputDir, PayloadInputStreamAcquirer payloadInputStreamProvider) {
        this.outputDir = outputDir;
        this.payloadInputStreamProvider = payloadInputStreamProvider;
    }

    @Override
    public void publish(Payload payload) throws ResourceException {
        File parentDir = new File(this.outputDir);
        if (!parentDir.exists()) {
            this.logger.error((Object)("directory does not exist [" + parentDir.getAbsolutePath() + "]"));
            throw new ResourceException("Parent directory does not exist on local file system [" + parentDir.getAbsolutePath() + "]");
        }
        if (!parentDir.isDirectory()) {
            this.logger.error((Object)("path does not refer to a directory [" + parentDir.getAbsolutePath() + "]"));
            throw new ResourceException("Parent directory is not a directory [" + parentDir.getAbsolutePath() + "]");
        }
        File file = new File(parentDir, payload.getAttribute("fileName"));
        FileOutputStream fileOutputStream = null;
        try {
            file.createNewFile();
            InputStream inputStream = this.payloadInputStreamProvider.acquireInputStream(payload);
            fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int result = 0;
            while (result != -1) {
                result = inputStream.read();
                if (result == -1) continue;
                bufferedOutputStream.write(result);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"Exception writing to fileSystem", (Throwable)e);
            throw new ResourceException((Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Exception writing to fileSystem", (Throwable)e);
            throw new ResourceException((Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Exception closing FileOutputStream", (Throwable)e);
                    throw new ResourceException((Throwable)e);
                }
            }
        }
    }
}

