/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.payload.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.resource.ResourceException;
import org.apache.log4j.Logger;
import org.ikasan.common.Payload;
import org.ikasan.framework.payload.service.PayloadPublisher;

public class FileSystemPayloadPublisher
implements PayloadPublisher {
    String outputPath = null;
    private static Logger logger = Logger.getLogger(FileSystemPayloadPublisher.class);

    public FileSystemPayloadPublisher(String outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public void publish(Payload payload) throws ResourceException {
        logger.info((Object)("publishing payload [" + payload.getId() + "] with name [" + payload.getAttribute("fileName") + "]"));
        if (!this.isOutputPathADirectory()) {
            logger.warn((Object)("Output path [" + this.outputPath + "] is not a valid directory."));
            throw new ResourceException("Output path [" + this.outputPath + "] is not a valid directory");
        }
        byte[] payloadContent = payload.getContent();
        ByteBuffer inByteBuffer = ByteBuffer.wrap(payloadContent);
        String fileName = payload.getAttribute("fileName");
        FileOutputStream fos = null;
        AbstractInterruptibleChannel ofc = null;
        try {
            File outputFile = new File(this.outputPath);
            logger.info((Object)("Publishing to [" + outputFile.getAbsolutePath() + "]"));
            fos = new FileOutputStream(outputFile.getAbsolutePath() + File.separator + fileName);
            ofc = fos.getChannel();
            ((FileChannel)ofc).write(inByteBuffer);
            ((FileChannel)ofc).force(false);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            try {
                if (ofc != null) {
                    ofc.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {
                throw new ResourceException((Throwable)ioe);
            }
        }
    }

    private boolean isOutputPathADirectory() {
        if (this.outputPath == null) {
            return false;
        }
        File outputPathDirectory = new File(this.outputPath);
        return outputPathDirectory.isDirectory();
    }
}

