/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.plugins;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.ikasan.common.security.IkasanSecurityConf;
import org.ikasan.framework.component.Event;
import org.ikasan.framework.event.serialisation.JmsMessageEventSerialiser;
import org.ikasan.framework.messaging.jms.JndiDestinationFactory;
import org.ikasan.framework.plugins.EventInvocable;
import org.ikasan.framework.plugins.invoker.PluginInvocationException;

public class JMSEventPublisherPlugin
implements EventInvocable {
    private static Logger logger = Logger.getLogger(JMSEventPublisherPlugin.class);
    private Destination destination;
    private JndiDestinationFactory jndiDestinationFactory;
    private ConnectionFactory connectionFactory;
    private IkasanSecurityConf ikasanSecurityConf;
    private JmsMessageEventSerialiser<? extends Message> jmsMessageEventSerialiser;
    private Long timeToLive;
    private Integer priority;

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public JMSEventPublisherPlugin(Destination destination, ConnectionFactory connectionFactory, JmsMessageEventSerialiser<?> jmsMessageEventSerialiser, IkasanSecurityConf ikasanSecurityConf) {
        this.destination = destination;
        this.connectionFactory = connectionFactory;
        this.jmsMessageEventSerialiser = jmsMessageEventSerialiser;
        this.ikasanSecurityConf = ikasanSecurityConf;
    }

    public JMSEventPublisherPlugin(JndiDestinationFactory jndiDestinationFactory, ConnectionFactory connectionFactory, JmsMessageEventSerialiser<?> jmsMessageEventSerialiser, IkasanSecurityConf ikasanSecurityConf) {
        this.jndiDestinationFactory = jndiDestinationFactory;
        this.connectionFactory = connectionFactory;
        this.jmsMessageEventSerialiser = jmsMessageEventSerialiser;
        this.ikasanSecurityConf = ikasanSecurityConf;
    }

    @Override
    public void invoke(Event event) throws PluginInvocationException {
        Destination thisDestination;
        try {
            thisDestination = this.destination != null ? this.destination : this.jndiDestinationFactory.getDestination(true);
        }
        catch (NamingException e1) {
            throw new PluginInvocationException("NamingException caught whilst attempting to find destination with jndiName[" + this.jndiDestinationFactory.getJndiName() + "], environment[" + this.jndiDestinationFactory.getEnvironment() + "]", e1);
        }
        Connection connection = null;
        try {
            connection = this.createConnection();
            Session session = connection.createSession(true, 1);
            Message message = this.jmsMessageEventSerialiser.toMessage(event, session);
            MessageProducer messageProducer = session.createProducer(thisDestination);
            if (this.timeToLive != null) {
                messageProducer.setTimeToLive(this.timeToLive.longValue());
            }
            messageProducer.setPriority(this.priority != null ? this.priority.intValue() : event.getPriority());
            messageProducer.send(message);
            logger.info((Object)("successfully sent message to destination [" + thisDestination + "]. " + event.idToString()));
        }
        catch (JMSException e) {
            throw new PluginInvocationException("JMS Exception caught whilst publishing", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    throw new PluginInvocationException("JMS Exception caught when closing connection", e);
                }
            }
        }
    }

    private Connection createConnection() throws JMSException {
        Connection connection = this.ikasanSecurityConf != null ? this.connectionFactory.createConnection(this.ikasanSecurityConf.getJMSUsername(), this.ikasanSecurityConf.getJMSPassword()) : this.connectionFactory.createConnection();
        return connection;
    }
}

