/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.security.service;

import java.util.List;
import org.ikasan.framework.security.dao.AuthorityDao;
import org.ikasan.framework.security.dao.UserDao;
import org.ikasan.framework.security.model.Authority;
import org.ikasan.framework.security.model.User;
import org.ikasan.framework.security.service.UserService;
import org.springframework.dao.DataAccessException;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserServiceImpl
implements UserService {
    private UserDao userDao;
    private AuthorityDao authorityDao;
    private PasswordEncoder passwordEncoder;

    public UserServiceImpl(UserDao userDao, AuthorityDao authorityDao, PasswordEncoder passwordEncoder) {
        this.userDao = userDao;
        this.authorityDao = authorityDao;
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public List<User> getUsers() {
        return this.userDao.getUsers();
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException("As administrators can change passwords for other users we have our own userChangePasssword method.");
    }

    public void createUser(UserDetails userDetails) {
        String username = userDetails.getUsername();
        String password = userDetails.getPassword();
        String email = "";
        if (userDetails instanceof User) {
            User tempUser = (User)userDetails;
            email = tempUser.getEmail();
        }
        boolean enabled = userDetails.isEnabled();
        if (username == null || "".equals(username)) {
            throw new IllegalArgumentException("userDetails must contain a non empty username");
        }
        if (password == null || "".equals(password)) {
            throw new IllegalArgumentException("userDetails must contain a non empty password");
        }
        if (email == null || "".equals(email)) {
            throw new IllegalArgumentException("user must contain a non empty email address");
        }
        if (this.userExists(username)) {
            throw new IllegalArgumentException("userDetails must contain a unique username");
        }
        String encodedPassword = this.passwordEncoder.encodePassword(password, null);
        User userToCreate = new User(username, encodedPassword, email, enabled);
        this.userDao.save(userToCreate);
    }

    public void deleteUser(String username) {
        this.userDao.delete(this.getUserForOperation(username));
    }

    @Override
    public void disableUser(String username) {
        User user = this.getUserForOperation(username);
        user.setEnabled(false);
        this.userDao.save(user);
    }

    @Override
    public void enableUser(String username) {
        User user = this.getUserForOperation(username);
        user.setEnabled(true);
        this.userDao.save(user);
    }

    private User getUserForOperation(String username) throws IllegalArgumentException {
        User user = this.userDao.getUser(username);
        if (user == null) {
            throw new IllegalArgumentException("user does not exist with username [" + username + "]");
        }
        return user;
    }

    public void updateUser(UserDetails userDetails) {
        this.userDao.save((User)userDetails);
    }

    public boolean userExists(String username) {
        return this.userDao.getUser(username) != null;
    }

    @Override
    public User loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User user = this.userDao.getUser(username);
        if (user == null) {
            throw new UsernameNotFoundException("Unknown username : " + username);
        }
        return user;
    }

    @Override
    public List<Authority> getAuthorities() {
        return this.authorityDao.getAuthorities();
    }

    @Override
    public void grantAuthority(String username, String authority) {
        User user = this.loadUserByUsername(username);
        Authority nongrantedAuthority = this.authorityDao.getAuthority(authority);
        user.grantAuthority(nongrantedAuthority);
        this.userDao.save(user);
    }

    @Override
    public void revokeAuthority(String username, String authority) {
        User user = this.loadUserByUsername(username);
        Authority grantedAuthority = this.authorityDao.getAuthority(authority);
        user.revokeAuthority(grantedAuthority);
        this.userDao.save(user);
    }

    @Override
    public void changeUsersPassword(String username, String newPassword, String confirmNewPassword) throws IllegalArgumentException {
        if (!newPassword.equals(confirmNewPassword)) {
            throw new IllegalArgumentException("Passwords do not match, please try again.");
        }
        String encodedPassword = this.passwordEncoder.encodePassword(newPassword, null);
        User user = this.loadUserByUsername(username);
        user.setPassword(encodedPassword);
        this.userDao.save(user);
    }

    @Override
    public void changeUsersEmail(String username, String newEmail) throws IllegalArgumentException {
        User user = null;
        try {
            user = this.loadUserByUsername(username);
        }
        catch (UsernameNotFoundException e) {
            throw new IllegalArgumentException("Username could not be found", e);
        }
        catch (DataAccessException e) {
            throw new IllegalArgumentException("Username could not be found due to a DataAccessException", e);
        }
        user.setEmail(newEmail);
        this.userDao.save(user);
    }

    @Override
    public void createAuthority(Authority newAuthority) {
        if (this.authorityDao.getAuthorities().contains(newAuthority)) {
            throw new IllegalArgumentException("Cannot create new authority [" + newAuthority + "] as it already exists!");
        }
        this.authorityDao.save(newAuthority);
    }
}

