/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.systemevent.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.ikasan.framework.management.search.ArrayListPagedSearchResult;
import org.ikasan.framework.management.search.PagedSearchResult;
import org.ikasan.framework.systemevent.dao.SystemEventDao;
import org.ikasan.framework.systemevent.model.SystemEvent;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateSystemEventDao
extends HibernateDaoSupport
implements SystemEventDao {
    private static final String HOUSEKEEP_QUERY = "delete SystemEvent w where w.expiry <= ?";
    private static final String BATCHED_HOUSEKEEP_QUERY = "delete SystemEvent s where s.id in (:event_ids)";
    private boolean batchHousekeepDelete = false;
    private Integer housekeepingBatchSize = null;
    private static final Logger logger = Logger.getLogger(HibernateSystemEventDao.class);

    public HibernateSystemEventDao(boolean batchHousekeepDelete, Integer housekeepingBatchSize) {
        this();
        this.batchHousekeepDelete = batchHousekeepDelete;
        this.housekeepingBatchSize = housekeepingBatchSize;
    }

    public HibernateSystemEventDao() {
    }

    @Override
    public void save(SystemEvent systemEvent) {
        this.getHibernateTemplate().save((Object)systemEvent);
    }

    @Override
    public PagedSearchResult<SystemEvent> find(final int pageNo, final int pageSize, String orderBy, boolean orderAscending, final String subject, final String action, final Date timestampFrom, final Date timestampTo, final String actor) {
        return (PagedSearchResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(SystemEvent.class, "event");
                criteria.setMaxResults(pageSize);
                int firstResult = pageNo * pageSize;
                criteria.setFirstResult(firstResult);
                criteria.addOrder(Order.desc((String)"id"));
                if (HibernateSystemEventDao.restrictionExists(subject)) {
                    criteria.add((Criterion)Restrictions.eq((String)"subject", (Object)subject));
                }
                if (HibernateSystemEventDao.restrictionExists(action)) {
                    criteria.add((Criterion)Restrictions.eq((String)"action", (Object)action));
                }
                if (HibernateSystemEventDao.restrictionExists(actor)) {
                    criteria.add((Criterion)Restrictions.eq((String)"actor", (Object)actor));
                }
                if (HibernateSystemEventDao.restrictionExists(timestampFrom)) {
                    criteria.add((Criterion)Restrictions.gt((String)"timestamp", (Object)timestampFrom));
                }
                if (HibernateSystemEventDao.restrictionExists(timestampTo)) {
                    criteria.add((Criterion)Restrictions.lt((String)"timestamp", (Object)timestampTo));
                }
                List systemEventResults = criteria.list();
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                return new ArrayListPagedSearchResult(systemEventResults, firstResult, rowCount);
            }
        });
    }

    static final boolean restrictionExists(Object restrictionValue) {
        return restrictionValue != null && !"".equals(restrictionValue);
    }

    @Override
    public void deleteExpired() {
        if (!this.batchHousekeepDelete) {
            this.getHibernateTemplate().bulkUpdate(HOUSEKEEP_QUERY, (Object)new Date());
        } else {
            this.batchHousekeepDelete();
        }
    }

    private void batchHousekeepDelete() {
        logger.info((Object)"called");
        while (this.housekeepablesExist()) {
            final List<Long> housekeepableBatch = this.getHousekeepableBatch();
            this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(HibernateSystemEventDao.BATCHED_HOUSEKEEP_QUERY);
                    query.setParameterList("event_ids", (Collection)housekeepableBatch);
                    query.executeUpdate();
                    return null;
                }
            });
        }
    }

    private List<Long> getHousekeepableBatch() {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ArrayList<Long> ids = new ArrayList<Long>();
                Criteria criteria = session.createCriteria(SystemEvent.class);
                criteria.add((Criterion)Restrictions.lt((String)"expiry", (Object)new Date()));
                criteria.setMaxResults(HibernateSystemEventDao.this.housekeepingBatchSize.intValue());
                for (Object systemEventObj : criteria.list()) {
                    SystemEvent systemEvent = (SystemEvent)systemEventObj;
                    ids.add(systemEvent.getId());
                }
                return ids;
            }
        });
    }

    private boolean housekeepablesExist() {
        return (Boolean)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(SystemEvent.class);
                criteria.add((Criterion)Restrictions.lt((String)"expiry", (Object)new Date()));
                criteria.setProjection(Projections.rowCount());
                Long rowCount = new Long(0L);
                List rowCountList = criteria.list();
                if (!rowCountList.isEmpty()) {
                    rowCount = (Long)rowCountList.get(0);
                }
                logger.info((Object)(rowCount + ", housekeepables exist"));
                return new Boolean(rowCount > 0L);
            }
        });
    }
}

