/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.framework.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AggregatedContentInputStream
extends InputStream {
    private static final int STATE_BEFORE_START = 0;
    private static final int STATE_CONSUMING_HEADER = 1;
    private static final int STATE_BEFORE_CONTENT = 2;
    private static final int STATE_CONSUMING_CONTENT = 3;
    private static final int STATE_AFTER_CONTENT = 4;
    private static final int STATE_CONSUMING_FOOTER = 5;
    private static final int STATE_AFTER_FOOTER = 6;
    private int state = 0;
    private InputStream inputStream;

    @Override
    public int read() throws IOException {
        if (this.state == 0) {
            this.rolloverInputStream();
        }
        if (this.inputStream == null) {
            return -1;
        }
        int result = this.inputStream.read();
        if (result == -1) {
            this.rolloverInputStream();
            result = this.read();
        }
        return result;
    }

    private void rolloverInputStream() throws IOException {
        this.inputStream = null;
        if (this.state == 0) {
            this.attemptHeader();
        } else if (this.state == 1) {
            this.attemptContentBlock();
        } else if (this.state == 3) {
            this.attemptAfterContent();
        } else if (this.state == 2) {
            this.inputStream = new ByteArrayInputStream(this.getNextContent());
            this.state = 3;
        } else if (this.state == 4) {
            if (this.hasMoreContent()) {
                this.attemptBeforeContent();
            } else {
                this.attemptFooter();
            }
        } else if (this.state == 5) {
            this.state = 6;
        }
    }

    private void attemptFooter() throws IOException {
        this.state = 5;
        byte[] footer = this.getFooter();
        if (footer != null && footer.length > 0) {
            this.inputStream = new ByteArrayInputStream(this.getFooter());
        } else {
            this.rolloverInputStream();
        }
    }

    private void attemptAfterContent() throws IOException {
        this.state = 4;
        byte[] afterContent = this.getAfterContent();
        if (afterContent != null && afterContent.length > 0) {
            this.inputStream = new ByteArrayInputStream(this.getAfterContent());
        } else {
            this.rolloverInputStream();
        }
    }

    private void attemptContentBlock() throws IOException {
        if (this.hasMoreContent()) {
            this.attemptBeforeContent();
        } else {
            this.state = 4;
            this.rolloverInputStream();
        }
    }

    private void attemptHeader() throws IOException {
        this.state = 1;
        byte[] header = this.getHeader();
        if (header != null && header.length > 0) {
            this.inputStream = new ByteArrayInputStream(header);
        } else {
            this.rolloverInputStream();
        }
    }

    private void attemptBeforeContent() throws IOException {
        this.state = 2;
        byte[] beforeContent = this.getBeforeContent();
        if (beforeContent != null && beforeContent.length > 0) {
            this.inputStream = new ByteArrayInputStream(beforeContent);
        } else {
            this.rolloverInputStream();
        }
    }

    protected byte[] getFooter() {
        return new byte[0];
    }

    protected byte[] getAfterContent() {
        return new byte[0];
    }

    protected byte[] getBeforeContent() {
        return new byte[0];
    }

    protected byte[] getHeader() {
        return new byte[0];
    }

    protected abstract byte[] getNextContent();

    protected abstract boolean hasMoreContent();
}

