/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ikasan.job.orchestration.model.context.ContextTransition;
import org.ikasan.job.orchestration.model.instance.ContextParameterInstanceImpl;
import org.ikasan.job.orchestration.model.status.ContextJobInstanceDetailsStatusImpl;
import org.ikasan.job.orchestration.model.status.ContextJobInstanceStatusImpl;
import org.ikasan.job.orchestration.util.AggregateContextInstanceStatus;
import org.ikasan.spec.scheduled.context.model.And;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.JobDependency;
import org.ikasan.spec.scheduled.context.model.LogicalGrouping;
import org.ikasan.spec.scheduled.context.model.Not;
import org.ikasan.spec.scheduled.context.model.Or;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.InternalEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.QuartzScheduleDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.job.model.GlobalEventJob;
import org.ikasan.spec.scheduled.job.model.InternalEventDrivenJob;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;
import org.ikasan.spec.scheduled.status.model.ContextJobInstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHelper {
    static Logger logger = LoggerFactory.getLogger(ContextHelper.class);
    private static String AGENT_NAME_REPLACEMENT = "[[agent.name]]";
    private static String CONTEXT_NAME_REPLACEMENT = "[[context.name]]";
    private static String ENV_NAME_REPLACEMENT = "[[env.name]]";
    private static boolean USE_UNDERSCORE_SEPARATED_CONTEXT_NAME_CONVENTION = true;
    public static final String GLOBAL_EVENT = "GLOBAL_EVENT";

    public static void addSchedulerJobReplacementTokens(SchedulerJob schedulerJob) {
        if (!schedulerJob.getAgentName().equals(GLOBAL_EVENT)) {
            schedulerJob.setAgentName(AGENT_NAME_REPLACEMENT);
        }
        schedulerJob.setContextName(ContextHelper.getContextName(schedulerJob.getContextName()));
        if (!(schedulerJob instanceof GlobalEventJob)) {
            schedulerJob.setIdentifier(AGENT_NAME_REPLACEMENT + "-" + schedulerJob.getJobName());
        }
    }

    public static void addContextTemplateReplacementTokens(ContextTemplate contextTemplate) {
        ContextHelper._addContextTemplateReplacementTokens(contextTemplate);
        contextTemplate.setName(ContextHelper.getContextName(contextTemplate.getName()));
    }

    private static void _addContextTemplateReplacementTokens(ContextTemplate contextTemplate) {
        if (contextTemplate.getScheduledJobs() != null && !contextTemplate.getScheduledJobs().isEmpty()) {
            contextTemplate.getScheduledJobs().forEach(schedulerJob -> {
                contextTemplate.getJobDependencies().forEach(jobDependency -> ContextHelper.replaceJobIdentifierJobDependency(schedulerJob, jobDependency));
                if (!schedulerJob.getAgentName().equals(GLOBAL_EVENT)) {
                    schedulerJob.setAgentName(AGENT_NAME_REPLACEMENT);
                    schedulerJob.setIdentifier(AGENT_NAME_REPLACEMENT + "-" + schedulerJob.getJobName());
                }
            });
        }
        if (contextTemplate.getJobLocks() != null) {
            contextTemplate.getJobLocks().forEach(jobLock -> jobLock.getJobs().entrySet().forEach(entry -> ((List)entry.getValue()).forEach(job -> {
                if (job.getContextName() != null) {
                    job.setContextName(ContextHelper.getContextName(job.getContextName()));
                }
                if (!job.getAgentName().equals(GLOBAL_EVENT)) {
                    job.setAgentName(AGENT_NAME_REPLACEMENT);
                    job.setIdentifier(AGENT_NAME_REPLACEMENT + "-" + job.getJobName());
                }
            })));
        }
        if (contextTemplate.getContexts() != null) {
            contextTemplate.getContexts().forEach(child -> ContextHelper._addContextTemplateReplacementTokens(child));
        }
    }

    private static String getContextName(String contextName) {
        if (contextName.equals(GLOBAL_EVENT)) {
            return contextName;
        }
        if (!USE_UNDERSCORE_SEPARATED_CONTEXT_NAME_CONVENTION) {
            return CONTEXT_NAME_REPLACEMENT;
        }
        if (!contextName.contains("_")) {
            return contextName + "_" + ENV_NAME_REPLACEMENT;
        }
        return contextName.substring(0, contextName.lastIndexOf("_")) + "_" + ENV_NAME_REPLACEMENT;
    }

    private static void replaceJobIdentifierJobDependency(SchedulerJob schedulerJob, JobDependency jobDependency) {
        if (jobDependency.getJobIdentifier().equals(schedulerJob.getIdentifier()) && !schedulerJob.getIdentifier().startsWith(GLOBAL_EVENT)) {
            jobDependency.setJobIdentifier(AGENT_NAME_REPLACEMENT + "-" + schedulerJob.getJobName());
        }
        if (jobDependency.getLogicalGrouping() != null) {
            ContextHelper.replaceJobIdentifierLogicalGrouping(schedulerJob, jobDependency.getLogicalGrouping());
        }
    }

    private static void replaceJobIdentifierLogicalGrouping(SchedulerJob schedulerJob, LogicalGrouping logicalGrouping) {
        if (logicalGrouping.getAnd() != null) {
            logicalGrouping.getAnd().forEach(and -> {
                if (schedulerJob.getIdentifier().equals(and.getIdentifier())) {
                    ContextHelper.replaceJobIdentifierAnd(schedulerJob, and);
                    if (and.getLogicalGrouping() != null) {
                        ContextHelper.replaceJobIdentifierLogicalGrouping(schedulerJob, and.getLogicalGrouping());
                    }
                }
            });
        }
        if (logicalGrouping.getOr() != null) {
            logicalGrouping.getOr().forEach(or -> {
                if (schedulerJob.getIdentifier().equals(or.getIdentifier())) {
                    ContextHelper.replaceJobIdentifierOr(schedulerJob, or);
                    if (or.getLogicalGrouping() != null) {
                        ContextHelper.replaceJobIdentifierLogicalGrouping(schedulerJob, or.getLogicalGrouping());
                    }
                }
            });
        }
        if (logicalGrouping.getNot() != null) {
            logicalGrouping.getNot().forEach(not -> {
                if (schedulerJob.getIdentifier().equals(not.getIdentifier())) {
                    ContextHelper.replaceJobIdentifierNot(schedulerJob, not);
                    if (not.getLogicalGrouping() != null) {
                        ContextHelper.replaceJobIdentifierLogicalGrouping(schedulerJob, not.getLogicalGrouping());
                    }
                }
            });
        }
        if (logicalGrouping.getLogicalGrouping() != null) {
            ContextHelper.replaceJobIdentifierLogicalGrouping(schedulerJob, logicalGrouping.getLogicalGrouping());
        }
    }

    private static void replaceJobIdentifierAnd(SchedulerJob schedulerJob, And and) {
        if (and.getIdentifier().startsWith(GLOBAL_EVENT)) {
            return;
        }
        and.setIdentifier(AGENT_NAME_REPLACEMENT + "-" + schedulerJob.getJobName());
    }

    private static void replaceJobIdentifierOr(SchedulerJob schedulerJob, Or or) {
        if (or.getIdentifier().startsWith(GLOBAL_EVENT)) {
            return;
        }
        or.setIdentifier(AGENT_NAME_REPLACEMENT + "-" + schedulerJob.getJobName());
    }

    private static void replaceJobIdentifierNot(SchedulerJob schedulerJob, Not not) {
        if (not.getIdentifier().startsWith(GLOBAL_EVENT)) {
            return;
        }
        not.setIdentifier(AGENT_NAME_REPLACEMENT + "-" + schedulerJob.getJobName());
    }

    public static List<ContextParameterInstance> getUniqueContextParameterInstancesFromJobInstances(Map<String, InternalEventDrivenJobInstance> internalJobs) {
        ArrayList contextParameterInstances = new ArrayList();
        internalJobs.entrySet().forEach(entry -> contextParameterInstances.addAll(((InternalEventDrivenJobInstance)entry.getValue()).getContextParameters().stream().map(contextParameter -> {
            ContextParameterInstanceImpl contextParameterInstance = new ContextParameterInstanceImpl();
            contextParameterInstance.setName(contextParameter.getName());
            contextParameterInstance.setValue(contextParameter.getDefaultValue());
            contextParameterInstance.setDefaultValue(contextParameter.getDefaultValue());
            return contextParameterInstance;
        }).collect(Collectors.toList())));
        return contextParameterInstances.stream().filter(ContextHelper.distinctByKey(contextParameterInstance -> contextParameterInstance.getName())).collect(Collectors.toList());
    }

    public static List<ContextParameterInstance> getUniqueContextParameterInstancesFromJobs(Map<String, InternalEventDrivenJob> internalJobs) {
        ArrayList contextParameterInstances = new ArrayList();
        internalJobs.entrySet().forEach(entry -> contextParameterInstances.addAll(((InternalEventDrivenJob)entry.getValue()).getContextParameters().stream().map(contextParameter -> {
            ContextParameterInstanceImpl contextParameterInstance = new ContextParameterInstanceImpl();
            contextParameterInstance.setName(contextParameter.getName());
            contextParameterInstance.setValue(contextParameter.getDefaultValue());
            contextParameterInstance.setDefaultValue(contextParameter.getDefaultValue());
            return contextParameterInstance;
        }).collect(Collectors.toList())));
        return contextParameterInstances.stream().filter(ContextHelper.distinctByKey(contextParameterInstance -> contextParameterInstance.getName())).collect(Collectors.toList());
    }

    public static List<ContextTransition> determineIfJobsTransitionToOtherContexts(Context parentContext, Map<String, SchedulerJob> schedulerJobs, Context child, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap) {
        ArrayList contextTransitions = new ArrayList();
        Map<String, SchedulerJob> jobMap = ContextHelper.getJobsOutsideLogicalGrouping(child);
        schedulerJobs.entrySet().forEach(entry -> {
            LinkedList<List<SchedulerJob>> linkedJobs = ContextHelper.traceJobThroughContext(parentContext, ((SchedulerJob)entry.getValue()).getJobName(), child.getName());
            ArrayList precedingJobs = new ArrayList();
            linkedJobs.forEach(jobs -> jobs.forEach(job -> {
                if (jobMap.containsKey(job.getIdentifier())) {
                    precedingJobs.add(job);
                }
                if (precedingJobs.size() > 0 && !schedulerJobs.containsKey(job.getIdentifier())) {
                    precedingJobs.forEach(precedingJob -> {
                        if (internalEventDrivenJobMap.containsKey(precedingJob.getIdentifier()) && !((InternalEventDrivenJob)internalEventDrivenJobMap.get(precedingJob.getIdentifier())).isTargetResidingContextOnly()) {
                            ContextTransition contextTransition = new ContextTransition();
                            contextTransition.setProceedingJob((SchedulerJob)precedingJob);
                            contextTransition.setSubsequentJob((SchedulerJob)job);
                            contextTransitions.add(contextTransition);
                        }
                    });
                    precedingJobs.clear();
                }
            }));
        });
        contextTransitions.stream().distinct().forEach(contextTransition -> {
            List<String> residingContexts = ContextHelper.getContextsWhereJobFilterMatchResides(parentContext, contextTransition.getPrecedingJob().getJobName());
            residingContexts.remove(child.getName());
            contextTransition.setContexts(residingContexts);
        });
        contextTransitions.stream().distinct().forEach(contextTransition -> logger.debug(contextTransition.toString()));
        return contextTransitions.stream().filter(contextTransition -> !contextTransition.getContexts().isEmpty()).distinct().collect(Collectors.toList());
    }

    public static AggregateContextInstanceStatus getAggregateContextInstanceStatus(ContextInstance contextInstance) {
        AggregateContextInstanceStatus aggregateContextInstanceStatus = new AggregateContextInstanceStatus();
        ContextHelper.getAggregateContextInstanceStatus(contextInstance, aggregateContextInstanceStatus, null, null, null);
        return aggregateContextInstanceStatus;
    }

    public static AggregateContextInstanceStatus getAggregateContextInstanceStatus(ContextInstance contextInstance, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap, Map<String, QuartzScheduleDrivenJobInstance> quartzSchedulerJobMap, ContextInstance parent) {
        AggregateContextInstanceStatus aggregateContextInstanceStatus = new AggregateContextInstanceStatus();
        ContextHelper.getAggregateContextInstanceStatus(contextInstance, aggregateContextInstanceStatus, internalEventDrivenJobMap, quartzSchedulerJobMap, parent);
        return aggregateContextInstanceStatus;
    }

    private static void getAggregateContextInstanceStatus(ContextInstance contextInstance, AggregateContextInstanceStatus aggregateContextInstanceStatus, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap, Map<String, QuartzScheduleDrivenJobInstance> quartzSchedulerJobMap, ContextInstance parent) {
        if (contextInstance.getScheduledJobs() != null) {
            contextInstance.getScheduledJobs().forEach(schedulerJobInstance -> {
                int externalJobs = 0;
                if (internalEventDrivenJobMap != null && parent != null) {
                    externalJobs = ContextHelper.getPrecedingJobsFromOutsideContext((Context)parent, schedulerJobInstance.getJobName(), schedulerJobInstance.getChildContextName(), internalEventDrivenJobMap).size();
                }
                if (externalJobs > 0) {
                    return;
                }
                if (schedulerJobInstance.getStatus().equals((Object)InstanceStatus.DISABLED) || quartzSchedulerJobMap != null && quartzSchedulerJobMap.containsKey(schedulerJobInstance.getJobName()) && parent.isQuartzScheduleDrivenJobsDisabledForContext()) {
                    aggregateContextInstanceStatus.setDisabledJobs();
                } else if (schedulerJobInstance.getStatus().equals((Object)InstanceStatus.ON_HOLD)) {
                    aggregateContextInstanceStatus.setHeldJobs();
                } else if (schedulerJobInstance.getStatus().equals((Object)InstanceStatus.SKIPPED) || schedulerJobInstance.getStatus().equals((Object)InstanceStatus.SKIPPED_COMPLETE) || schedulerJobInstance.getStatus().equals((Object)InstanceStatus.SKIPPED_RUNNING)) {
                    aggregateContextInstanceStatus.setSkippedJobs();
                }
            });
        }
        if (contextInstance.getContexts() != null) {
            contextInstance.getContexts().forEach(child -> ContextHelper.getAggregateContextInstanceStatus(child, aggregateContextInstanceStatus, internalEventDrivenJobMap, quartzSchedulerJobMap, parent));
        }
    }

    public static AggregateContextInstanceStatus getAggregateContextInstanceStatus(ContextInstance parent, ContextInstance contextInstance, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap) {
        AggregateContextInstanceStatus aggregateContextInstanceStatus = new AggregateContextInstanceStatus();
        ContextHelper.getAggregateContextInstanceStatus(parent, contextInstance, aggregateContextInstanceStatus, internalEventDrivenJobMap);
        return aggregateContextInstanceStatus;
    }

    private static void getAggregateContextInstanceStatus(ContextInstance parent, ContextInstance contextInstance, AggregateContextInstanceStatus aggregateContextInstanceStatus, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap) {
        if (contextInstance.getScheduledJobs() != null) {
            contextInstance.getScheduledJobs().forEach(schedulerJobInstance -> {
                if (!ContextHelper.determineIfJobsTransitionFromOtherContexts((Context)parent, schedulerJobInstance.getJobName(), schedulerJobInstance.getChildContextName(), internalEventDrivenJobMap).isEmpty()) {
                    return;
                }
                if (schedulerJobInstance.getStatus().equals((Object)InstanceStatus.DISABLED)) {
                    aggregateContextInstanceStatus.setDisabledJobs();
                } else if (schedulerJobInstance.getStatus().equals((Object)InstanceStatus.ON_HOLD)) {
                    aggregateContextInstanceStatus.setHeldJobs();
                } else if (schedulerJobInstance.getStatus().equals((Object)InstanceStatus.SKIPPED)) {
                    aggregateContextInstanceStatus.setSkippedJobs();
                }
            });
        }
        if (contextInstance.getContexts() != null) {
            contextInstance.getContexts().forEach(child -> ContextHelper.getAggregateContextInstanceStatus(parent, child, aggregateContextInstanceStatus, internalEventDrivenJobMap));
        }
    }

    public static ContextJobInstanceStatus getContextJobInstanceStatus(ContextInstance contextInstance, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobs) {
        ContextJobInstanceStatusImpl contextJobInstanceStatus = new ContextJobInstanceStatusImpl();
        contextJobInstanceStatus.setContextName(contextInstance.getName());
        contextJobInstanceStatus.setContextInstanceId(contextInstance.getId());
        contextJobInstanceStatus.setInstanceStatus(contextInstance.getStatus());
        contextJobInstanceStatus.setJobDetails(new ArrayList());
        ContextHelper.getContextJobInstanceStatus(contextInstance, contextJobInstanceStatus, internalEventDrivenJobs);
        return contextJobInstanceStatus;
    }

    private static void getContextJobInstanceStatus(ContextInstance contextInstance, ContextJobInstanceStatus contextJobInstanceStatus, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobs) {
        if (contextInstance.getContexts() == null || contextInstance.getContexts().isEmpty()) {
            if (contextInstance.getScheduledJobs() != null) {
                contextInstance.getScheduledJobs().forEach(schedulerJobInstance -> {
                    ContextJobInstanceDetailsStatusImpl contextJobInstanceDetailsStatus = new ContextJobInstanceDetailsStatusImpl();
                    contextJobInstanceDetailsStatus.setTargetResidingContextOnly(false);
                    if (internalEventDrivenJobs != null && internalEventDrivenJobs.containsKey(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName())) {
                        InternalEventDrivenJobInstance internalEventDrivenJobInstance = (InternalEventDrivenJobInstance)internalEventDrivenJobs.get(schedulerJobInstance.getIdentifier() + "-" + schedulerJobInstance.getChildContextName());
                        if (internalEventDrivenJobInstance.isTargetResidingContextOnly()) {
                            contextJobInstanceDetailsStatus.setTargetResidingContextOnly(true);
                        }
                        if (schedulerJobInstance.getScheduledProcessEvent() != null) {
                            contextJobInstanceDetailsStatus.setEndTime(schedulerJobInstance.getScheduledProcessEvent().getCompletionTime());
                        }
                    } else if (schedulerJobInstance.getScheduledProcessEvent() != null) {
                        contextJobInstanceDetailsStatus.setEndTime(schedulerJobInstance.getScheduledProcessEvent().getFireTime());
                    }
                    AtomicBoolean hasUpdated = new AtomicBoolean(false);
                    contextJobInstanceStatus.getJobDetails().stream().filter(record -> record.checkExist(schedulerJobInstance.getJobName())).forEach(record -> {
                        record.getChildContextName().add(schedulerJobInstance.getChildContextName());
                        hasUpdated.set(true);
                    });
                    if (!hasUpdated.get()) {
                        contextJobInstanceDetailsStatus.getChildContextName().add(schedulerJobInstance.getChildContextName());
                        contextJobInstanceDetailsStatus.setJobName(schedulerJobInstance.getJobName());
                        contextJobInstanceDetailsStatus.setInstanceStatus(schedulerJobInstance.getStatus());
                        if (schedulerJobInstance.getScheduledProcessEvent() != null) {
                            contextJobInstanceDetailsStatus.setStartTime(schedulerJobInstance.getScheduledProcessEvent().getFireTime());
                        }
                        contextJobInstanceStatus.getJobDetails().add(contextJobInstanceDetailsStatus);
                    }
                });
            }
        } else {
            contextInstance.getContexts().forEach(contextInstanceChild -> ContextHelper.getContextJobInstanceStatus(contextInstanceChild, contextJobInstanceStatus, internalEventDrivenJobs));
        }
    }

    public static Map<String, SchedulerJob> getJobsOutsideLogicalGrouping(Context context) {
        HashMap<String, SchedulerJob> jobsOutsideLogicConstructs = new HashMap<String, SchedulerJob>(context.getScheduledJobsMap());
        if (context.getJobDependencies() != null) {
            context.getJobDependencies().forEach(jobDependency -> {
                if (jobDependency.getLogicalGrouping() != null) {
                    ContextHelper.removeJobsInLogicalConstructs(jobDependency.getLogicalGrouping(), jobsOutsideLogicConstructs);
                }
            });
        }
        return jobsOutsideLogicConstructs;
    }

    private static void removeJobsInLogicalConstructs(LogicalGrouping logicalGrouping, Map<String, SchedulerJob> schedulerJobMap) {
        if (logicalGrouping != null) {
            ContextHelper.removeJobsInAndConstructs(logicalGrouping, schedulerJobMap);
            ContextHelper.removeJobsInOrConstructs(logicalGrouping, schedulerJobMap);
            ContextHelper.removeJobsInNotConstructs(logicalGrouping, schedulerJobMap);
            if (logicalGrouping.getLogicalGrouping() != null) {
                ContextHelper.removeJobsInLogicalConstructs(logicalGrouping.getLogicalGrouping(), schedulerJobMap);
            }
        }
    }

    private static void removeJobsInAndConstructs(LogicalGrouping logicalGrouping, Map<String, SchedulerJob> schedulerJobMap) {
        if (logicalGrouping.getAnd() != null && !logicalGrouping.getAnd().isEmpty()) {
            logicalGrouping.getAnd().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    ContextHelper.removeJobsInLogicalConstructs(operator.getLogicalGrouping(), schedulerJobMap);
                } else {
                    schedulerJobMap.remove(operator.getIdentifier());
                }
            });
        }
    }

    private static void removeJobsInNotConstructs(LogicalGrouping logicalGrouping, Map<String, SchedulerJob> schedulerJobMap) {
        if (logicalGrouping.getNot() != null && !logicalGrouping.getNot().isEmpty()) {
            logicalGrouping.getNot().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    ContextHelper.removeJobsInLogicalConstructs(operator.getLogicalGrouping(), schedulerJobMap);
                } else {
                    schedulerJobMap.remove(operator.getIdentifier());
                }
            });
        }
    }

    private static void removeJobsInOrConstructs(LogicalGrouping logicalGrouping, Map<String, SchedulerJob> schedulerJobInstanceMap) {
        if (logicalGrouping.getOr() != null && !logicalGrouping.getOr().isEmpty()) {
            logicalGrouping.getOr().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    ContextHelper.removeJobsInLogicalConstructs(operator.getLogicalGrouping(), schedulerJobInstanceMap);
                } else {
                    schedulerJobInstanceMap.remove(operator.getIdentifier());
                }
            });
        }
    }

    public static List<SchedulerJobInstance> getPrecedingJobsFromOutsideContext(Context context, String jobName, String childContextName, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap) {
        Context theChildContext = ContextHelper.getChildContext(childContextName, context);
        List<String> residingContexts = ContextHelper.getContextsWhereJobResides(context, jobName);
        List<Object> finalResults = new ArrayList();
        for (String name : residingContexts) {
            Optional<Object> jobDependency;
            InternalEventDrivenJob instance;
            Optional<Object> schedulerJobInstance;
            Context child = ContextHelper.getChildContext(name, context);
            if (child == null || (schedulerJobInstance = child.getScheduledJobs().stream().filter(job -> jobName.equals(((SchedulerJob)job).getJobName())).findFirst()).isEmpty() || internalEventDrivenJobMap.containsKey(((SchedulerJobInstance)schedulerJobInstance.get()).getIdentifier() + "-" + ((SchedulerJobInstance)schedulerJobInstance.get()).getChildContextName()) && (instance = internalEventDrivenJobMap.get(((SchedulerJobInstance)schedulerJobInstance.get()).getIdentifier() + "-" + ((SchedulerJobInstance)schedulerJobInstance.get()).getChildContextName())).isTargetResidingContextOnly() || child.getJobDependencies() == null || (jobDependency = child.getJobDependencies().stream().filter(dependency -> ((SchedulerJobInstance)schedulerJobInstance.get()).getIdentifier().equals(((JobDependency)dependency).getJobIdentifier())).findFirst()).isEmpty()) continue;
            ArrayList<SchedulerJob> results = new ArrayList<SchedulerJob>();
            ContextHelper.getUpstreamDependencies(((JobDependency)jobDependency.get()).getLogicalGrouping(), results, child.getScheduledJobsMap());
            if (results.size() <= 0) continue;
            finalResults.addAll(results.stream().collect(Collectors.toList()));
        }
        finalResults = finalResults.stream().flatMap(s -> Stream.ofNullable(s)).filter(job -> !((SchedulerJobInstance)job).getChildContextName().equals(childContextName) && theChildContext != null && !theChildContext.getScheduledJobs().stream().flatMap(s -> Stream.ofNullable(s)).filter(j -> job != null && job.getJobName().equals(((SchedulerJob)j).getJobName())).findFirst().isPresent()).filter(ContextHelper.distinctByKey(j -> j.getJobName())).collect(Collectors.toList());
        return finalResults.stream().map(job -> (SchedulerJobInstance)job).collect(Collectors.toList());
    }

    public static List<ContextTransition> determineIfJobsTransitionFromOtherContexts(Context context, String jobName, String childContextName, Map<String, InternalEventDrivenJob> internalEventDrivenJobMap) {
        HashMap<String, SchedulerJob> jobs = new HashMap<String, SchedulerJob>();
        internalEventDrivenJobMap.entrySet().forEach(entry -> jobs.put((String)entry.getKey(), (SchedulerJob)entry.getValue()));
        return ContextHelper.determineIfSchedulerJobsTransitionFromOtherContexts(context, jobName, childContextName, jobs);
    }

    public static List<ContextTransition> determineIfSchedulerJobsTransitionFromOtherContexts(Context context, String jobName, String childContextName, Map<String, SchedulerJob> internalEventDrivenJobMap) {
        List<String> residingContexts = ContextHelper.getContextsWhereJobResides(context, jobName);
        HashMap<String, ContextTransition> finalResults = new HashMap<String, ContextTransition>();
        for (String name : residingContexts) {
            Optional<Object> jobDependency;
            InternalEventDrivenJob instance;
            Optional<Object> schedulerJob;
            Context child = ContextHelper.getChildContext(name, context);
            if (child == null || (schedulerJob = child.getScheduledJobs().stream().filter(job -> jobName.equals(((SchedulerJob)job).getJobName())).findFirst()).isEmpty() || internalEventDrivenJobMap.containsKey(((SchedulerJob)schedulerJob.get()).getIdentifier()) && internalEventDrivenJobMap.get(((SchedulerJob)schedulerJob.get()).getIdentifier()) instanceof InternalEventDrivenJob && (instance = (InternalEventDrivenJob)internalEventDrivenJobMap.get(((SchedulerJob)schedulerJob.get()).getIdentifier())).isTargetResidingContextOnly() || child.getJobDependencies() == null || (jobDependency = child.getJobDependencies().stream().filter(dependency -> ((SchedulerJob)schedulerJob.get()).getIdentifier().equals(((JobDependency)dependency).getJobIdentifier())).findFirst()).isEmpty()) continue;
            ArrayList<SchedulerJob> results = new ArrayList<SchedulerJob>();
            results.add((SchedulerJob)schedulerJob.get());
            if (results.size() <= 0 || child.getName().equals(childContextName)) continue;
            if (!finalResults.containsKey(((SchedulerJob)schedulerJob.get()).getIdentifier())) {
                ContextTransition contextTransition = new ContextTransition();
                contextTransition.setProceedingJob((SchedulerJob)schedulerJob.get());
                contextTransition.setSubsequentJob((SchedulerJob)schedulerJob.get());
                contextTransition.setContexts(new ArrayList<String>());
                finalResults.put(((SchedulerJob)schedulerJob.get()).getIdentifier(), contextTransition);
            }
            if (((ContextTransition)finalResults.get(((SchedulerJob)schedulerJob.get()).getIdentifier())).getContexts().contains(child.getName())) continue;
            ((ContextTransition)finalResults.get(((SchedulerJob)schedulerJob.get()).getIdentifier())).getContexts().add(child.getName());
        }
        return finalResults.values().stream().collect(Collectors.toList());
    }

    private static void getUpstreamDependencies(LogicalGrouping logicalGrouping, List<SchedulerJob> schedulerJobInstances, Map<String, SchedulerJob> schedulerJobInstanceMap) {
        if (logicalGrouping != null) {
            ContextHelper.assessAnd(logicalGrouping, schedulerJobInstances, schedulerJobInstanceMap);
            ContextHelper.assessOr(logicalGrouping, schedulerJobInstances, schedulerJobInstanceMap);
            ContextHelper.assessNot(logicalGrouping, schedulerJobInstances, schedulerJobInstanceMap);
        }
    }

    public static String getIdentifier(String identifier) {
        if (identifier.contains("_in")) {
            identifier = identifier.substring(0, identifier.indexOf("_in"));
        } else if (identifier.contains("_out")) {
            identifier = identifier.substring(0, identifier.indexOf("_out"));
        }
        return identifier;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static boolean assessAnd(LogicalGrouping logicalGrouping, List<SchedulerJob> schedulerJobInstances, Map<String, SchedulerJob> schedulerJobInstanceMap) {
        AtomicBoolean and = new AtomicBoolean(false);
        if (logicalGrouping.getAnd() != null && !logicalGrouping.getAnd().isEmpty()) {
            and.set(true);
            logicalGrouping.getAnd().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    ContextHelper.getUpstreamDependencies(operator.getLogicalGrouping(), schedulerJobInstances, schedulerJobInstanceMap);
                } else {
                    schedulerJobInstances.add((SchedulerJob)schedulerJobInstanceMap.get(operator.getIdentifier()));
                }
            });
        }
        return and.get();
    }

    private static boolean assessOr(LogicalGrouping logicalGrouping, List<SchedulerJob> schedulerJobInstances, Map<String, SchedulerJob> schedulerJobInstanceMap) {
        AtomicBoolean or = new AtomicBoolean(false);
        if (logicalGrouping.getOr() != null && !logicalGrouping.getOr().isEmpty()) {
            logicalGrouping.getOr().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    ContextHelper.getUpstreamDependencies(operator.getLogicalGrouping(), schedulerJobInstances, schedulerJobInstanceMap);
                } else {
                    schedulerJobInstances.add((SchedulerJob)schedulerJobInstanceMap.get(operator.getIdentifier()));
                }
            });
        }
        return or.get();
    }

    private static boolean assessNot(LogicalGrouping logicalGrouping, List<SchedulerJob> schedulerJobInstances, Map<String, SchedulerJob> schedulerJobInstanceMap) {
        AtomicBoolean not = new AtomicBoolean(false);
        if (logicalGrouping.getNot() != null && !logicalGrouping.getNot().isEmpty()) {
            logicalGrouping.getNot().forEach(operator -> {
                if (operator.getLogicalGrouping() != null) {
                    ContextHelper.getUpstreamDependencies(operator.getLogicalGrouping(), schedulerJobInstances, schedulerJobInstanceMap);
                } else {
                    schedulerJobInstances.add((SchedulerJob)schedulerJobInstanceMap.get(operator.getIdentifier()));
                }
            });
        }
        return not.get();
    }

    public static LinkedList<List<SchedulerJob>> traceJobThroughContext(Context context, String jobName, String childContextName) {
        LinkedList<List<SchedulerJob>> results = new LinkedList<List<SchedulerJob>>();
        ArrayList<String> processedContexts = new ArrayList<String>();
        ContextHelper._traceJobThroughContext(results, context, jobName, childContextName, processedContexts);
        return results;
    }

    private static void _traceJobThroughContext(LinkedList<List<SchedulerJob>> results, Context context, String jobName, String childContextName, List<String> processedContexts) {
        logger.debug(String.format("_traceJobThroughContext - contextName[%s], jobName[%s], childContextName[%s]", context.getName(), jobName, childContextName));
        Context child = ContextHelper.getChildContext(childContextName, context);
        if (processedContexts.contains(child.getName())) {
            return;
        }
        processedContexts.add(child.getName());
        Optional<SchedulerJob> schedulerJobInstance = child.getScheduledJobs().stream().filter(job -> job.getJobName().equals(jobName)).findFirst();
        ArrayList jobs = new ArrayList();
        if (schedulerJobInstance.isPresent()) {
            schedulerJobInstance.ifPresent(job -> {
                if (child.getJobDependencies() != null) {
                    child.getJobDependencies().forEach(jobDependency -> ContextHelper.getNextJob(child, jobDependency.getJobIdentifier(), jobDependency.getLogicalGrouping(), (SchedulerJob)schedulerJobInstance.get(), jobs));
                }
            });
        }
        if (!jobs.isEmpty()) {
            results.add(jobs);
            jobs.forEach(job -> {
                List<String> contexts;
                if (job != null && (contexts = ContextHelper.getContextsWhereJobResides(context, job.getJobName())) != null) {
                    contexts.forEach(filtered -> {
                        if (!filtered.equals(childContextName) && !filtered.isEmpty()) {
                            ContextHelper._traceJobThroughContext(results, context, job.getJobName(), filtered, processedContexts);
                        }
                    });
                }
            });
        }
    }

    private static void getNextJob(Context child, String jobIdentifier, LogicalGrouping logicalGrouping, SchedulerJob schedulerJobInstance, List<SchedulerJob> jobIdentifiers) {
        if (logicalGrouping == null) {
            return;
        }
        if (logicalGrouping.getLogicalGrouping() != null) {
            ContextHelper.getNextJob(child, jobIdentifier, logicalGrouping.getLogicalGrouping(), schedulerJobInstance, jobIdentifiers);
        }
        if (logicalGrouping.getAnd() != null) {
            logicalGrouping.getAnd().forEach(and -> {
                if (and.getLogicalGrouping() != null) {
                    ContextHelper.getNextJob(child, jobIdentifier, and.getLogicalGrouping(), schedulerJobInstance, jobIdentifiers);
                } else if (schedulerJobInstance.getIdentifier().equals(and.getIdentifier())) {
                    jobIdentifiers.add((SchedulerJob)child.getScheduledJobsMap().get(jobIdentifier));
                }
            });
        }
        if (logicalGrouping.getOr() != null) {
            logicalGrouping.getOr().forEach(or -> {
                if (or.getLogicalGrouping() != null) {
                    ContextHelper.getNextJob(child, jobIdentifier, or.getLogicalGrouping(), schedulerJobInstance, jobIdentifiers);
                } else if (schedulerJobInstance.getIdentifier().equals(or.getIdentifier())) {
                    jobIdentifiers.add((SchedulerJob)child.getScheduledJobsMap().get(jobIdentifier));
                }
            });
        }
        if (logicalGrouping.getNot() != null) {
            logicalGrouping.getNot().forEach(not -> {
                if (not.getLogicalGrouping() != null) {
                    ContextHelper.getNextJob(child, jobIdentifier, not.getLogicalGrouping(), schedulerJobInstance, jobIdentifiers);
                } else if (schedulerJobInstance.getIdentifier().equals(not.getIdentifier())) {
                    jobIdentifiers.add((SchedulerJob)child.getScheduledJobsMap().get(jobIdentifier));
                }
            });
        }
    }

    public static Context getChildContext(String childContextName, Context context) {
        if (context.getName().equals(childContextName)) {
            return context;
        }
        if (context.getContexts() != null) {
            for (Context c : context.getContexts()) {
                Context result = ContextHelper.getChildContext(childContextName, c);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static ContextInstance getChildContextInstance(String childContextName, ContextInstance contextInstance) {
        if (contextInstance.getName().equals(childContextName)) {
            return contextInstance;
        }
        if (contextInstance.getContexts() != null) {
            for (ContextInstance instance : contextInstance.getContexts()) {
                ContextInstance result = ContextHelper.getChildContextInstance(childContextName, instance);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static ContextTemplate getChildContextTemplate(String childContextName, ContextTemplate contextTemplate) {
        if (contextTemplate.getName().equals(childContextName)) {
            return contextTemplate;
        }
        if (contextTemplate.getContexts() != null) {
            for (ContextTemplate template : contextTemplate.getContexts()) {
                ContextTemplate result = ContextHelper.getChildContextTemplate(childContextName, template);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static ContextTemplate getParentContextTemplate(String childContextName, ContextTemplate contextTemplate) {
        AtomicBoolean containsContext = new AtomicBoolean(false);
        contextTemplate.getContexts().forEach(c -> {
            if (c.getName().equals(childContextName)) {
                containsContext.set(true);
            }
        });
        if (containsContext.get()) {
            return contextTemplate;
        }
        if (contextTemplate.getContexts() != null) {
            for (ContextTemplate template : contextTemplate.getContexts()) {
                ContextTemplate result = ContextHelper.getParentContextTemplate(childContextName, template);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static void removeChildContextTemplate(String childContextName, ContextTemplate contextTemplate) {
        if (contextTemplate.getContexts() != null) {
            if (contextTemplate.getContextsMap().containsKey(childContextName)) {
                contextTemplate.getContexts().remove(contextTemplate.getContextsMap().get(childContextName));
                contextTemplate.getContextsMap().remove(childContextName);
            } else {
                contextTemplate.getContexts().forEach(template -> ContextHelper.removeChildContextTemplate(childContextName, template));
            }
        }
    }

    public static ContextTemplate replaceChildContextTemplate(ContextTemplate contextTemplate, ContextTemplate updated) {
        if (contextTemplate.getName().equals(updated.getName())) {
            contextTemplate.setJobDependencies(updated.getJobDependencies());
            contextTemplate.setScheduledJobs(updated.getScheduledJobs());
            return contextTemplate;
        }
        if (contextTemplate.getContexts() != null) {
            for (int i = 0; i < contextTemplate.getContexts().size(); ++i) {
                if (((ContextTemplate)contextTemplate.getContexts().get(i)).getName().equals(updated.getName())) {
                    ((ContextTemplate)contextTemplate.getContexts().get(i)).setJobDependencies(updated.getJobDependencies());
                    ((ContextTemplate)contextTemplate.getContexts().get(i)).setScheduledJobs(updated.getScheduledJobs());
                    continue;
                }
                ContextHelper.replaceChildContextTemplate((ContextTemplate)contextTemplate.getContexts().get(i), updated);
            }
        }
        return contextTemplate;
    }

    public static void holdAllJobs(ContextInstance context, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstanceMap) {
        ContextHelper._holdAllJobs(context, internalEventDrivenJobInstanceMap);
    }

    private static void _holdAllJobs(ContextInstance context, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstanceMap) {
        if (context.getScheduledJobs() != null) {
            context.getScheduledJobs().forEach(job -> {
                if (internalEventDrivenJobInstanceMap.containsKey(job.getIdentifier() + "-" + job.getChildContextName()) && (job.getStatus().equals((Object)InstanceStatus.WAITING) || job.getStatus().equals((Object)InstanceStatus.RELEASED))) {
                    if (job.getChildContextNames() != null) {
                        HashMap heldMap = new HashMap();
                        job.getChildContextNames().forEach(name -> heldMap.put(name, Boolean.TRUE));
                        job.setHeldContexts(heldMap);
                    }
                    job.setHeld(true);
                    job.setStatus(InstanceStatus.ON_HOLD);
                }
            });
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper._holdAllJobs(c, internalEventDrivenJobInstanceMap));
        }
    }

    public static void setJobStatusAll(ContextInstance context, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstanceMap, InstanceStatus instanceStatus) {
        ContextHelper._setJobStatusAll(context, internalEventDrivenJobInstanceMap, instanceStatus);
    }

    private static void _setJobStatusAll(ContextInstance context, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstanceMap, InstanceStatus instanceStatus) {
        if (context.getScheduledJobs() != null) {
            context.getScheduledJobs().forEach(job -> {
                if (internalEventDrivenJobInstanceMap.containsKey(job.getIdentifier() + "-" + job.getChildContextName())) {
                    job.setStatus(instanceStatus);
                }
            });
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper._setJobStatusAll(c, internalEventDrivenJobInstanceMap, instanceStatus));
        }
    }

    public static void releaseAllJobs(ContextInstance context, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstanceMap) {
        ContextHelper._releaseAllJobs(context, internalEventDrivenJobInstanceMap);
    }

    private static void _releaseAllJobs(ContextInstance context, Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobInstanceMap) {
        if (context.getScheduledJobs() != null) {
            context.getScheduledJobs().stream().filter(job -> internalEventDrivenJobInstanceMap.containsKey(job.getIdentifier() + job.getChildContextName()) && job.getStatus().equals((Object)InstanceStatus.ON_HOLD)).forEach(job -> {
                HashMap heldMap = new HashMap();
                job.setHeldContexts(heldMap);
                job.setHeld(false);
                job.setStatus(InstanceStatus.RELEASED);
            });
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper._holdAllJobs(c, internalEventDrivenJobInstanceMap));
        }
    }

    public static void enrichJobs(ContextInstance context) {
        ContextHelper._enrichJobs(context, (Context)context);
    }

    private static void enrichJobs(ContextInstance context, Context child) {
        ContextHelper._enrichJobs(context, child);
    }

    private static void _enrichJobs(ContextInstance context, Context child) {
        if (child.getScheduledJobs() != null) {
            child.getScheduledJobs().forEach(job -> {
                ((SchedulerJobInstance)job).setContextName(context.getName());
                ((SchedulerJobInstance)job).setChildContextName(child.getName());
            });
        }
        if (child.getContexts() != null) {
            child.getContexts().forEach(c -> ContextHelper.enrichJobs(context, (Context)c));
        }
    }

    public static void enrichJobs(ContextInstance context, Map<String, SchedulerJob> schedulerJobMap) {
        ContextHelper._enrichJobs(context, (Context)context, schedulerJobMap);
    }

    private static void enrichJobs(ContextInstance context, Context child, Map<String, SchedulerJob> schedulerJobMap) {
        ContextHelper._enrichJobs(context, child, schedulerJobMap);
    }

    private static void _enrichJobs(ContextInstance context, Context child, Map<String, SchedulerJob> schedulerJobMap) {
        if (child.getScheduledJobs() != null) {
            child.getScheduledJobs().forEach(job -> {
                ((SchedulerJobInstance)job).setContextName(context.getName());
                ((SchedulerJobInstance)job).setChildContextName(child.getName());
                if (schedulerJobMap.containsKey(((SchedulerJobInstance)job).getJobName())) {
                    ((SchedulerJobInstance)job).setDisplayName(((SchedulerJob)schedulerJobMap.get(((SchedulerJobInstance)job).getJobName())).getDisplayName());
                }
            });
        }
        if (child.getContexts() != null) {
            child.getContexts().forEach(c -> ContextHelper.enrichJobs(context, (Context)c, schedulerJobMap));
        }
    }

    private static List<String> getContextsWhereJobResides(Context context, String jobName) {
        ArrayList<String> results = new ArrayList<String>();
        ContextHelper.getContextsWhereJobResides(results, context, jobName);
        return results;
    }

    private static void getContextsWhereJobResides(List<String> results, Context context, String jobName) {
        if (context.getScheduledJobs() != null && !context.getScheduledJobs().isEmpty()) {
            context.getScheduledJobs().forEach(job -> {
                if (((SchedulerJob)job).getJobName().equals(jobName)) {
                    results.add(context.getName());
                }
            });
        }
        if (context.getContexts() != null && !context.getContexts().isEmpty()) {
            context.getContexts().forEach(child -> ContextHelper.getContextsWhereJobResides(results, (Context)child, jobName));
        }
    }

    public static List<String> getContextsWhereJobFilterMatchResides(Context context, String jobNameFilter) {
        ArrayList<String> results = new ArrayList<String>();
        ContextHelper.getContextsWhereJobFilterMatchResides(results, context, jobNameFilter);
        return results.stream().distinct().collect(Collectors.toList());
    }

    private static void getContextsWhereJobFilterMatchResides(List<String> results, Context context, String jobNameFilter) {
        if (context.getScheduledJobs() != null && !context.getScheduledJobs().isEmpty()) {
            context.getScheduledJobs().forEach(job -> {
                if (((SchedulerJob)job).getJobName().toLowerCase().contains(jobNameFilter.toLowerCase())) {
                    results.add(context.getName());
                } else if (((SchedulerJob)job).getDisplayName() != null && ((SchedulerJob)job).getDisplayName().toLowerCase().contains(jobNameFilter.toLowerCase())) {
                    results.add(context.getName());
                }
            });
        }
        if (context.getName().toLowerCase().contains(jobNameFilter.toLowerCase()) && !results.contains(context.getName())) {
            results.add(context.getName());
        }
        if (context.getContexts() != null && !context.getContexts().isEmpty()) {
            context.getContexts().forEach(child -> ContextHelper.getContextsWhereJobFilterMatchResides(results, (Context)child, jobNameFilter));
        }
    }

    public static Map<String, Context> getAllContexts(Context context) {
        HashMap<String, Context> contextMap = new HashMap<String, Context>();
        contextMap.put(context.getName(), context);
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllContexts((Context)c, contextMap));
        }
        return contextMap;
    }

    private static void getAllContexts(Context context, Map<String, Context> contextMap) {
        contextMap.put(context.getName(), context);
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllContexts((Context)c, contextMap));
        }
    }

    public static Map<String, SchedulerJobInstance> getAllJobs(ContextInstance context) {
        HashMap<String, SchedulerJobInstance> contextMap = new HashMap<String, SchedulerJobInstance>();
        if (context.getScheduledJobsMap() != null && !context.getScheduledJobsMap().isEmpty()) {
            context.getScheduledJobsMap().entrySet().forEach(entry -> contextMap.put((String)entry.getKey() + ((SchedulerJobInstance)entry.getValue()).getChildContextName(), (SchedulerJobInstance)entry.getValue()));
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllJobs(c, contextMap));
        }
        return contextMap;
    }

    private static void getAllJobs(ContextInstance context, Map<String, SchedulerJobInstance> contextMap) {
        if (context.getScheduledJobsMap() != null && !context.getScheduledJobsMap().isEmpty()) {
            context.getScheduledJobsMap().entrySet().forEach(entry -> contextMap.put((String)entry.getKey() + ((SchedulerJobInstance)entry.getValue()).getChildContextName(), (SchedulerJobInstance)entry.getValue()));
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllJobs(c, contextMap));
        }
    }

    public static List<SchedulerJob> getAllJobs(ContextTemplate context) {
        ArrayList<SchedulerJob> contextMap = new ArrayList<SchedulerJob>();
        if (context.getScheduledJobsMap() != null && !context.getScheduledJobsMap().isEmpty()) {
            context.getScheduledJobsMap().entrySet().forEach(entry -> contextMap.add((SchedulerJob)entry.getValue()));
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllJobs(c, contextMap));
        }
        return contextMap;
    }

    private static void getAllJobs(ContextTemplate context, List<SchedulerJob> contextMap) {
        if (context.getScheduledJobsMap() != null && !context.getScheduledJobsMap().isEmpty()) {
            context.getScheduledJobsMap().entrySet().forEach(entry -> contextMap.add((SchedulerJob)entry.getValue()));
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllJobs(c, contextMap));
        }
    }

    public static SchedulerJobInstance getSchedulerJobInstance(String jobName, String childContextName, ContextInstance contextInstance) {
        Optional<SchedulerJobInstance> jobInstance;
        ContextInstance instance = ContextHelper.getChildContextInstance(childContextName, contextInstance);
        if (instance != null && (jobInstance = instance.getScheduledJobs().stream().filter(job -> jobName.equals(job.getJobName())).findFirst()).isPresent()) {
            return jobInstance.get();
        }
        return null;
    }

    public static List<String> getAllAgents(Context context) {
        HashSet<String> agentSet = new HashSet<String>();
        ContextHelper.populateAgentSet(context, agentSet);
        return new ArrayList<String>(agentSet);
    }

    private static void getAllAgents(Context context, HashSet<String> agentSet) {
        ContextHelper.populateAgentSet(context, agentSet);
    }

    private static void populateAgentSet(Context context, HashSet<String> agentSet) {
        if (context.getScheduledJobs() != null && !context.getScheduledJobs().isEmpty()) {
            context.getScheduledJobs().forEach(job -> {
                if (!agentSet.contains(((SchedulerJob)job).getAgentName())) {
                    agentSet.add(((SchedulerJob)job).getAgentName());
                }
            });
        }
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> ContextHelper.getAllAgents((Context)c, agentSet));
        }
    }

    public void setAgentNameReplacement(String agentNameReplacement) {
        AGENT_NAME_REPLACEMENT = agentNameReplacement;
    }

    public void setContextNameReplacement(String contextNameReplacement) {
        CONTEXT_NAME_REPLACEMENT = contextNameReplacement;
    }

    public void setEnvNameReplacement(String envNameReplacement) {
        ENV_NAME_REPLACEMENT = envNameReplacement;
    }

    public void setUseUnderscoreSeparatedContextNameConvention(boolean useUnderscoreSeparatedContextNameConvention) {
        USE_UNDERSCORE_SEPARATED_CONTEXT_NAME_CONVENTION = useUnderscoreSeparatedContextNameConvention;
    }
}

