/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.rest.client;

import java.util.HashMap;
import java.util.Map;
import org.ikasan.rest.client.ModuleRestService;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

public class ContextInstancePublicationRestServiceImpl
extends ModuleRestService
implements ContextInstancePublicationService<ContextInstance> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextInstancePublicationRestServiceImpl.class);
    private static final String REST_URL = "/rest/contextInstance";
    private static final String REST_URL_SAVE = "/rest/contextInstance/save";
    private static final String REST_URL_REMOVE = "/rest/contextInstance/remove";
    private static final String REST_URL_REMOVE_ALL = "/rest/contextInstance/removeAll";

    public ContextInstancePublicationRestServiceImpl(Environment environment, HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory) {
        super(environment, httpComponentsClientHttpRequestFactory);
    }

    public synchronized void publish(String contextUrl, ContextInstance instance) {
        HttpHeaders headers = this.createHttpHeaders();
        HttpEntity entity = new HttpEntity((Object)instance, (MultiValueMap)headers);
        String url = contextUrl + REST_URL_SAVE;
        try {
            this.restTemplate.exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            e.printStackTrace();
            String message = String.format("Could not update context parameters for for agent url %s, instance %s, responseCode: %d, error: %s", url, instance.getId(), e.getRawStatusCode(), e.getMessage());
            LOGGER.warn(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = String.format("Could not update context parameters for for agent url %s, instance %s, error: %s", url, instance.getId(), e.getMessage());
            LOGGER.warn(message);
        }
    }

    public synchronized void remove(String contextUrl, final ContextInstance contextInstance) {
        HttpHeaders headers = this.createHttpHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = contextUrl + REST_URL_REMOVE;
        try {
            String urlTemplate = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("correlationId", new Object[]{"{correlationId}"}).encode().toUriString();
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    this.put("correlationId", contextInstance.getId());
                }
            };
            this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, entity, String.class, (Map)parameters);
        }
        catch (RestClientResponseException e) {
            e.printStackTrace();
            String message = String.format("Could not remove instance from agent for agent url %s, name %s, responseCode: %d, error: %s", url, contextInstance.getName(), e.getRawStatusCode(), e.getMessage());
            LOGGER.warn(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = String.format("Could not remove instance from agent for agent url %s, name %s, error: %s", url, contextInstance.getName(), e.getMessage());
            LOGGER.warn(message);
        }
    }

    public void removeAll(String contextUrl) {
        HttpHeaders headers = this.createHttpHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = contextUrl + REST_URL_REMOVE_ALL;
        try {
            String urlTemplate = UriComponentsBuilder.fromHttpUrl((String)url).encode().toUriString();
            HashMap parameters = new HashMap();
            this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, entity, String.class, parameters);
        }
        catch (RestClientResponseException e) {
            e.printStackTrace();
            String message = String.format("Could not remove all context instances from agent for agent url %s, responseCode: %d, error: %s", url, e.getRawStatusCode(), e.getMessage());
            LOGGER.warn(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = String.format("Could not remove all context instances from agent for agent url %s, error: %s", url, e.getMessage());
            LOGGER.warn(message);
        }
    }
}

