/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import org.ikasan.job.orchestration.rest.client.exception.SchedulerAgentRestClientException;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.rest.client.ModuleRestService;
import org.ikasan.spec.scheduled.job.model.SchedulerJobWrapper;
import org.ikasan.spec.scheduled.job.service.JobProvisionModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;

public class JobProvisionModuleRestServiceImpl
extends ModuleRestService
implements JobProvisionModuleService {
    Logger logger = LoggerFactory.getLogger(JobProvisionModuleRestServiceImpl.class);
    public static final String JOB_PROVISION_REST_URL = "/rest/jobProvision";
    public static final String JOB_PROVISION_REMOVE_REST_URL = "/rest/jobProvision/remove";

    public JobProvisionModuleRestServiceImpl(Environment environment, HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory) {
        super(environment, httpComponentsClientHttpRequestFactory);
    }

    public void provisionJobs(String contextUrl, SchedulerJobWrapper jobs) {
        try {
            HttpHeaders headers = this.createHttpHeaders();
            BasicPolymorphicTypeValidator ptv = BasicPolymorphicTypeValidator.builder().allowIfSubType("org.ikasan.spec.scheduled.job.model").allowIfSubType("org.ikasan.job.orchestration.model.job").allowIfSubType("org.ikasan.job.orchestration.model.context").allowIfSubType("java.util.ArrayList").allowIfSubType("java.util.HashMap").build();
            ObjectMapper objectMapper = ObjectMapperFactory.newInstance();
            objectMapper.activateDefaultTyping((PolymorphicTypeValidator)ptv, ObjectMapper.DefaultTyping.NON_FINAL);
            String serialised = objectMapper.writeValueAsString((Object)jobs);
            HttpEntity entity = new HttpEntity((Object)serialised, (MultiValueMap)headers);
            String url = contextUrl + JOB_PROVISION_REST_URL;
            this.logger.debug("Context URL[{}] Payload[{}] ", (Object)url, (Object)serialised);
            this.restTemplate.exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("An error has occurred attempting to provision scheduler jobs!", (Throwable)e);
            throw new SchedulerAgentRestClientException("An error has occurred attempting to provision scheduler jobs!", e);
        }
    }

    public void removeJobsForContext(String contextUrl, String contextName) {
        try {
            HttpHeaders headers = this.createHttpHeaders();
            HttpEntity entity = new HttpEntity((Object)contextName, (MultiValueMap)headers);
            String url = contextUrl + JOB_PROVISION_REMOVE_REST_URL;
            this.logger.debug("Context URL[{}] Payload[{}] ", (Object)url, (Object)contextName);
            this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(String.format("An error has occurred attempting to remove jobs for context[%s]!", contextName), (Throwable)e);
            throw new SchedulerAgentRestClientException(String.format("An error has occurred attempting to remove jobs for context[%s]!", contextName), e);
        }
    }
}

