/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.rest.client;

import java.util.HashMap;
import java.util.Map;
import org.ikasan.rest.client.ModuleRestService;
import org.ikasan.spec.scheduled.job.service.JobUtilsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

public class JobUtilsServiceImpl
extends ModuleRestService
implements JobUtilsService {
    private Logger logger = LoggerFactory.getLogger(JobUtilsServiceImpl.class);
    public static final String KILL_URL = "/rest/jobUtils/kill/{pid}?destroy={forcibly}";

    public JobUtilsServiceImpl(Environment environment, HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory) {
        super(environment, httpComponentsClientHttpRequestFactory);
    }

    public void killJob(String contextUrl, final long pid, final boolean forcibly) {
        HttpHeaders headers = this.createHttpHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = contextUrl + KILL_URL;
        HashMap<String, String> parameters = new HashMap<String, String>(){
            {
                this.put("pid", Long.toString(pid));
                this.put("forcibly", Boolean.toString(forcibly));
            }
        };
        try {
            this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, (Map)parameters);
        }
        catch (RestClientException e) {
            this.logger.warn("Issue killing job with pid [" + pid + "] with destroy [" + forcibly + "] with response [{" + e.getLocalizedMessage() + "}]");
            throw e;
        }
    }
}

