/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.context.cache.JobLockCacheImpl;
import org.ikasan.job.orchestration.context.register.ContextInstanceSchedulerService;
import org.ikasan.job.orchestration.context.util.CronUtils;
import org.ikasan.job.orchestration.context.util.TimeService;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.model.context.ContextTemplateImpl;
import org.ikasan.job.orchestration.model.event.ContextInstanceStateChangeEventImpl;
import org.ikasan.job.orchestration.model.instance.ContextInstanceImpl;
import org.ikasan.job.orchestration.model.instance.ScheduledContextInstanceRecordImpl;
import org.ikasan.job.orchestration.model.instance.SchedulerJobInstanceSearchFilterImpl;
import org.ikasan.job.orchestration.model.instance.SchedulerJobInstancesInitialisationParametersImpl;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.orchestration.service.context.recovery.ContextInstanceRecoveryServiceImpl;
import org.ikasan.scheduled.instance.model.SolrContextInstanceSearchFilterImpl;
import org.ikasan.spec.metadata.ModuleMetaData;
import org.ikasan.spec.metadata.ModuleMetaDataService;
import org.ikasan.spec.metadata.ModuleMetadataSearchResults;
import org.ikasan.spec.module.ModuleType;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.JobLockCache;
import org.ikasan.spec.scheduled.context.model.ScheduledContextRecord;
import org.ikasan.spec.scheduled.context.service.ScheduledContextService;
import org.ikasan.spec.scheduled.event.model.ContextInstanceStateChangeEvent;
import org.ikasan.spec.scheduled.event.service.ContextInstanceStateChangeEventBroadcaster;
import org.ikasan.spec.scheduled.event.service.SchedulerJobStateChangeEventBroadcaster;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextInstanceSearchFilter;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.GlobalEventJobInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.InternalEventDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.QuartzScheduleDrivenJobInstance;
import org.ikasan.spec.scheduled.instance.model.ScheduledContextInstanceRecord;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstanceSearchFilter;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.ikasan.spec.scheduled.instance.service.ScheduledContextInstanceService;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstanceService;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstancesInitialisationParameters;
import org.ikasan.spec.scheduled.job.service.InternalEventDrivenJobService;
import org.ikasan.spec.scheduled.job.service.JobInitiationService;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheInitialisationService;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheService;
import org.ikasan.spec.search.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextInstanceServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ContextInstanceRecoveryServiceImpl.class);
    protected final String queueDirectory;
    protected final ScheduledContextInstanceService scheduledContextInstanceService;
    protected final JobInitiationService jobInitiationService;
    protected final ModuleMetaDataService moduleMetadataService;
    protected final InternalEventDrivenJobService internalEventDrivenJobService;
    protected final ContextParametersInstanceService contextParametersInstanceService;
    protected final ContextInstancePublicationService<ContextInstance> contextInstancePublicationService;
    protected final JobLockCacheService jobLockCacheService;
    protected final ScheduledContextService scheduledContextService;
    protected final SchedulerJobInstanceService schedulerJobInstanceService;
    protected final JobLockCacheInitialisationService jobLockCacheInitialisationService;
    protected final ContextInstanceStateChangeEventBroadcaster contextInstanceStateChangeEventBroadcaster;
    protected final SchedulerJobStateChangeEventBroadcaster schedulerJobStateChangeEventBroadcaster;
    protected final ContextInstanceSchedulerService contextInstanceSchedulerService;
    protected final TimeService timeService;
    protected final ObjectMapper objectMapper;

    public ContextInstanceServiceBase(String queueDirectory, ScheduledContextInstanceService scheduledContextInstanceService, JobInitiationService jobInitiationService, ModuleMetaDataService moduleMetadataService, InternalEventDrivenJobService internalEventDrivenJobService, ContextParametersInstanceService contextParametersInstanceService, ContextInstancePublicationService contextParametersUpdateService, JobLockCacheService jobLockCacheService, ScheduledContextService scheduledContextService, SchedulerJobInstanceService schedulerJobInstanceService, ContextInstanceStateChangeEventBroadcaster contextInstanceStateChangeEventBroadcaster, SchedulerJobStateChangeEventBroadcaster schedulerJobStateChangeEventBroadcaster, JobLockCacheInitialisationService jobLockCacheInitialisationService, ContextInstanceSchedulerService contextInstanceSchedulerService, TimeService timeService) {
        this.queueDirectory = queueDirectory;
        if (this.queueDirectory == null) {
            throw new IllegalArgumentException("queueDirectory cannot be null!");
        }
        this.scheduledContextInstanceService = scheduledContextInstanceService;
        if (this.scheduledContextInstanceService == null) {
            throw new IllegalArgumentException("scheduledContextInstanceService cannot be null!");
        }
        this.jobInitiationService = jobInitiationService;
        if (this.jobInitiationService == null) {
            throw new IllegalArgumentException("schedulerService cannot be null!");
        }
        this.moduleMetadataService = moduleMetadataService;
        if (this.moduleMetadataService == null) {
            throw new IllegalArgumentException("moduleMetadataService cannot be null!");
        }
        this.internalEventDrivenJobService = internalEventDrivenJobService;
        if (this.internalEventDrivenJobService == null) {
            throw new IllegalArgumentException("internalEventDrivenJobService cannot be null!");
        }
        this.contextParametersInstanceService = contextParametersInstanceService;
        if (this.contextParametersInstanceService == null) {
            throw new IllegalArgumentException("contextParametersInstanceService cannot be null!");
        }
        this.contextInstancePublicationService = contextParametersUpdateService;
        if (this.contextInstancePublicationService == null) {
            throw new IllegalArgumentException("contextParametersUpdateService cannot be null!");
        }
        this.jobLockCacheService = jobLockCacheService;
        if (this.jobLockCacheService == null) {
            throw new IllegalArgumentException("jobLockCacheService cannot be null!");
        }
        this.scheduledContextService = scheduledContextService;
        if (this.scheduledContextService == null) {
            throw new IllegalArgumentException("scheduledContextService cannot be null!");
        }
        this.schedulerJobInstanceService = schedulerJobInstanceService;
        if (this.schedulerJobInstanceService == null) {
            throw new IllegalArgumentException("schedulerJobInstanceService cannot be null!");
        }
        this.contextInstanceStateChangeEventBroadcaster = contextInstanceStateChangeEventBroadcaster;
        if (this.contextInstanceStateChangeEventBroadcaster == null) {
            throw new IllegalArgumentException("contextInstanceStateChangeEventBroadcaster cannot be null!");
        }
        this.schedulerJobStateChangeEventBroadcaster = schedulerJobStateChangeEventBroadcaster;
        if (this.schedulerJobStateChangeEventBroadcaster == null) {
            throw new IllegalArgumentException("schedulerJobStateChangeEventBroadcaster cannot be null!");
        }
        this.jobLockCacheInitialisationService = jobLockCacheInitialisationService;
        if (this.jobLockCacheInitialisationService == null) {
            throw new IllegalArgumentException("jobLockCacheInitialisationService cannot be null!");
        }
        this.contextInstanceSchedulerService = contextInstanceSchedulerService;
        if (this.contextInstanceSchedulerService == null) {
            throw new IllegalArgumentException("contextInstanceSchedulerService cannot be null!");
        }
        this.timeService = timeService;
        if (this.timeService == null) {
            throw new IllegalArgumentException("timeService cannot be null!");
        }
        this.objectMapper = ObjectMapperFactory.newInstance();
    }

    protected void saveContextInstance(ContextInstance contextInstance, InstanceStatus instanceStatus) {
        InstanceStatus previousStatus = contextInstance.getStatus();
        contextInstance.setStatus(instanceStatus);
        ScheduledContextInstanceRecordImpl scheduledContextInstanceRecord = new ScheduledContextInstanceRecordImpl();
        scheduledContextInstanceRecord.setContextName(contextInstance.getName());
        scheduledContextInstanceRecord.setContextInstance(contextInstance);
        scheduledContextInstanceRecord.setTimestamp(contextInstance.getCreatedDateTime());
        scheduledContextInstanceRecord.setStartTime(contextInstance.getStartTime());
        scheduledContextInstanceRecord.setEndTime(contextInstance.getEndTime());
        scheduledContextInstanceRecord.setStatus(contextInstance.getStatus().name());
        this.scheduledContextInstanceService.save((ScheduledContextInstanceRecord)scheduledContextInstanceRecord);
        this.contextInstanceStateChangeEventBroadcaster.broadcast((ContextInstanceStateChangeEvent)new ContextInstanceStateChangeEventImpl(contextInstance.getId(), contextInstance, previousStatus, contextInstance.getStatus()));
    }

    protected void initialiseContextMachine(ContextTemplate context, ContextInstance instance, boolean initialiseJobs, boolean isInitialContextInstantiation, List<ContextParameterInstance> contextParameterInstances) throws Exception {
        if (initialiseJobs) {
            SchedulerJobInstancesInitialisationParametersImpl parameters = new SchedulerJobInstancesInitialisationParametersImpl(false);
            this.schedulerJobInstanceService.initialiseSchedulerJobInstancesForContext(instance, (SchedulerJobInstancesInitialisationParameters)parameters);
        }
        Map<String, InternalEventDrivenJobInstance> internalJobs = this.getInternalJobs(instance.getId());
        HashMap<String, ModuleMetaData> agents = this.getAgents((Context)context);
        internalJobs.entrySet().forEach(job -> {
            ContextInstance child;
            if (((InternalEventDrivenJobInstance)job.getValue()).isSkip()) {
                child = ContextHelper.getChildContextInstance((String)((InternalEventDrivenJobInstance)job.getValue()).getChildContextName(), (ContextInstance)instance);
                if (child == null) {
                    LOG.warn("Could not load child context[{}] from context instance name[{}] context instance id[{}] when attempting to initialise the context machine. This is likely due to the child context name being duplicated in the context. The context instance will not have been recovered with skipped jobs set correctly.");
                } else if (!child.getScheduledJobsMap().containsKey(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())) {
                    LOG.warn("Could not set job to skip as job with identifier [{}] was not found in child context [{}].", (Object)((InternalEventDrivenJobInstance)job.getValue()).getIdentifier(), (Object)child.getName());
                } else {
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setSkip(((InternalEventDrivenJobInstance)job.getValue()).isSkip());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setStatus(((InternalEventDrivenJobInstance)job.getValue()).getStatus());
                }
            }
            if (((InternalEventDrivenJobInstance)job.getValue()).isHeld()) {
                child = ContextHelper.getChildContextInstance((String)((InternalEventDrivenJobInstance)job.getValue()).getChildContextName(), (ContextInstance)instance);
                if (child == null) {
                    LOG.warn("Could not load child context[{}] from context instance name[{}] context instance id[{}] when attempting to initialise the context machine. This is likely due to the child context name being duplicated in the context. The context instance will not have been recovered with held jobs set correctly");
                } else if (!child.getScheduledJobsMap().containsKey(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())) {
                    LOG.warn("Could not set job to hold as job with identifier [{}] was not found in child context [{}].", (Object)((InternalEventDrivenJobInstance)job.getValue()).getIdentifier(), (Object)child.getName());
                } else {
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setHeld(((InternalEventDrivenJobInstance)job.getValue()).isHeld());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setStatus(((InternalEventDrivenJobInstance)job.getValue()).getStatus());
                }
            }
        });
        Map<String, GlobalEventJobInstance> globalEventJobMap = this.getGlobalEventJobs(instance.getId());
        globalEventJobMap.entrySet().forEach(job -> {
            if (((GlobalEventJobInstance)job.getValue()).getSkippedContexts() != null && ((GlobalEventJobInstance)job.getValue()).getSkippedContexts().containsKey(instance.getName())) {
                ContextInstance child = ContextHelper.getChildContextInstance((String)((GlobalEventJobInstance)job.getValue()).getChildContextName(), (ContextInstance)instance);
                if (child == null) {
                    LOG.warn("Could not load child context[{}] from context instance name[{}] context instance id[{}] when attempting to initialise the context machine. This is likely due to the child context name being duplicated in the context. The context instance will not have been recovered with skipped jobs set correctly.");
                } else if (!child.getScheduledJobsMap().containsKey(((GlobalEventJobInstance)job.getValue()).getIdentifier())) {
                    LOG.warn("Could not set job to skip as job with identifier [{}] was not found in child context [{}].", (Object)((GlobalEventJobInstance)job.getValue()).getIdentifier(), (Object)child.getName());
                } else {
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((GlobalEventJobInstance)job.getValue()).getIdentifier())).setSkip(((GlobalEventJobInstance)job.getValue()).isSkip());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((GlobalEventJobInstance)job.getValue()).getIdentifier())).setStatus(((GlobalEventJobInstance)job.getValue()).getStatus());
                }
            }
        });
        Map<String, QuartzScheduleDrivenJobInstance> quartzScheduleDrivenJobInstanceMap = this.getQuartzBasedJobs(instance.getId());
        ContextMachine contextMachine = new ContextMachine(context, instance, this.scheduledContextInstanceService, globalEventJobMap, quartzScheduleDrivenJobInstanceMap, internalJobs, this.queueDirectory, agents, this.initialiseJobLockCache(context, isInitialContextInstantiation), this.contextParametersInstanceService, this.scheduledContextService, this.schedulerJobInstanceService, this.jobLockCacheInitialisationService, this.contextInstancePublicationService);
        contextMachine.init();
        contextMachine.setSchedulerJobInitiationEventRaisedListener(event -> this.jobInitiationService.raiseSchedulerJobInitiationEvent(event.getAgentUrl(), event));
        contextMachine.addSchedulerJobStateChangeEventListener(event -> this.schedulerJobInstanceService.update(event.getSchedulerJobInstance()));
        contextMachine.addContextInstanceStateChangeEventListener(event -> this.contextInstanceStateChangeEventBroadcaster.broadcast(event));
        contextMachine.addSchedulerJobStateChangeEventListener(event -> this.schedulerJobStateChangeEventBroadcaster.broadcast(event));
        if (contextParameterInstances == null) {
            this.setContextParametersOnInstance(instance, internalJobs);
        } else {
            instance.setContextParameters(contextParameterInstances);
        }
        this.propagateContextInstanceToAgents(instance, agents);
        if (isInitialContextInstantiation) {
            instance.setStartTime(System.currentTimeMillis());
            instance.setProjectedEndTime(CronUtils.getEpochMilliOfPreviousFireTime((String)instance.getTimeWindowStart()) + instance.getContextTtlMilliseconds());
            this.saveContextInstance(instance, InstanceStatus.WAITING);
        }
        ContextMachineCache.instance().put(contextMachine);
    }

    protected void prepareContextInstance(ContextTemplate context, ContextInstance instance, boolean initialiseJobs) throws Exception {
        SchedulerJobInstancesInitialisationParametersImpl parameters = new SchedulerJobInstancesInitialisationParametersImpl(false);
        if (initialiseJobs) {
            this.schedulerJobInstanceService.initialiseSchedulerJobInstancesForContext(instance, (SchedulerJobInstancesInitialisationParameters)parameters);
        }
        Map<String, InternalEventDrivenJobInstance> internalJobs = this.getInternalJobs(instance.getId());
        HashMap<String, ModuleMetaData> agents = this.getAgents((Context)context);
        internalJobs.entrySet().forEach(job -> {
            ContextInstance child;
            if (((InternalEventDrivenJobInstance)job.getValue()).isSkip()) {
                child = ContextHelper.getChildContextInstance((String)((InternalEventDrivenJobInstance)job.getValue()).getChildContextName(), (ContextInstance)instance);
                if (child == null) {
                    LOG.warn("Could not load child context[{}] from context instance name[{}] context instance id[{}] when attempting to initialise the context machine. This is likely due to the child context name being duplicated in the context. The context instance will not have been recovered with skipped jobs set correctly.");
                } else if (!child.getScheduledJobsMap().containsKey(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())) {
                    LOG.warn("Could not set job to skip as job with identifier [{}] was not found in child context [{}].", (Object)((InternalEventDrivenJobInstance)job.getValue()).getIdentifier(), (Object)child.getName());
                } else {
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setSkip(((InternalEventDrivenJobInstance)job.getValue()).isSkip());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setStatus(((InternalEventDrivenJobInstance)job.getValue()).getStatus());
                }
            }
            if (((InternalEventDrivenJobInstance)job.getValue()).isHeld()) {
                child = ContextHelper.getChildContextInstance((String)((InternalEventDrivenJobInstance)job.getValue()).getChildContextName(), (ContextInstance)instance);
                if (child == null) {
                    LOG.warn("Could not load child context[{}] from context instance name[{}] context instance id[{}] when attempting to initialise the context machine. This is likely due to the child context name being duplicated in the context. The context instance will not have been recovered with held jobs set correctly");
                } else if (!child.getScheduledJobsMap().containsKey(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())) {
                    LOG.warn("Could not set job to hold as job with identifier [{}] was not found in child context [{}].", (Object)((InternalEventDrivenJobInstance)job.getValue()).getIdentifier(), (Object)child.getName());
                } else {
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setHeld(((InternalEventDrivenJobInstance)job.getValue()).isHeld());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((InternalEventDrivenJobInstance)job.getValue()).getIdentifier())).setStatus(((InternalEventDrivenJobInstance)job.getValue()).getStatus());
                }
            }
        });
        Map<String, GlobalEventJobInstance> globalEventJobMap = this.getGlobalEventJobs(instance.getId());
        globalEventJobMap.entrySet().forEach(job -> {
            if (((GlobalEventJobInstance)job.getValue()).getSkippedContexts() != null && ((GlobalEventJobInstance)job.getValue()).getSkippedContexts().containsKey(instance.getName())) {
                ContextInstance child = ContextHelper.getChildContextInstance((String)((GlobalEventJobInstance)job.getValue()).getChildContextName(), (ContextInstance)instance);
                if (child == null) {
                    LOG.warn("Could not load child context[{}] from context instance name[{}] context instance id[{}] when attempting to initialise the context machine. This is likely due to the child context name being duplicated in the context. The context instance will not have been recovered with skipped jobs set correctly.");
                } else if (!child.getScheduledJobsMap().containsKey(((GlobalEventJobInstance)job.getValue()).getIdentifier())) {
                    LOG.warn("Could not set job to skip as job with identifier [{}] was not found in child context [{}].", (Object)((GlobalEventJobInstance)job.getValue()).getIdentifier(), (Object)child.getName());
                } else {
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((GlobalEventJobInstance)job.getValue()).getIdentifier())).setSkip(((GlobalEventJobInstance)job.getValue()).isSkip());
                    ((SchedulerJobInstance)child.getScheduledJobsMap().get(((GlobalEventJobInstance)job.getValue()).getIdentifier())).setStatus(((GlobalEventJobInstance)job.getValue()).getStatus());
                }
            }
        });
        Map<String, QuartzScheduleDrivenJobInstance> quartzScheduleDrivenJobInstanceMap = this.getQuartzBasedJobs(instance.getId());
        ContextMachine contextMachine = new ContextMachine(context, instance, this.scheduledContextInstanceService, globalEventJobMap, quartzScheduleDrivenJobInstanceMap, internalJobs, this.queueDirectory, agents, null, this.contextParametersInstanceService, this.scheduledContextService, this.schedulerJobInstanceService, this.jobLockCacheInitialisationService, this.contextInstancePublicationService);
        contextMachine.addSchedulerJobStateChangeEventListener(event -> this.schedulerJobInstanceService.update(event.getSchedulerJobInstance()));
        contextMachine.addSchedulerJobStateChangeEventListener(event -> this.schedulerJobStateChangeEventBroadcaster.broadcast(event));
        contextMachine.getContext().setStatus(InstanceStatus.PREPARED);
        ContextMachineCache.instance().put(contextMachine);
    }

    protected void prepareFutureContextInstance(String contextName) {
        ScheduledContextRecord scheduledContextRecord = this.scheduledContextService.findById(contextName);
        if (scheduledContextRecord == null) {
            String message = String.format("Could not find scheduledContextRecord for context name [%s] when attempting to prepare instance!", contextName);
            LOG.error(message);
            throw new RuntimeException(message);
        }
        if (scheduledContextRecord.isDisabled()) {
            LOG.info(String.format("Context name [%s] is disabled and will not be prepared!", contextName));
            return;
        }
        try {
            byte[] scheduledContextRecordContext = this.objectMapper.writeValueAsBytes((Object)scheduledContextRecord.getContext());
            ContextTemplate context = (ContextTemplate)this.objectMapper.readValue(scheduledContextRecordContext, ContextTemplateImpl.class);
            List<ContextInstance> contextInstances = this.findPrepared(context.getName());
            ContextInstanceImpl preparedFutureContextInstance = (ContextInstanceImpl)this.objectMapper.readValue(scheduledContextRecordContext, ContextInstanceImpl.class);
            preparedFutureContextInstance.setStartTime(CronUtils.getEpochMilliOfNextFireTimeAccountingForBlackoutWindow((String)context.getTimeWindowStart(), (List)context.getBlackoutWindowCronExpressions(), (Map)context.getBlackoutWindowDateTimeRanges(), (String)context.getTimezone()));
            AtomicBoolean preparedInstanceExists = new AtomicBoolean(false);
            contextInstances.forEach(contextInstance -> {
                if (preparedFutureContextInstance.getStartTime() == contextInstance.getStartTime()) {
                    preparedInstanceExists.set(true);
                }
            });
            if (!preparedInstanceExists.get() && preparedFutureContextInstance.getStartTime() > 0L) {
                this.prepareContextInstance(context, (ContextInstance)preparedFutureContextInstance, true);
                this.saveContextInstance((ContextInstance)preparedFutureContextInstance, InstanceStatus.PREPARED);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("An error has occurred executing registering job [%s]", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void removeAgentInstances(ContextInstance instance) {
        HashMap<String, ModuleMetaData> agents = this.getAgents((Context)instance);
        if (!agents.keySet().isEmpty()) {
            for (String key : agents.keySet()) {
                ModuleMetaData agent = agents.get(key);
                this.contextInstancePublicationService.remove(agent.getUrl(), (Object)instance);
            }
        }
    }

    private JobLockCache initialiseJobLockCache(ContextTemplate context, boolean isRefresh) {
        this.jobLockCacheInitialisationService.initialiseJobLockCache((Context)context, isRefresh);
        return JobLockCacheImpl.instance();
    }

    private HashMap<String, ModuleMetaData> getAgents(Context context) {
        HashMap<String, ModuleMetaData> agents = new HashMap<String, ModuleMetaData>();
        List contextAgents = ContextHelper.getAllAgents((Context)context);
        ModuleMetadataSearchResults searchResults = this.moduleMetadataService.find(contextAgents, ModuleType.SCHEDULER_AGENT, Integer.valueOf(-1), Integer.valueOf(-1));
        searchResults.getResultList().forEach(agent -> agents.put(agent.getName(), (ModuleMetaData)agent));
        return agents;
    }

    private HashMap<String, ModuleMetaData> getAllAgents() {
        HashMap<String, ModuleMetaData> agents = new HashMap<String, ModuleMetaData>();
        ModuleMetadataSearchResults searchResults = this.moduleMetadataService.find(List.of(), ModuleType.SCHEDULER_AGENT, Integer.valueOf(-1), Integer.valueOf(-1));
        searchResults.getResultList().forEach(agent -> agents.put(agent.getName(), (ModuleMetaData)agent));
        return agents;
    }

    private Map<String, InternalEventDrivenJobInstance> getInternalJobs(String contextInstanceId) {
        SchedulerJobInstanceSearchFilterImpl filter = new SchedulerJobInstanceSearchFilterImpl();
        filter.setContextInstanceId(contextInstanceId);
        filter.setJobType("internalEventDrivenJobInstance");
        SearchResults internalEventDrivenJobRecordSearchResults = this.schedulerJobInstanceService.getScheduledContextInstancesByFilter((SchedulerJobInstanceSearchFilter)filter, -1, -1, null, null);
        Map<String, InternalEventDrivenJobInstance> internalEventDrivenJobMap = internalEventDrivenJobRecordSearchResults.getResultList().stream().map(internalEventDrivenJobRecord -> (InternalEventDrivenJobInstance)internalEventDrivenJobRecord.getSchedulerJobInstance()).collect(Collectors.toMap(key -> key.getIdentifier() + "-" + key.getChildContextName(), Function.identity()));
        internalEventDrivenJobMap.entrySet().forEach(entry -> {
            if (((InternalEventDrivenJobInstance)entry.getValue()).getStatus().equals((Object)InstanceStatus.SKIPPED)) {
                ((InternalEventDrivenJobInstance)entry.getValue()).setSkip(true);
            }
        });
        return internalEventDrivenJobMap;
    }

    private Map<String, QuartzScheduleDrivenJobInstance> getQuartzBasedJobs(String contextInstanceId) {
        SchedulerJobInstanceSearchFilterImpl filter = new SchedulerJobInstanceSearchFilterImpl();
        filter.setContextInstanceId(contextInstanceId);
        filter.setJobType("quartzScheduleDrivenJobInstance");
        SearchResults internalEventDrivenJobRecordSearchResults = this.schedulerJobInstanceService.getScheduledContextInstancesByFilter((SchedulerJobInstanceSearchFilter)filter, -1, -1, null, null);
        Map<String, QuartzScheduleDrivenJobInstance> quartzScheduleDrivenJobInstanceMap = internalEventDrivenJobRecordSearchResults.getResultList().stream().map(internalEventDrivenJobRecord -> (QuartzScheduleDrivenJobInstance)internalEventDrivenJobRecord.getSchedulerJobInstance()).collect(Collectors.toMap(key -> key.getIdentifier(), Function.identity(), (a1, a2) -> a1));
        return quartzScheduleDrivenJobInstanceMap;
    }

    private Map<String, GlobalEventJobInstance> getGlobalEventJobs(String contextInstanceId) {
        SchedulerJobInstanceSearchFilterImpl filter = new SchedulerJobInstanceSearchFilterImpl();
        filter.setContextInstanceId(contextInstanceId);
        filter.setJobType("globalEventJobInstance");
        SearchResults globalEventJobRecordSearchResults = this.schedulerJobInstanceService.getScheduledContextInstancesByFilter((SchedulerJobInstanceSearchFilter)filter, -1, -1, null, null);
        Map<String, GlobalEventJobInstance> globalEventJobMap = globalEventJobRecordSearchResults.getResultList().stream().map(globalEventJobRecord -> (GlobalEventJobInstance)globalEventJobRecord.getSchedulerJobInstance()).collect(Collectors.toMap(key -> key.getIdentifier() + "-" + key.getChildContextName(), Function.identity(), (a1, a2) -> a1));
        return globalEventJobMap;
    }

    protected void removeAllContextInstancesFromAgent() {
        HashMap<String, ModuleMetaData> agents = this.getAllAgents();
        if (!agents.keySet().isEmpty()) {
            for (String key : agents.keySet()) {
                ModuleMetaData agent = agents.get(key);
                this.contextInstancePublicationService.removeAll(agent.getUrl());
            }
        }
    }

    private void propagateContextInstanceToAgents(ContextInstance contextInstance, HashMap<String, ModuleMetaData> agents) {
        if (!agents.keySet().isEmpty()) {
            for (String key : agents.keySet()) {
                ModuleMetaData agent = agents.get(key);
                this.contextInstancePublicationService.publish(agent.getUrl(), (Object)contextInstance);
            }
        }
    }

    private void setContextParametersOnInstance(ContextInstance contextInstance, Map<String, InternalEventDrivenJobInstance> internalJobs) {
        this.contextParametersInstanceService.populateContextParameters();
        this.contextParametersInstanceService.populateContextParametersOnContextInstance(contextInstance, internalJobs);
    }

    protected List<ContextInstance> findPrepared(String contextName) {
        SolrContextInstanceSearchFilterImpl filter = new SolrContextInstanceSearchFilterImpl();
        filter.setStatus(InstanceStatus.PREPARED.name());
        filter.setContextInstanceNames(Collections.singletonList(contextName));
        SearchResults results = this.scheduledContextInstanceService.getScheduledContextInstancesByFilter((ContextInstanceSearchFilter)filter, -1, -1, null, null);
        return results.getResultList().stream().map(scheduledContextInstanceRecord -> scheduledContextInstanceRecord.getContextInstance()).collect(Collectors.toList());
    }

    protected void removeAllPrepared(String contextName) {
        SolrContextInstanceSearchFilterImpl filter = new SolrContextInstanceSearchFilterImpl();
        filter.setStatus(InstanceStatus.PREPARED.name());
        filter.setContextInstanceNames(Collections.singletonList(contextName));
        SearchResults results = this.scheduledContextInstanceService.getScheduledContextInstancesByFilter((ContextInstanceSearchFilter)filter, -1, -1, null, null);
        results.getResultList().forEach(scheduledContextInstanceRecord -> {
            this.schedulerJobInstanceService.deleteSchedulerJobInstances(scheduledContextInstanceRecord.getContextInstanceId());
            this.scheduledContextInstanceService.deleteById(scheduledContextInstanceRecord.getId());
        });
    }

    protected void removeContextInstance(String contextInstanceId) {
        this.scheduledContextInstanceService.deleteById(contextInstanceId);
        this.schedulerJobInstanceService.deleteSchedulerJobInstances(contextInstanceId);
    }
}

