/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context.global;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.model.event.ContextualisedScheduledProcessEventImpl;
import org.ikasan.job.orchestration.model.event.SchedulerJobInitiationEventImpl;
import org.ikasan.orchestration.service.context.global.GlobalEventServiceException;
import org.ikasan.spec.scheduled.event.model.ScheduledProcessEvent;
import org.ikasan.spec.scheduled.event.model.SchedulerJobInitiationEvent;
import org.ikasan.spec.scheduled.instance.model.GlobalEventJobInstance;
import org.ikasan.spec.scheduled.job.service.GlobalEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalEventServiceImpl
implements GlobalEventService {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalEventServiceImpl.class);
    public static final String GLOBAL_EVENT_MANUALLY_RAISED = "GLOBAL_EVENT_MANUALLY_RAISED";

    public void raiseGlobalEventJob(GlobalEventJobInstance globalEventJobInstance, String contextInstanceId, String username) {
        SchedulerJobInitiationEventImpl schedulerJobInitiationEvent = new SchedulerJobInitiationEventImpl();
        schedulerJobInitiationEvent.setAgentName("GLOBAL_EVENT");
        schedulerJobInitiationEvent.setJobName(globalEventJobInstance.getJobName());
        schedulerJobInitiationEvent.setContextInstanceId(contextInstanceId);
        ContextualisedScheduledProcessEventImpl catalystEvent = new ContextualisedScheduledProcessEventImpl();
        catalystEvent.setJobName("Manually raise by user " + username);
        catalystEvent.setContextName(GLOBAL_EVENT_MANUALLY_RAISED);
        catalystEvent.setContextInstanceId("Not Applicable");
        catalystEvent.setFireTime(System.currentTimeMillis());
        catalystEvent.setCompletionTime(System.currentTimeMillis());
        schedulerJobInitiationEvent.setCatalystEvent((ScheduledProcessEvent)catalystEvent);
        ContextualisedScheduledProcessEventImpl scheduledProcessEvent = new ContextualisedScheduledProcessEventImpl();
        scheduledProcessEvent.setCatalystEvent((ScheduledProcessEvent)catalystEvent);
        globalEventJobInstance.setScheduledProcessEvent((ScheduledProcessEvent)scheduledProcessEvent);
        ContextMachine contextMachine = ContextMachineCache.instance().getByContextInstanceId(contextInstanceId);
        if (contextMachine == null) {
            throw new GlobalEventServiceException(String.format("Could not resolve context instance from the context instance cache using id[%s]", contextInstanceId));
        }
        try {
            contextMachine.broadcastGlobalEvents((SchedulerJobInitiationEvent)schedulerJobInitiationEvent, false, false);
        }
        catch (IOException e) {
            throw new GlobalEventServiceException("An exception has occurred broadcast global events", e);
        }
    }

    public void raiseGlobalEventJob(String globalJobName) {
        ConcurrentHashMap contextMachineMap = ContextMachineCache.instance().getContextInstanceByContextInstanceIdCache();
        if (contextMachineMap == null || contextMachineMap.size() == 0) {
            LOG.warn("There are no context instances running to send the Global Event [{}]. This will be ignored", (Object)globalJobName);
            return;
        }
        Map.Entry firstContextMachine = contextMachineMap.entrySet().iterator().next();
        SchedulerJobInitiationEventImpl schedulerJobInitiationEvent = new SchedulerJobInitiationEventImpl();
        schedulerJobInitiationEvent.setAgentName("GLOBAL_EVENT");
        schedulerJobInitiationEvent.setJobName(globalJobName);
        schedulerJobInitiationEvent.setContextInstanceId(((ContextMachine)firstContextMachine.getValue()).getContext().getId());
        try {
            ((ContextMachine)firstContextMachine.getValue()).broadcastGlobalEvents((SchedulerJobInitiationEvent)schedulerJobInitiationEvent, true, true);
        }
        catch (IOException e) {
            throw new GlobalEventServiceException("An exception has occurred broadcast global events", e);
        }
    }
}

