/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context.recovery;

import com.esotericsoftware.minlog.Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ikasan.job.orchestration.context.register.ContextInstanceSchedulerService;
import org.ikasan.job.orchestration.context.util.CronUtils;
import org.ikasan.job.orchestration.context.util.QuartzTimeWindowChecker;
import org.ikasan.job.orchestration.context.util.TimeService;
import org.ikasan.orchestration.service.context.ContextInstanceServiceBase;
import org.ikasan.orchestration.service.context.recovery.MissingContextInstanceRecoveryRunnable;
import org.ikasan.orchestration.service.context.util.JobServiceThreadFactory;
import org.ikasan.spec.metadata.ModuleMetaDataService;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.ScheduledContextRecord;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRecoveryService;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRegistrationService;
import org.ikasan.spec.scheduled.context.service.ScheduledContextService;
import org.ikasan.spec.scheduled.event.service.ContextInstanceStateChangeEventBroadcaster;
import org.ikasan.spec.scheduled.event.service.SchedulerJobStateChangeEventBroadcaster;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.ScheduledContextInstanceRecord;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.ikasan.spec.scheduled.instance.service.ScheduledContextInstanceService;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstanceService;
import org.ikasan.spec.scheduled.job.service.InternalEventDrivenJobService;
import org.ikasan.spec.scheduled.job.service.JobInitiationService;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheInitialisationService;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheService;
import org.ikasan.spec.search.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInstanceRecoveryServiceImpl
extends ContextInstanceServiceBase
implements ContextInstanceRecoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(ContextInstanceRecoveryServiceImpl.class);
    private final ExecutorService executor = Executors.newCachedThreadPool(new JobServiceThreadFactory("ContextInstanceRecoveryServiceImpl"));
    private final ContextInstanceRegistrationService contextInstanceRegistrationService;
    private boolean isIkasanEnterpriseSchedulerInstance;

    public ContextInstanceRecoveryServiceImpl(String queueDirectory, ScheduledContextInstanceService scheduledContextInstanceService, JobInitiationService jobInitiationService, ModuleMetaDataService moduleMetadataService, InternalEventDrivenJobService internalEventDrivenJobService, ContextParametersInstanceService contextParametersInstanceService, ContextInstancePublicationService contextInstancePublicationService, JobLockCacheService jobLockCacheService, ScheduledContextService scheduledContextService, SchedulerJobInstanceService schedulerJobInstanceService, ContextInstanceStateChangeEventBroadcaster contextInstanceStateChangeEventBroadcaster, SchedulerJobStateChangeEventBroadcaster schedulerJobStateChangeEventBroadcaster, JobLockCacheInitialisationService jobLockCacheInitialisationService, ContextInstanceSchedulerService contextInstanceSchedulerService, TimeService timeService, ContextInstanceRegistrationService contextInstanceRegistrationService, boolean isIkasanEnterpriseSchedulerInstance) {
        super(queueDirectory, scheduledContextInstanceService, jobInitiationService, moduleMetadataService, internalEventDrivenJobService, contextParametersInstanceService, contextInstancePublicationService, jobLockCacheService, scheduledContextService, schedulerJobInstanceService, contextInstanceStateChangeEventBroadcaster, schedulerJobStateChangeEventBroadcaster, jobLockCacheInitialisationService, contextInstanceSchedulerService, timeService);
        this.contextInstanceRegistrationService = contextInstanceRegistrationService;
        if (this.contextInstanceRegistrationService == null) {
            throw new IllegalArgumentException("contextInstanceRegistrationService cannot be null!");
        }
        this.isIkasanEnterpriseSchedulerInstance = isIkasanEnterpriseSchedulerInstance;
    }

    public void recoverInstances() {
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.warn("This instance of the dashboard is not configured to run as a scheduler, therefore no job plan instance recovery will run!");
            return;
        }
        SearchResults contextInstanceRecords = this.scheduledContextInstanceService.getScheduledContextInstancesByStatus(List.of(InstanceStatus.WAITING, InstanceStatus.RUNNING, InstanceStatus.ERROR, InstanceStatus.COMPLETE));
        HashMap<String, ArrayList<ScheduledContextInstanceRecord>> contextNameToInstances = new HashMap<String, ArrayList<ScheduledContextInstanceRecord>>();
        for (ScheduledContextInstanceRecord scheduledContextInstanceRecord : contextInstanceRecords.getResultList()) {
            List scheduledContextInstanceRecords = (List)contextNameToInstances.get(scheduledContextInstanceRecord.getContextName());
            if (scheduledContextInstanceRecords == null) {
                contextNameToInstances.put(scheduledContextInstanceRecord.getContextName(), new ArrayList<ScheduledContextInstanceRecord>(List.of(scheduledContextInstanceRecord)));
                continue;
            }
            scheduledContextInstanceRecords.add(scheduledContextInstanceRecord);
        }
        SearchResults scheduledContextRecords = this.scheduledContextService.findAll();
        Date now = this.timeService.getDateNow();
        super.removeAllContextInstancesFromAgent();
        for (ScheduledContextRecord scheduledContextRecord : scheduledContextRecords.getResultList()) {
            ContextTemplate context = scheduledContextRecord.getContext();
            if (context.isDisabled()) {
                super.removeAllPrepared(context.getName());
                Log.info((String)("Not Recovering context " + scheduledContextRecord.getContextName() + " instance ID " + scheduledContextRecord.getId() + " because the context is disabled"));
                continue;
            }
            try {
                List<ContextInstance> prepared = this.findPrepared(context.getName());
                ArrayList future = new ArrayList();
                for (ContextInstance contextInstance2 : prepared) {
                    if (contextInstance2.getStartTime() < System.currentTimeMillis()) {
                        super.removeContextInstance(contextInstance2.getId());
                        if (!contextNameToInstances.containsKey(contextInstance2.getName())) continue;
                        ((List)contextNameToInstances.get(contextInstance2.getName())).remove(contextInstance2);
                        continue;
                    }
                    future.add(contextInstance2);
                    super.prepareContextInstance(context, contextInstance2, false);
                }
                if (future.isEmpty()) {
                    super.prepareFutureContextInstance(context.getName());
                }
            }
            catch (Exception e) {
                Log.warn((String)String.format("Could not recover prepared instance for context[%s]", context.getName()), (Throwable)e);
            }
            List scheduledContextInstanceRecords = (List)contextNameToInstances.get(context.getName());
            if (scheduledContextInstanceRecords != null) {
                for (ScheduledContextInstanceRecord scheduledContextInstanceRecord : scheduledContextInstanceRecords) {
                    ContextInstance contextInstance;
                    try {
                        ContextInstance contextInstance2;
                        if (!(scheduledContextInstanceRecord.getContextInstance().getProjectedEndTime() != 0L && scheduledContextInstanceRecord.getContextInstance().getProjectedEndTime() >= System.currentTimeMillis() || scheduledContextInstanceRecord.getContextInstance().isRunContextUntilManuallyEnded())) {
                            LOG.info("Removing context instance[{}], with name[{}] as the projected end time has been passed and the context is not marked to run until manually ended.", (Object)scheduledContextInstanceRecord.getContextInstanceId(), (Object)scheduledContextInstanceRecord.getContextName());
                            this.removeAgentInstances(scheduledContextInstanceRecord.getContextInstance());
                            contextInstance2 = scheduledContextInstanceRecord.getContextInstance();
                            contextInstance2.setEndTime(System.currentTimeMillis());
                            this.saveContextInstance(contextInstance2, InstanceStatus.ENDED);
                            continue;
                        }
                        if (QuartzTimeWindowChecker.withinOperatingWindowOnRecovery((long)scheduledContextInstanceRecord.getContextInstance().getStartTime(), (long)scheduledContextInstanceRecord.getContextInstance().getProjectedEndTime(), (long)System.currentTimeMillis()) || scheduledContextInstanceRecord.getContextInstance().isRunContextUntilManuallyEnded()) {
                            if (scheduledContextInstanceRecord == null) continue;
                            try {
                                contextInstance2 = scheduledContextInstanceRecord.getContextInstance();
                                if (!QuartzTimeWindowChecker.fallsWithinCronBlackoutWindows((List)contextInstance2.getBlackoutWindowCronExpressions(), (String)contextInstance2.getTimezone(), (Date)now) && !QuartzTimeWindowChecker.fallsWithinDateTimeBlackoutRanges((Map)contextInstance2.getBlackoutWindowDateTimeRanges(), (Date)now)) {
                                    this.initialiseContextMachine(context, contextInstance2, false, false, null);
                                    if (contextInstance2.isRunContextUntilManuallyEnded()) continue;
                                    this.contextInstanceSchedulerService.registerEndJobAndTrigger(contextInstance2.getName(), CronUtils.buildCronFromOriginal((long)contextInstance2.getProjectedEndTime(), (String)contextInstance2.getTimezone()), contextInstance2.getTimezone(), contextInstance2.getId());
                                    LOG.info(String.format("Recovering context [%s] instance id [%s]", contextInstance2.getName(), contextInstance2.getId()));
                                    continue;
                                }
                                LOG.info(String.format("Not Recovering. Job Plan [%s] instance ID [%s] falls within a blackout time window and will not be registered!", contextInstance2.getName(), contextInstance2.getId()));
                                this.removeAgentInstances(contextInstance2);
                                contextInstance2.setEndTime(System.currentTimeMillis());
                                this.saveContextInstance(contextInstance2, InstanceStatus.ENDED);
                            }
                            catch (Exception e) {
                                LOG.error(String.format("Removing Job Plan [%s] instance ID [%s] due to an issue that makes it unrecoverable: ", scheduledContextInstanceRecord.getContextName(), scheduledContextInstanceRecord.getContextInstanceId()), (Throwable)e);
                                this.removeAgentInstances(scheduledContextInstanceRecord.getContextInstance());
                                contextInstance = scheduledContextInstanceRecord.getContextInstance();
                                contextInstance.setEndTime(System.currentTimeMillis());
                                this.saveContextInstance(contextInstance, InstanceStatus.ENDED);
                            }
                            continue;
                        }
                        Log.info((String)("Not Recovering context " + scheduledContextRecord.getContextName() + " instance ID " + scheduledContextRecord.getId() + " because we are now outside it time window. Ending it"));
                        this.removeAgentInstances(scheduledContextInstanceRecord.getContextInstance());
                        contextInstance2 = scheduledContextInstanceRecord.getContextInstance();
                        contextInstance2.setEndTime(System.currentTimeMillis());
                        this.saveContextInstance(contextInstance2, InstanceStatus.ENDED);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (scheduledContextInstanceRecord == null) continue;
                        LOG.error(String.format("Not Recovering context [%s] instance ID [%s] due an issue with the definition of the cron expression for the time windows. Ending it", scheduledContextInstanceRecord.getContextName(), scheduledContextInstanceRecord.getContextInstanceId()), (Throwable)e);
                        this.removeAgentInstances(scheduledContextInstanceRecord.getContextInstance());
                        contextInstance = scheduledContextInstanceRecord.getContextInstance();
                        contextInstance.setEndTime(System.currentTimeMillis());
                        this.saveContextInstance(contextInstance, InstanceStatus.ENDED);
                    }
                }
                continue;
            }
            if (!QuartzTimeWindowChecker.withinOperatingWindow((String)context.getTimezone(), (String)context.getTimeWindowStart(), (long)context.getContextTtlMilliseconds(), (Date)now)) continue;
            String message = String.format("Recovering context [%s] does not have an instance. Creating instance now!", scheduledContextRecord.getContextName());
            LOG.info(message);
            this.executor.execute(new MissingContextInstanceRecoveryRunnable(this.queueDirectory, this.scheduledContextInstanceService, this.jobInitiationService, this.moduleMetadataService, this.internalEventDrivenJobService, this.contextParametersInstanceService, this.contextInstancePublicationService, this.jobLockCacheService, this.scheduledContextService, scheduledContextRecord, this.schedulerJobInstanceService, this.contextInstanceStateChangeEventBroadcaster, this.schedulerJobStateChangeEventBroadcaster, this.jobLockCacheInitialisationService, this.contextInstanceSchedulerService, this.timeService));
        }
    }
}

