/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context.register;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.context.register.ContextInstanceSchedulerService;
import org.ikasan.job.orchestration.context.util.CronUtils;
import org.ikasan.job.orchestration.context.util.QuartzTimeWindowChecker;
import org.ikasan.job.orchestration.context.util.TimeService;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.model.context.ContextTemplateImpl;
import org.ikasan.job.orchestration.model.instance.ContextInstanceImpl;
import org.ikasan.orchestration.service.context.ContextInstanceServiceBase;
import org.ikasan.spec.metadata.ModuleMetaDataService;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.ScheduledContextRecord;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRegistrationService;
import org.ikasan.spec.scheduled.context.service.ScheduledContextService;
import org.ikasan.spec.scheduled.event.service.ContextInstanceSavedEventBroadcaster;
import org.ikasan.spec.scheduled.event.service.ContextInstanceStateChangeEventBroadcaster;
import org.ikasan.spec.scheduled.event.service.SchedulerJobStateChangeEventBroadcaster;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.service.ContextInstancePublicationService;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.ikasan.spec.scheduled.instance.service.ScheduledContextInstanceService;
import org.ikasan.spec.scheduled.instance.service.SchedulerJobInstanceService;
import org.ikasan.spec.scheduled.job.service.InternalEventDrivenJobService;
import org.ikasan.spec.scheduled.job.service.JobInitiationService;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheInitialisationService;
import org.ikasan.spec.scheduled.joblock.service.JobLockCacheService;
import org.ikasan.spec.systemevent.SystemEventService;

public class ContextInstanceRegistrationServiceImpl
extends ContextInstanceServiceBase
implements ContextInstanceRegistrationService {
    private static final Log LOG = LogFactory.getLog(ContextInstanceRegistrationServiceImpl.class);
    private ContextInstanceSavedEventBroadcaster contextInstanceSavedEventBroadcaster;
    private SystemEventService systemEventService;
    private boolean isIkasanEnterpriseSchedulerInstance;

    public ContextInstanceRegistrationServiceImpl(String queueDirectory, ScheduledContextInstanceService scheduledContextInstanceService, JobInitiationService jobInitiationService, ModuleMetaDataService moduleMetadataService, InternalEventDrivenJobService internalEventDrivenJobService, ContextParametersInstanceService contextParametersInstanceService, ContextInstancePublicationService contextInstancePublicationService, JobLockCacheService jobLockCacheService, ScheduledContextService scheduledContextService, SchedulerJobInstanceService schedulerJobInstanceService, ContextInstanceStateChangeEventBroadcaster contextInstanceStateChangeEventBroadcaster, SchedulerJobStateChangeEventBroadcaster schedulerJobStateChangeEventBroadcaster, JobLockCacheInitialisationService jobLockCacheInitialisationService, ContextInstanceSchedulerService contextInstanceSchedulerService, TimeService timeService, ContextInstanceSavedEventBroadcaster contextInstanceSavedEventBroadcaster, SystemEventService systemEventService, boolean isIkasanEnterpriseSchedulerInstance) {
        super(queueDirectory, scheduledContextInstanceService, jobInitiationService, moduleMetadataService, internalEventDrivenJobService, contextParametersInstanceService, contextInstancePublicationService, jobLockCacheService, scheduledContextService, schedulerJobInstanceService, contextInstanceStateChangeEventBroadcaster, schedulerJobStateChangeEventBroadcaster, jobLockCacheInitialisationService, contextInstanceSchedulerService, timeService);
        this.contextInstanceSavedEventBroadcaster = contextInstanceSavedEventBroadcaster;
        if (this.contextInstanceSavedEventBroadcaster == null) {
            throw new IllegalArgumentException("contextInstanceSavedEventBroadcaster cannot be null!");
        }
        this.systemEventService = systemEventService;
        if (this.systemEventService == null) {
            throw new IllegalArgumentException("systemEventService cannot be null!");
        }
        this.isIkasanEnterpriseSchedulerInstance = isIkasanEnterpriseSchedulerInstance;
    }

    public void deRegisterByName(String contextName) {
        for (ContextMachine contextMachine : ContextMachineCache.instance().getAllByContextName(contextName)) {
            this.deRegisterById(contextMachine.getContext().getId());
        }
        this.contextInstanceSchedulerService.removeJob(contextName);
    }

    public void deregisterManually(String contextInstanceId) {
        this._deRegisterById(contextInstanceId, true);
    }

    public void deRegisterById(String contextInstanceId) {
        this._deRegisterById(contextInstanceId, false);
    }

    private void _deRegisterById(String contextInstanceId, boolean endManually) {
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.warn((Object)"This instance of the dashboard is not configured to run as a scheduler, therefore no job plan instance de-registration will occur!");
            return;
        }
        ContextMachine contextMachine = ContextMachineCache.instance().getByContextInstanceId(contextInstanceId);
        if (contextMachine == null) {
            LOG.info((Object)String.format("Could not find context machine for context Instance ID [%s], so therefore nothing to de-register.", contextInstanceId));
            return;
        }
        ContextInstance instance = contextMachine.getContext();
        if (instance == null) {
            String messages = String.format("Could not find instance in ContextMachine for context Instance ID [%s]", contextInstanceId);
            LOG.error((Object)messages);
            throw new RuntimeException(messages);
        }
        if (instance.isRunContextUntilManuallyEnded() && !endManually) {
            String messages = String.format("Context Instance ID [%s] with name[%s] has been marked to be manually ended, so therefore nothing to de-register.", contextInstanceId, instance.getName());
            LOG.info((Object)messages);
            return;
        }
        LOG.info((Object)String.format("De registering context Instance ID [%s], plan name [%s]", contextInstanceId, contextMachine.getContext().getName()));
        this.removeAgentInstances(instance);
        instance.setEndTime(System.currentTimeMillis());
        this.saveContextInstance(instance, InstanceStatus.ENDED);
        this.jobLockCacheInitialisationService.removeJobLocksFromCache((Context)instance);
        ContextMachineCache.instance().remove(contextMachine);
        this.contextInstanceSavedEventBroadcaster.broadcast(instance);
        try {
            contextMachine.teardown();
        }
        catch (Exception e) {
            LOG.error((Object)String.format("An error has occurred executing de registering job[%s]", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void reSchedule(String contextName) {
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.warn((Object)"This instance of the dashboard is not configured to run as a scheduler, therefore no job plan instance registration will occur");
            return;
        }
        ScheduledContextRecord scheduledContextRecord = this.scheduledContextService.findById(contextName);
        if (scheduledContextRecord == null) {
            String message = String.format("Could not find scheduledContextRecord for context name [%s]", contextName);
            LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        if (scheduledContextRecord.isDisabled()) {
            LOG.info((Object)String.format("Context name [%s] is disabled and will not be registered!", contextName));
            return;
        }
        try {
            List<ContextInstance> contextInstances = this.findPrepared(contextName);
            contextInstances.forEach(contextInstance -> this.deRegisterById(contextInstance.getId()));
            this.contextInstanceSchedulerService.removeJob(contextName);
            this.contextInstanceSchedulerService.registerStartJobAndTrigger(scheduledContextRecord.getContextName(), scheduledContextRecord.getContext().getTimeWindowStart(), scheduledContextRecord.getContext().getTimezone());
            byte[] scheduledContextRecordContext = this.objectMapper.writeValueAsBytes((Object)scheduledContextRecord.getContext());
            ContextInstanceImpl preparedFutureContextInstance = (ContextInstanceImpl)this.objectMapper.readValue(scheduledContextRecordContext, ContextInstanceImpl.class);
            preparedFutureContextInstance.setStartTime(CronUtils.getEpochMilliOfNextFireTimeAccountingForBlackoutWindow((String)scheduledContextRecord.getContext().getTimeWindowStart(), (List)scheduledContextRecord.getContext().getBlackoutWindowCronExpressions(), (Map)scheduledContextRecord.getContext().getBlackoutWindowDateTimeRanges(), (String)scheduledContextRecord.getContext().getTimezone()));
            this.saveContextInstance((ContextInstance)preparedFutureContextInstance, InstanceStatus.PREPARED);
            super.prepareContextInstance(scheduledContextRecord.getContext(), (ContextInstance)preparedFutureContextInstance, true);
        }
        catch (Exception e) {
            LOG.error((Object)String.format("An error has occurred executing registering job [%s]", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void prepareFutureContextInstance(String contextName) {
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.warn((Object)"This instance of the dashboard is not configured to run as a scheduler, therefore no job plan instance registration will occur");
            return;
        }
        super.prepareFutureContextInstance(contextName);
    }

    public void register(String contextName) {
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.warn((Object)"This instance of the dashboard is not configured to run as a scheduler, therefore no job plan instance registration will occur");
            return;
        }
        ScheduledContextRecord scheduledContextRecord = this.scheduledContextService.findById(contextName);
        if (scheduledContextRecord == null) {
            String message = String.format("Could not find scheduledContextRecord for context name [%s]", contextName);
            LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        if (scheduledContextRecord.isDisabled()) {
            LOG.info((Object)String.format("Context name [%s] is disabled and will not be registered!", contextName));
            return;
        }
        if (!scheduledContextRecord.getContext().isAbleToRunConcurrently() && (ContextMachineCache.instance().getFirstByContextName(scheduledContextRecord.getContextName()) != null && !ContextMachineCache.instance().getFirstByContextName(scheduledContextRecord.getContextName()).getContext().getStatus().equals((Object)InstanceStatus.PREPARED) || ContextMachineCache.instance().getAllByContextName(scheduledContextRecord.getContextName()).size() > 1)) {
            LOG.info((Object)String.format("Context name [%s] cannot run concurrently, however there is already an active instance! A new instance will not be created automatically.", contextName));
            this.systemEventService.logSystemEvent("Context Instance Not Created", String.format("Context name [%s] cannot run concurrently, however there is already an active instance! A new instance will not be created automatically.", contextName), "ContextMachine");
            return;
        }
        LOG.info((Object)String.format("Registering context [%s]", contextName));
        try {
            byte[] scheduledContextRecordContext = this.objectMapper.writeValueAsBytes((Object)scheduledContextRecord.getContext());
            ContextTemplate context = (ContextTemplate)this.objectMapper.readValue(scheduledContextRecordContext, ContextTemplateImpl.class);
            List<ContextInstance> contextInstances = this.findPrepared(context.getName());
            boolean initialiseJobs = false;
            if (contextInstances.isEmpty()) {
                contextInstances.add((ContextInstance)this.objectMapper.readValue(scheduledContextRecordContext, ContextInstanceImpl.class));
                initialiseJobs = true;
            }
            this.prepareFutureContextInstance(contextName);
            for (ContextInstance contextInstance : contextInstances) {
                Date now = this.timeService.getDateNow();
                if (!QuartzTimeWindowChecker.fallsWithinCronBlackoutWindows((List)contextInstance.getBlackoutWindowCronExpressions(), (String)contextInstance.getTimezone(), (Date)now) && !QuartzTimeWindowChecker.fallsWithinDateTimeBlackoutRanges((Map)contextInstance.getBlackoutWindowDateTimeRanges(), (Date)now)) {
                    this.initialiseContextMachine(context, contextInstance, initialiseJobs, true, null);
                    this.contextInstanceSchedulerService.registerEndJobAndTrigger(contextInstance.getName(), CronUtils.buildCronFromOriginal((long)contextInstance.getProjectedEndTime(), (String)contextInstance.getTimezone()), contextInstance.getTimezone(), contextInstance.getId());
                    LOG.info((Object)String.format("Registering context instance [%s] for context [%s]", contextInstance.getId(), contextName));
                    this.contextInstanceSavedEventBroadcaster.broadcast(contextInstance);
                    continue;
                }
                LOG.info((Object)String.format("Context name [%s] falls withing a blackout time window and will not be registered!", contextName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("An error has occurred executing registering job [%s]", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String register(String contextName, List<ContextParameterInstance> contextParameterInstances) {
        if (!this.isIkasanEnterpriseSchedulerInstance) {
            LOG.warn((Object)"This instance of the dashboard is not configured to run as a scheduler, therefore no job plan instance registration will occur");
            return null;
        }
        ScheduledContextRecord scheduledContextRecord = this.scheduledContextService.findById(contextName);
        if (scheduledContextRecord == null) {
            String message = String.format("Could not find scheduledContextRecord for context name [%s]", contextName);
            LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        if (scheduledContextRecord.isDisabled()) {
            LOG.info((Object)String.format("Context name [%s] is disabled and will not be registered!", contextName));
            return null;
        }
        if (!scheduledContextRecord.getContext().isAbleToRunConcurrently() && (ContextMachineCache.instance().getFirstByContextName(scheduledContextRecord.getContextName()) != null && !ContextMachineCache.instance().getFirstByContextName(scheduledContextRecord.getContextName()).getContext().getStatus().equals((Object)InstanceStatus.PREPARED) || ContextMachineCache.instance().getAllByContextName(scheduledContextRecord.getContextName()).size() > 1)) {
            LOG.info((Object)String.format("Context name [%s] cannot run concurrently, however there is already an active instance! A new instance will not be created automatically.", contextName));
            this.systemEventService.logSystemEvent("Context Instance Not Created", String.format("Context name [%s] cannot run concurrently, however there is already an active instance! A new instance will not be created automatically.", contextName), "ContextMachine");
            return null;
        }
        LOG.info((Object)String.format("Registering context [%s]", contextName));
        try {
            byte[] scheduledContextRecordContext = this.objectMapper.writeValueAsBytes((Object)scheduledContextRecord.getContext());
            ContextTemplate context = (ContextTemplate)this.objectMapper.readValue(scheduledContextRecordContext, ContextTemplateImpl.class);
            ContextInstanceImpl contextInstance = (ContextInstanceImpl)this.objectMapper.readValue(scheduledContextRecordContext, ContextInstanceImpl.class);
            Date now = this.timeService.getDateNow();
            if (!QuartzTimeWindowChecker.fallsWithinCronBlackoutWindows((List)contextInstance.getBlackoutWindowCronExpressions(), (String)contextInstance.getTimezone(), (Date)now) && !QuartzTimeWindowChecker.fallsWithinDateTimeBlackoutRanges((Map)contextInstance.getBlackoutWindowDateTimeRanges(), (Date)now)) {
                this.initialiseContextMachine(context, (ContextInstance)contextInstance, true, true, contextParameterInstances);
                String cronProjectedEndTime = this.workOutCronProjectedEndTimeWhenManuallyCreated(contextName, now, contextInstance);
                this.contextInstanceSchedulerService.registerEndJobAndTrigger(contextInstance.getName(), cronProjectedEndTime, contextInstance.getTimezone(), contextInstance.getId());
                LOG.info((Object)String.format("Registering context instance [%s] for context [%s]", contextInstance.getId(), contextName));
                ContextMachineCache.instance().getByContextInstanceId(contextInstance.getId()).saveContext();
                this.contextInstanceSavedEventBroadcaster.broadcast((ContextInstance)contextInstance);
                return contextInstance.getId();
            }
            LOG.info((Object)String.format("Context name [%s] falls withing a blackout time window and will not be registered!", contextName));
        }
        catch (Exception e) {
            LOG.error((Object)String.format("An error has occurred executing registering job [%s]", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private String workOutCronProjectedEndTimeWhenManuallyCreated(String contextName, Date now, ContextInstanceImpl contextInstance) {
        String cronProjectedEndTime = CronUtils.buildCronFromOriginal((long)contextInstance.getProjectedEndTime(), (String)contextInstance.getTimezone());
        if (now.getTime() > contextInstance.getProjectedEndTime()) {
            long nextStartTimeMinusOneMinute = CronUtils.getEpochMilliOfNextFireTimeAccountingForBlackoutWindow((String)contextInstance.getTimeWindowStart(), (List)contextInstance.getBlackoutWindowCronExpressions(), (Map)contextInstance.getBlackoutWindowDateTimeRanges(), (String)contextInstance.getTimezone()) - 60000L;
            if (now.getTime() > nextStartTimeMinusOneMinute && !contextInstance.isAbleToRunConcurrently()) {
                throw new RuntimeException("[" + contextName + "] This job instance will not be started due to the projected end time being too close to the next start time.");
            }
            long newProposedTime = now.getTime() + contextInstance.getContextTtlMilliseconds();
            if (contextInstance.isAbleToRunConcurrently()) {
                cronProjectedEndTime = CronUtils.buildCronFromOriginal((long)newProposedTime, (String)contextInstance.getTimezone());
                contextInstance.setProjectedEndTime(newProposedTime);
            } else if (newProposedTime < nextStartTimeMinusOneMinute) {
                cronProjectedEndTime = CronUtils.buildCronFromOriginal((long)newProposedTime, (String)contextInstance.getTimezone());
                contextInstance.setProjectedEndTime(newProposedTime);
            } else {
                cronProjectedEndTime = CronUtils.buildCronFromOriginal((long)nextStartTimeMinusOneMinute, (String)contextInstance.getTimezone());
                contextInstance.setProjectedEndTime(nextStartTimeMinusOneMinute);
            }
        }
        return cronProjectedEndTime;
    }
}

