/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context.reset;

import java.util.List;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.orchestration.service.context.reset.ContextResetException;
import org.ikasan.spec.scheduled.reset.ContextResetService;

public class ContextResetServiceImpl
implements ContextResetService {
    public void resetContext(String contextName, boolean holdCommandExecutionJob) {
        List contextMachines = ContextMachineCache.instance().getAllByContextName(contextName);
        if (contextMachines == null || contextMachines.isEmpty()) {
            throw new ContextResetException(String.format("Could not find context for context name [%s] to reset", contextName));
        }
        for (ContextMachine contextMachine : contextMachines) {
            try {
                contextMachine.resetContextInstance(holdCommandExecutionJob, false, null);
            }
            catch (Exception e) {
                throw new ContextResetException("Failed to reset context " + e.getMessage());
            }
        }
    }

    public void resetContextInstance(String contextInstanceId, boolean holdCommandExecutionJob) {
        ContextMachine contextMachine = ContextMachineCache.instance().getByContextInstanceId(contextInstanceId);
        if (contextMachine == null) {
            throw new ContextResetException(String.format("Could not find context for context instance ID %s to reset", contextInstanceId));
        }
        try {
            contextMachine.resetContextInstance(holdCommandExecutionJob, false, null);
        }
        catch (Exception e) {
            throw new ContextResetException("Failed to reset context " + e.getMessage());
        }
    }
}

