/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context.status;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ikasan.job.orchestration.context.cache.ContextMachineCache;
import org.ikasan.job.orchestration.core.machine.ContextMachine;
import org.ikasan.job.orchestration.model.status.ContextJobInstanceStatusWrapperImpl;
import org.ikasan.job.orchestration.model.status.ContextMachineStatusImpl;
import org.ikasan.job.orchestration.model.status.ContextMachineStatusWrapperImpl;
import org.ikasan.job.orchestration.service.ContextService;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.orchestration.service.context.status.ContextStatusServiceException;
import org.ikasan.spec.scheduled.context.service.ContextStatusService;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.InstanceStatus;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.status.model.ContextJobInstanceStatus;
import org.ikasan.spec.scheduled.status.model.ContextJobInstanceStatusWrapper;
import org.ikasan.spec.scheduled.status.model.ContextMachineStatusWrapper;

public class ContextStatusServiceImpl
implements ContextStatusService<ContextMachine> {
    public String getJsonContextMachineStatus(boolean includePrepared) throws JsonProcessingException {
        ConcurrentHashMap mapAllContextMachine = ContextMachineCache.instance().getContextInstanceByContextInstanceIdCache();
        ContextMachineStatusWrapperImpl contextMachineStatusWrapper = new ContextMachineStatusWrapperImpl();
        ArrayList<ContextMachineStatusImpl> contextMachineStatusList = new ArrayList<ContextMachineStatusImpl>();
        for (Map.Entry contextMachineEntry : mapAllContextMachine.entrySet()) {
            if (!includePrepared && ((ContextMachine)contextMachineEntry.getValue()).getContext().getStatus().equals((Object)InstanceStatus.PREPARED)) continue;
            ContextMachineStatusImpl status = new ContextMachineStatusImpl();
            status.setContextName(((ContextMachine)contextMachineEntry.getValue()).getContext().getName());
            status.setContextInstanceId(((ContextMachine)contextMachineEntry.getValue()).getContext().getId());
            status.setInstanceStatus(((ContextMachine)contextMachineEntry.getValue()).getContext().getStatus());
            contextMachineStatusList.add(status);
        }
        contextMachineStatusWrapper.setContextMachineStatusList(contextMachineStatusList);
        ContextService contextService = new ContextService();
        String json = contextService.getContextMachineStatus((ContextMachineStatusWrapper)contextMachineStatusWrapper);
        return json == null ? "" : json;
    }

    public String getJsonContextJobStatus(InstanceStatus instanceStatus, Map<String, ContextMachine> mapAllContextMachine) throws JsonProcessingException {
        if (mapAllContextMachine == null || mapAllContextMachine.isEmpty()) {
            return "";
        }
        ContextJobInstanceStatusWrapperImpl contextJobInstanceStatusWrapper = new ContextJobInstanceStatusWrapperImpl();
        ArrayList<ContextJobInstanceStatus> contextJobInstanceStatusList = new ArrayList<ContextJobInstanceStatus>();
        for (Map.Entry<String, ContextMachine> contextMachineEntry : mapAllContextMachine.entrySet()) {
            if (contextMachineEntry.getValue().getContext().getStatus().equals((Object)InstanceStatus.PREPARED)) continue;
            ContextJobInstanceStatus contextJobInstanceStatus = ContextHelper.getContextJobInstanceStatus((ContextInstance)contextMachineEntry.getValue().getContext(), (Map)contextMachineEntry.getValue().getInternalEventDrivenJobInstancesMap());
            if (instanceStatus != null) {
                contextJobInstanceStatus.getJobDetails().removeIf(list -> !list.getInstanceStatus().equals((Object)instanceStatus));
            }
            contextJobInstanceStatusList.add(contextJobInstanceStatus);
        }
        contextJobInstanceStatusWrapper.setJobPlans(contextJobInstanceStatusList);
        ContextService contextService = new ContextService();
        String json = contextService.getContextJobInstanceStatus((ContextJobInstanceStatusWrapper)contextJobInstanceStatusWrapper);
        return json == null ? "" : json;
    }

    public String getContextStatus(String instanceName, String contextName) {
        HashMap<String, String> contextInstanceStatusMap = new HashMap<String, String>();
        List contextMachineList = ContextMachineCache.instance().getAllRunningByContextName(instanceName);
        this.validateContextMachine(contextMachineList, instanceName);
        for (ContextMachine contextMachine : contextMachineList) {
            this.validateContextMachine(contextMachine, instanceName);
            InstanceStatus instanceStatus = contextMachine.getContextStatus(contextName);
            this.validateInstance(instanceStatus, instanceName, contextName, null);
            contextInstanceStatusMap.put(contextMachine.getContext().getId(), instanceStatus.name());
        }
        return ((Object)contextInstanceStatusMap).toString();
    }

    public String getContextStatusForJob(String instanceName, String contextName, String jobIdentifier) {
        HashMap<String, String> contextInstanceStatusMap = new HashMap<String, String>();
        List contextMachineList = ContextMachineCache.instance().getAllRunningByContextName(instanceName);
        this.validateContextMachine(contextMachineList, instanceName);
        for (ContextMachine contextMachine : contextMachineList) {
            this.validateContextMachine(contextMachine, instanceName);
            InstanceStatus instanceStatus = contextMachine.getJobStatus(contextName, jobIdentifier);
            this.validateInstance(instanceStatus, instanceName, contextName, jobIdentifier);
            contextInstanceStatusMap.put(contextMachine.getContext().getId(), instanceStatus.name());
        }
        return ((Object)contextInstanceStatusMap).toString();
    }

    public String getJsonContextStatus(String instanceName, String contextName) throws JsonProcessingException {
        HashMap<String, ContextInstance> contextInstanceStatusMap = new HashMap<String, ContextInstance>();
        List contextMachineList = ContextMachineCache.instance().getAllRunningByContextName(instanceName);
        this.validateContextMachine(contextMachineList, instanceName);
        for (ContextMachine contextMachine : contextMachineList) {
            this.validateContextMachine(contextMachine, instanceName);
            ContextInstance contextInstance = contextMachine.getContext(instanceName);
            this.validateContextInstance(contextInstance, instanceName);
            ContextInstance contextInstanceForStatus = ContextHelper.getChildContextInstance((String)contextName, (ContextInstance)contextInstance);
            this.validateContextInstance(contextInstanceForStatus, contextName);
            contextInstanceStatusMap.put(contextMachine.getContext().getId(), contextInstance);
        }
        ContextService contextService = new ContextService();
        String json = contextService.getContextInstanceString(contextInstanceStatusMap);
        return json == null ? "" : json;
    }

    public String getJsonContextStatusForJob(String instanceName, String contextName, String jobName) throws JsonProcessingException {
        HashMap<String, SchedulerJobInstance> schedulerJobInstanceMap = new HashMap<String, SchedulerJobInstance>();
        List contextMachineList = ContextMachineCache.instance().getAllRunningByContextName(instanceName);
        this.validateContextMachine(contextMachineList, instanceName);
        for (ContextMachine contextMachine : contextMachineList) {
            this.validateContextMachine(contextMachine, instanceName);
            ContextInstance contextInstance = contextMachine.getContext(instanceName);
            this.validateContextInstance(contextInstance, instanceName);
            SchedulerJobInstance schedulerJobInstance = ContextHelper.getSchedulerJobInstance((String)jobName, (String)contextName, (ContextInstance)contextInstance);
            this.validateSchedulerJobInstance(schedulerJobInstance, instanceName, contextName, jobName);
            schedulerJobInstanceMap.put(contextMachine.getContext().getId(), schedulerJobInstance);
        }
        ContextService contextService = new ContextService();
        String json = contextService.getSchedulerJobInstance(schedulerJobInstanceMap);
        return json == null ? "" : json;
    }

    private void validateInstance(InstanceStatus instanceStatus, String instanceName, String contextName, String jobIdentifier) {
        if (instanceStatus == null) {
            String errorMessage = jobIdentifier == null ? String.format("Could not find context %s in context machine %s", contextName, instanceName) : String.format("Could not find job identifier %s for context %s in context machine %s", jobIdentifier, contextName, instanceName);
            throw new ContextStatusServiceException(errorMessage);
        }
    }

    private void validateContextMachine(List<ContextMachine> contextMachineList, String instanceName) {
        if (contextMachineList == null || contextMachineList.isEmpty()) {
            throw new ContextStatusServiceException(String.format("Could not find context machine for instance %s", instanceName));
        }
    }

    private void validateContextMachine(ContextMachine contextMachine, String instanceName) {
        if (contextMachine == null) {
            throw new ContextStatusServiceException(String.format("Could not find context machine for instance %s", instanceName));
        }
    }

    private void validateContextInstance(ContextInstance contextInstance, String contextName) {
        if (contextInstance == null) {
            throw new ContextStatusServiceException(String.format("Could not find context instance for context %s", contextName));
        }
    }

    private void validateSchedulerJobInstance(SchedulerJobInstance schedulerJobInstance, String instanceName, String contextName, String jobIdentifier) {
        if (schedulerJobInstance == null) {
            String errorMessage = jobIdentifier == null ? String.format("Could not find context %s in context machine %s", contextName, instanceName) : String.format("Could not find job identifier %s for context %s in context machine %s", jobIdentifier, contextName, instanceName);
            throw new ContextStatusServiceException(errorMessage);
        }
    }
}

