/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.orchestration.service.context.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.ikasan.job.orchestration.model.profile.ContextProfileSearchFilterImpl;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.job.model.FileEventDrivenJob;
import org.ikasan.spec.scheduled.job.model.GlobalEventJob;
import org.ikasan.spec.scheduled.job.model.InternalEventDrivenJob;
import org.ikasan.spec.scheduled.job.model.QuartzScheduleDrivenJob;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;
import org.ikasan.spec.scheduled.job.service.SchedulerJobService;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationContextRecord;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetailsRecord;
import org.ikasan.spec.scheduled.notification.service.EmailNotificationContextService;
import org.ikasan.spec.scheduled.notification.service.EmailNotificationDetailsService;
import org.ikasan.spec.scheduled.profile.model.ContextProfileRecord;
import org.ikasan.spec.scheduled.profile.model.ContextProfileSearchFilter;
import org.ikasan.spec.scheduled.profile.service.ContextProfileService;
import org.ikasan.spec.search.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextExportZipUtils {
    public static final String[] UNSAFE_FILENAME_CHAR = new String[]{"\\", ":", "/", "*", "?", "\"", "<", ">", "|"};
    public static final String[] REPLACE_UNSAFE_FILENAME_CHAR = new String[]{"_", "_", "_", "_", "_", "_", "_", "_", "_"};
    private static final Logger LOG = LoggerFactory.getLogger(ContextExportZipUtils.class);

    public static String getExportZipFileName(String contextName) {
        return contextName + ".zip";
    }

    public static ByteArrayOutputStream createZipFile(ContextTemplate context, String unmodifiedContextName, String downloadName, String workingDirectory, SchedulerJobService schedulerJobService, EmailNotificationDetailsService emailNotificationDetailsService, EmailNotificationContextService emailNotificationContextService, ContextProfileService contextProfileService, int searchLimit, boolean addReplacementTokens) {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.newInstance();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            if (addReplacementTokens) {
                ContextHelper.addContextTemplateReplacementTokens((ContextTemplate)context);
            }
            String template = objectMapper.writeValueAsString((Object)context);
            String contextFileName = StringUtils.replaceEach((String)downloadName, (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR);
            ContextExportZipUtils.deleteWorkingDirectory(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName);
            Path contextDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "context", new String[0]);
            Path jobsDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs", new String[0]);
            Path jobsFileDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "file", new String[0]);
            Path jobsInternalDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "internal", new String[0]);
            Path jobsQuartzDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "quartz", new String[0]);
            Path jobsGlobalDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "global", new String[0]);
            Path notificationDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "notification", new String[0]);
            Path notificationDetailDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "notification_details", new String[0]);
            Path profilesDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "profiles", new String[0]);
            Files.createDirectories(contextDir, new FileAttribute[0]);
            Files.createDirectories(jobsDir, new FileAttribute[0]);
            Files.createDirectories(jobsFileDir, new FileAttribute[0]);
            Files.createDirectories(jobsInternalDir, new FileAttribute[0]);
            Files.createDirectories(jobsQuartzDir, new FileAttribute[0]);
            Files.createDirectories(jobsGlobalDir, new FileAttribute[0]);
            Files.createDirectories(notificationDir, new FileAttribute[0]);
            Files.createDirectories(notificationDetailDir, new FileAttribute[0]);
            Files.createDirectories(profilesDir, new FileAttribute[0]);
            Path contextFilePath = Paths.get(contextDir + File.separator + contextFileName + ".json", new String[0]);
            Files.createFile(contextFilePath, new FileAttribute[0]);
            Files.write(contextFilePath, template.getBytes(), new OpenOption[0]);
            int offset = 0;
            SearchResults results = schedulerJobService.findByContext(unmodifiedContextName, searchLimit, offset);
            ContextExportZipUtils.addJobFilesToZip(objectMapper, jobsFileDir, jobsInternalDir, jobsQuartzDir, jobsGlobalDir, results.getResultList().stream().map(schedulerJobRecord -> schedulerJobRecord.getJob()).collect(Collectors.toList()), addReplacementTokens);
            int retrievedNumber = results.getResultList().size();
            long totalNumberOfResults = results.getTotalNumberOfResults();
            while ((long)offset < totalNumberOfResults) {
                results = schedulerJobService.findByContext(unmodifiedContextName, searchLimit, offset += retrievedNumber);
                ContextExportZipUtils.addJobFilesToZip(objectMapper, jobsFileDir, jobsInternalDir, jobsQuartzDir, jobsGlobalDir, results.getResultList().stream().map(schedulerJobRecord -> schedulerJobRecord.getJob()).collect(Collectors.toList()), addReplacementTokens);
            }
            offset = 0;
            SearchResults notificationResults = emailNotificationContextService.findByContextName(unmodifiedContextName, searchLimit, offset);
            ContextExportZipUtils.addNotificationFilesToZip(objectMapper, notificationDir, (SearchResults<EmailNotificationContextRecord>)notificationResults);
            retrievedNumber = notificationResults.getResultList().size();
            totalNumberOfResults = notificationResults.getTotalNumberOfResults();
            while ((long)offset < totalNumberOfResults) {
                notificationResults = emailNotificationContextService.findByContextName(unmodifiedContextName, searchLimit, offset += retrievedNumber);
                ContextExportZipUtils.addNotificationFilesToZip(objectMapper, notificationDir, (SearchResults<EmailNotificationContextRecord>)notificationResults);
            }
            offset = 0;
            SearchResults notificationDetailResults = emailNotificationDetailsService.findByContextName(unmodifiedContextName, searchLimit, offset);
            ContextExportZipUtils.addNotificationDetailFilesToZip(objectMapper, notificationDetailDir, (SearchResults<EmailNotificationDetailsRecord>)notificationDetailResults);
            retrievedNumber = notificationDetailResults.getResultList().size();
            totalNumberOfResults = notificationDetailResults.getTotalNumberOfResults();
            while ((long)offset < totalNumberOfResults) {
                notificationDetailResults = emailNotificationDetailsService.findByContextName(unmodifiedContextName, searchLimit, offset += retrievedNumber);
                ContextExportZipUtils.addNotificationDetailFilesToZip(objectMapper, notificationDetailDir, (SearchResults<EmailNotificationDetailsRecord>)notificationDetailResults);
            }
            offset = 0;
            ContextProfileSearchFilterImpl profileFilter = new ContextProfileSearchFilterImpl();
            profileFilter.setContextName(unmodifiedContextName);
            SearchResults profileResults = contextProfileService.findByFilter((ContextProfileSearchFilter)profileFilter, searchLimit, offset, null, null);
            ContextExportZipUtils.addProfilesFilesToZip(objectMapper, profilesDir, (SearchResults<ContextProfileRecord>)profileResults);
            retrievedNumber = profileResults.getResultList().size();
            totalNumberOfResults = profileResults.getTotalNumberOfResults();
            while ((long)offset < totalNumberOfResults) {
                profileResults = contextProfileService.findByFilter((ContextProfileSearchFilter)profileFilter, searchLimit, offset += retrievedNumber, null, null);
                ContextExportZipUtils.addProfilesFilesToZip(objectMapper, profilesDir, (SearchResults<ContextProfileRecord>)profileResults);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(baos);
            File fileToZip = new File(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName);
            ContextExportZipUtils.zipDirectory(fileToZip, fileToZip.getName(), zipOut);
            zipOut.close();
            baos.close();
            ContextExportZipUtils.deleteWorkingDirectory(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName);
            return baos;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn(String.format("Got exception creating zip file. Error [%s]", e.getMessage()));
            try {
                ContextExportZipUtils.deleteWorkingDirectory(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + StringUtils.replaceEach((String)context.getName(), (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public static ByteArrayOutputStream createZipFile(ContextTemplate context, String workingDirectory, List<SchedulerJob> schedulerJobList, boolean addReplacementTokens) {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.newInstance();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            String contextName = context.getName();
            if (addReplacementTokens) {
                ContextHelper.addContextTemplateReplacementTokens((ContextTemplate)context);
            }
            String template = objectMapper.writeValueAsString((Object)context);
            String contextFileName = StringUtils.replaceEach((String)contextName, (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR);
            ContextExportZipUtils.deleteWorkingDirectory(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName);
            Path contextDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "context", new String[0]);
            Path jobsDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs", new String[0]);
            Path jobsFileDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "file", new String[0]);
            Path jobsInternalDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "internal", new String[0]);
            Path jobsQuartzDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "quartz", new String[0]);
            Path jobsGlobalDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "jobs" + File.separator + "global", new String[0]);
            Path notificationDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "notification", new String[0]);
            Path notificationDetailDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "notification_details", new String[0]);
            Path profilesDir = Paths.get(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName + File.separator + "profiles", new String[0]);
            Files.createDirectories(contextDir, new FileAttribute[0]);
            Files.createDirectories(jobsDir, new FileAttribute[0]);
            Files.createDirectories(jobsFileDir, new FileAttribute[0]);
            Files.createDirectories(jobsInternalDir, new FileAttribute[0]);
            Files.createDirectories(jobsQuartzDir, new FileAttribute[0]);
            Files.createDirectories(jobsGlobalDir, new FileAttribute[0]);
            Files.createDirectories(notificationDir, new FileAttribute[0]);
            Files.createDirectories(notificationDetailDir, new FileAttribute[0]);
            Files.createDirectories(profilesDir, new FileAttribute[0]);
            Path contextFilePath = Paths.get(contextDir + File.separator + contextFileName + ".json", new String[0]);
            Files.createFile(contextFilePath, new FileAttribute[0]);
            Files.write(contextFilePath, template.getBytes(), new OpenOption[0]);
            ContextExportZipUtils.addJobFilesToZip(objectMapper, jobsFileDir, jobsInternalDir, jobsQuartzDir, jobsGlobalDir, schedulerJobList, addReplacementTokens);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(baos);
            File fileToZip = new File(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName);
            ContextExportZipUtils.zipDirectory(fileToZip, fileToZip.getName(), zipOut);
            zipOut.close();
            baos.close();
            ContextExportZipUtils.deleteWorkingDirectory(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + contextFileName);
            return baos;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn(String.format("Got exception creating zip file. Error [%s]", e.getMessage()));
            try {
                ContextExportZipUtils.deleteWorkingDirectory(ContextExportZipUtils.getWorkingDirectory(workingDirectory) + StringUtils.replaceEach((String)context.getName(), (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static void zipDirectory(File fileToZip, String fileName, ZipOutputStream zipOutputStream) throws IOException {
        int length;
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith("/")) {
                zipOutputStream.putNextEntry(new ZipEntry(fileName));
                zipOutputStream.closeEntry();
            } else {
                zipOutputStream.putNextEntry(new ZipEntry(fileName + "/"));
                zipOutputStream.closeEntry();
            }
            File[] children = fileToZip.listFiles();
            if (children != null) {
                for (File childFile : children) {
                    ContextExportZipUtils.zipDirectory(childFile, fileName + "/" + childFile.getName(), zipOutputStream);
                }
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOutputStream.write(bytes, 0, length);
        }
        fis.close();
    }

    private static void addJobFilesToZip(ObjectMapper objectMapper, Path p3, Path p4, Path p5, Path p6, List<SchedulerJob> results, boolean addReplacementTokens) throws IOException {
        for (SchedulerJob schedulerJob : results) {
            if (addReplacementTokens) {
                ContextHelper.addSchedulerJobReplacementTokens((SchedulerJob)schedulerJob);
            }
            String jobAsString = objectMapper.writeValueAsString((Object)schedulerJob);
            Path jobPath = null;
            String jobName = StringUtils.replaceEach((String)schedulerJob.getJobName(), (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR);
            if (schedulerJob instanceof FileEventDrivenJob) {
                jobPath = Paths.get(p3 + File.separator + jobName + ".json", new String[0]);
            } else if (schedulerJob instanceof InternalEventDrivenJob) {
                jobPath = Paths.get(p4 + File.separator + jobName + ".json", new String[0]);
            } else if (schedulerJob instanceof QuartzScheduleDrivenJob) {
                jobPath = Paths.get(p5 + File.separator + jobName + ".json", new String[0]);
            } else if (schedulerJob instanceof GlobalEventJob) {
                jobPath = Paths.get(p6 + File.separator + jobName + ".json", new String[0]);
            } else {
                LOG.warn("Unknown job type: " + schedulerJob.getClass().getName());
            }
            if (jobPath == null) continue;
            Files.createFile(jobPath, new FileAttribute[0]);
            Files.write(jobPath, jobAsString.getBytes(), new OpenOption[0]);
        }
    }

    private static void addNotificationFilesToZip(ObjectMapper objectMapper, Path notificationPath, SearchResults<EmailNotificationContextRecord> results) throws IOException {
        for (EmailNotificationContextRecord record : results.getResultList()) {
            String jsonString = objectMapper.writeValueAsString((Object)record.getEmailNotificationContext());
            String fileName = StringUtils.replaceEach((String)record.getId(), (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR);
            Path path = Paths.get(notificationPath + File.separator + fileName + "-notification.json", new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
    }

    private static void addNotificationDetailFilesToZip(ObjectMapper objectMapper, Path notificationDetailPath, SearchResults<EmailNotificationDetailsRecord> results) throws IOException {
        for (EmailNotificationDetailsRecord record : results.getResultList()) {
            String jsonString = objectMapper.writeValueAsString((Object)record.getEmailNotificationDetails());
            String fileName = StringUtils.replaceEach((String)record.getId(), (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR);
            Path path = Paths.get(notificationDetailPath + File.separator + fileName + ".json", new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
    }

    private static void addProfilesFilesToZip(ObjectMapper objectMapper, Path profilesDir, SearchResults<ContextProfileRecord> results) throws IOException {
        for (ContextProfileRecord record : results.getResultList()) {
            String jsonString = objectMapper.writeValueAsString((Object)record);
            String fileName = StringUtils.replaceEach((String)(record.getContextName() + "-" + record.getProfileName()), (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR);
            Path path = Paths.get(profilesDir + File.separator + fileName + ".json", new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
    }

    private static void deleteWorkingDirectory(String name) throws IOException {
        if (Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            FileUtils.deleteDirectory((File)new File(name));
        }
    }

    private static String getWorkingDirectory(String workingDirectory) {
        if (workingDirectory.equals(".")) {
            return "";
        }
        return workingDirectory;
    }
}

