package org.ikasan.job.orchestration.context.util;

import java.util.*;

import org.ikasan.job.orchestration.configuration.JobContextParamsSetupConfiguration;
import org.ikasan.job.orchestration.model.instance.ContextParameterInstanceImpl;
import org.ikasan.spec.scheduled.instance.model.ContextParameterInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SchedulerContextParametersPropertiesProvider extends Properties {
    private final static Logger LOG = LoggerFactory.getLogger(SchedulerContextParametersPropertiesProvider.class);

//    private final boolean replaceContextParameters;
    private Map<String, String> spelExpressionMap;

    // Reference to the bean object, reference by this so we can get updates after spring actuator refresh
    private JobContextParamsSetupConfiguration jobContextParamsSetupConfiguration;

    public SchedulerContextParametersPropertiesProvider(JobContextParamsSetupConfiguration jobContextParamsSetupConfiguration,
                                                        Map<String, String> spelExpressionMap) {
        this.jobContextParamsSetupConfiguration = jobContextParamsSetupConfiguration;
        if(this.jobContextParamsSetupConfiguration == null || this.jobContextParamsSetupConfiguration.getParamsToReplace() == null) {
            throw new IllegalArgumentException("jobContextParamsSetupConfiguration cannot be null!");
        }
        this.spelExpressionMap = spelExpressionMap == null ? Collections.emptyMap() : spelExpressionMap;

        String message = String.format("Creating SchedulerContextParametersPropertiesProvider configuration with use, " +
            "parametersToReplaceContext %s, spelExpressionMap %s",
            this.jobContextParamsSetupConfiguration.getParamsToReplace().keySet(), this.spelExpressionMap);
        LOG.info(message);
    }

    public String getContextParameter(String contextName, String paramName) {
        if (contextName != null && paramName != null) {
            Map<String, String> paramMap = jobContextParamsSetupConfiguration.getParamsToReplace().get(contextName);
            if (paramMap != null) {
                return replaceParameterWithSpel(paramName, paramMap.get(paramName));
            }
        }
        return null;
    }

    public List<ContextParameterInstance> getAllContextParameters(String contextName) {
        List<ContextParameterInstance> params = new ArrayList<>();
        if (contextName != null) {
            Map<String, String> paramMap = jobContextParamsSetupConfiguration.getParamsToReplace().get(contextName);
            if (paramMap != null) {
                for (String name : paramMap.keySet()) {
                    ContextParameterInstanceImpl param = new ContextParameterInstanceImpl();
                    param.setName(name);
                    String value = paramMap.get(name);
                    value = replaceParameterWithSpel(name, value);
                    param.setValue(value);
                    params.add(param);
                }
            }
        }
        return params;
    }

    private String replaceParameterWithSpel(String name, String value) {
        if (spelExpressionMap != null && !spelExpressionMap.isEmpty()) {
            for (String key : spelExpressionMap.keySet()) {
                if (key.equals(value)) {
                    String spel = spelExpressionMap.get(key);
                    ExpressionParser parser = new SpelExpressionParser();
                    Expression exp = parser.parseExpression(spel);
                    String newValue = exp.getValue(spel, String.class);
                    LOG.info(String.format("Replacing name [%s] parameter [%s] with new value [%s]", name, value, newValue));
                    return newValue;
                }
            }
        }
        return value;
    }

}
