/*
 * $Id$
 * $URL$
 *
 * ====================================================================
 * Ikasan Enterprise Integration Platform
 *
 * Distributed under the Modified BSD License.
 * Copyright notice: The copyright for this software and a full listing
 * of individual contributors are as shown in the packaged copyright.txt
 * file.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of the ORGANIZATION nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */
package org.ikasan.job.orchestration.integration.inbound.flow;

import org.ikasan.builder.BuilderFactory;
import org.ikasan.job.orchestration.integration.inbound.component.ScheduledProcessEventInboundFlowComponentFactory;
import org.ikasan.spec.flow.Flow;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * Flow factory implementation.
 *
 * @author Ikasan Development Team
 */
@Configuration
@ConditionalOnProperty(value="is.ikasan.enterprise.scheduler.instance", havingValue = "true")
public class ScheduledProcessEventInboundFlowFactory
{
    @Value( "${module.name}" )
    String moduleName;

    @Resource
    BuilderFactory builderFactory;

    @Resource
    ScheduledProcessEventInboundFlowComponentFactory scheduledProcessEventInboundFlowComponentFactory;

    // Default TTL to one week - 60 * 60 * 24 * 7 * 1000 = 604800000
    @Value(value = "${scheduler.inbound.flow.error.occurrence.ttl.milliseconds:604800000}")
    Long errorReportingServiceTimeToLive;

    @Bean
    public Flow scheduledProcessEventInboundFlow() throws IOException {
        return builderFactory.getModuleBuilder(moduleName).getFlowBuilder("Scheduled Process Event Inbound Flow")
            .withDescription("Scheduled Process Event Inbound Flow")
            .withErrorReportingServiceTimeToLive(errorReportingServiceTimeToLive)
            .consumer("Scheduled Consumer", scheduledProcessEventInboundFlowComponentFactory.getInboundBigQueueConsumer())
            .producer("Dashboard Producer", scheduledProcessEventInboundFlowComponentFactory.getScheduledStatusProducer())
            .build();
    }
}


