/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration;

import java.util.Map;
import javax.annotation.Resource;
import org.ikasan.job.orchestration.configuration.JobContextParamsSetupConfiguration;
import org.ikasan.job.orchestration.configuration.JobContextParamsSetupFactory;
import org.ikasan.job.orchestration.context.parameters.ContextParametersFactory;
import org.ikasan.job.orchestration.context.parameters.ContextParametersInstanceServiceImpl;
import org.ikasan.job.orchestration.context.recovery.ContextInstanceRecoveryManager;
import org.ikasan.job.orchestration.context.register.ContextInstanceSchedulerService;
import org.ikasan.job.orchestration.context.util.SchedulerContextParametersPropertiesProvider;
import org.ikasan.job.orchestration.integration.StartupApplicationListener;
import org.ikasan.job.orchestration.integration.StartupCompleteApplicationListener;
import org.ikasan.job.orchestration.integration.module.InboundModuleFactory;
import org.ikasan.module.service.ModuleActivatorDefaultImpl;
import org.ikasan.module.startup.dao.StartupControlDao;
import org.ikasan.scheduler.CachingScheduledJobFactory;
import org.ikasan.scheduler.SchedulerFactory;
import org.ikasan.spec.configuration.ConfigurationService;
import org.ikasan.spec.dashboard.DashboardRestService;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleActivator;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRecoveryService;
import org.ikasan.spec.scheduled.context.service.ContextInstanceRegistrationService;
import org.ikasan.spec.scheduled.context.service.ScheduledContextService;
import org.ikasan.spec.scheduled.instance.service.ContextParametersInstanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@Import(value={InboundModuleFactory.class, JobContextParamsSetupFactory.class})
public class JobOrchestrationAutoConfiguration {
    private Logger logger = LoggerFactory.getLogger(JobOrchestrationAutoConfiguration.class);
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    ConfigurationService configurationService;
    @Resource
    JtaTransactionManager transactionManager;
    @Value(value="${context.lifecycle.active:true}")
    private boolean isContextLifeCycleActive;
    @Value(value="${s.ikasan.enterprise.scheduler.instance:true}")
    private boolean isIkasanEnterpriseSchedulerInstance;
    @Resource
    private JobContextParamsSetupConfiguration jobContextParamsSetupConfiguration;
    @Value(value="#{${job.context.params.to.spel.calculators:{T(java.util.Collections).emptyMap()}}}")
    private Map<String, String> spelContextParamsCalculators;

    public JobOrchestrationAutoConfiguration() {
        this.logger.info("Refreshing - JobOrchestrationAutoConfiguration");
    }

    @Bean
    @DependsOn(value={"contextParametersFactory"})
    public ContextParametersInstanceService contextParametersInstanceService() {
        return new ContextParametersInstanceServiceImpl(this.contextParametersFactory());
    }

    @Bean
    @DependsOn(value={"schedulerOverrider"})
    public ContextParametersFactory contextParametersFactory() {
        return new ContextParametersFactory(this.schedulerOverrider());
    }

    @Bean
    @DependsOn(value={"jobContextParamsSetupConfiguration"})
    public SchedulerContextParametersPropertiesProvider schedulerOverrider() {
        return new SchedulerContextParametersPropertiesProvider(this.jobContextParamsSetupConfiguration, this.spelContextParamsCalculators);
    }

    @Bean
    @DependsOn(value={"stateChangeMonitor", "overdueFileMonitor", "monitorManagement"})
    public ContextInstanceRecoveryManager contextInstanceRecoveryManager(@Lazy ContextInstanceRecoveryService contextInstanceRecoveryService) {
        return new ContextInstanceRecoveryManager(contextInstanceRecoveryService, this.isContextLifeCycleActive, this.isIkasanEnterpriseSchedulerInstance);
    }

    @Bean
    @DependsOn(value={"contextInstanceRecoveryManager"})
    public ContextInstanceSchedulerService contextInstanceSchedulerService(@Lazy ContextInstanceRegistrationService contextInstanceRegistrationService, ScheduledContextService scheduledContextService) {
        return new ContextInstanceSchedulerService(SchedulerFactory.getInstance().getScheduler(), CachingScheduledJobFactory.getInstance(), scheduledContextService, contextInstanceRegistrationService, this.isContextLifeCycleActive, this.isIkasanEnterpriseSchedulerInstance);
    }

    @Bean
    public ModuleActivator moduleActivator(StartupControlDao startupControlDao) {
        return new ModuleActivatorDefaultImpl(this.configurationService, startupControlDao);
    }

    @Bean
    @ConditionalOnProperty(value={"is.ikasan.enterprise.scheduler.instance"}, havingValue="true")
    public StartupApplicationListener startupApplicationListener(DashboardRestService moduleMetadataDashboardRestService, DashboardRestService configurationMetadataDashboardRestService, Module<Flow> inboundFlowModule) {
        return new StartupApplicationListener(moduleMetadataDashboardRestService, configurationMetadataDashboardRestService, inboundFlowModule);
    }

    @Bean
    @ConditionalOnProperty(value={"is.ikasan.enterprise.scheduler.instance"}, havingValue="true")
    public StartupCompleteApplicationListener startupCompleteApplicationListener(Module<Flow> inboundFlowModule) {
        return new StartupCompleteApplicationListener(this.transactionManager, inboundFlowModule);
    }

    @EventListener
    public void onRefreshScopeRefreshed(RefreshScopeRefreshedEvent event) {
        this.logger.info("Received Refresh event");
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            if (!beanName.contains("scopedTarget")) continue;
            this.logger.info("Refreshing: bean name: " + beanName + " - Bean class: " + this.applicationContext.getBean(beanName).getClass());
            this.logger.debug("jobContextParamsSetupConfiguration = [{}]", this.jobContextParamsSetupConfiguration.getParamsToReplace());
        }
    }
}

