/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ikasan.spec.scheduled.job.service.SpringCloudConfigRefreshService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobContextParamsSetupConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JobContextParamsSetupConfiguration.class);
    private Map<String, String> location;
    private Map<String, Map<String, String>> paramsToReplace = new HashMap<String, Map<String, String>>();
    private SpringCloudConfigRefreshService springCloudConfigRefreshService;
    private List<String> jobContextConfigRepoEnvironment;
    private String configServerUrl;
    public static final String CIPHER_TAG = "{cipher}";

    public JobContextParamsSetupConfiguration(SpringCloudConfigRefreshService springCloudConfigRefreshService, List<String> jobContextConfigRepoEnvironment, String configServerUrl) {
        this.springCloudConfigRefreshService = springCloudConfigRefreshService;
        this.jobContextConfigRepoEnvironment = jobContextConfigRepoEnvironment;
        this.configServerUrl = configServerUrl;
    }

    public Map<String, Map<String, String>> getParamsToReplace() {
        return this.paramsToReplace;
    }

    public void setParamsToReplace(Map<String, Map<String, String>> paramsToReplace) {
        this.paramsToReplace = paramsToReplace;
    }

    public Map<String, String> getLocation() {
        return this.location;
    }

    public void setLocation(Map<String, String> location) {
        logger.info("Location for ikasan scheduler configuration files: {}", location);
        this.location = location;
        if (this.springCloudConfigRefreshService != null && this.jobContextConfigRepoEnvironment != null && this.jobContextConfigRepoEnvironment.size() != 0 && StringUtils.isNotBlank((CharSequence)this.configServerUrl)) {
            this.jobContextConfigRepoEnvironment.forEach(applicationPattern -> this.springCloudConfigRefreshService.refreshConfigRepo(this.configServerUrl, applicationPattern));
        }
        HashMap<String, Map<String, String>> contextParamsToReplace = new HashMap<String, Map<String, String>>();
        if (null != this.getLocation()) {
            this.getLocation().forEach((key, value) -> {
                try {
                    logger.info("Loading configuration for context [{}] from configuration file [{}]", key, value);
                    Map<String, String> loadMapFromFileValues = this.loadMapFromFile((String)value);
                    if (!loadMapFromFileValues.isEmpty()) {
                        contextParamsToReplace.put((String)key, loadMapFromFileValues);
                    } else {
                        logger.warn("ATTENTION: Loading configuration for context [{}] is empty and therefore will not be added", key);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected error occurred while loading configuration file for context [" + key + "] and [file " + value + "]", e);
                }
            });
            this.setParamsToReplace(contextParamsToReplace);
        } else {
            logger.warn("No configuration defined for the property job.context.mapping.configuration.");
        }
    }

    private Map<String, String> loadMapFromFile(String fileName) throws IOException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        JobContextParamsSetupConfiguration.getLines(fileName).forEach(line -> {
            if (line.trim().isEmpty()) {
                logger.warn("Empty line ignored from the configuration file [{}]", (Object)fileName);
            } else if (line.trim().startsWith("#")) {
                logger.info("Line [{}] is ignored from configuration file [{}]", line, (Object)fileName);
            } else if (!line.contains("=")) {
                logger.warn("ATTENTION: Malformed line: Line [{}] from the file [{}] is malformed and will be ignored!", line, (Object)fileName);
            } else {
                String key = line.substring(0, line.indexOf(61));
                String value = line.substring(line.indexOf(61) + 1);
                if (null != mappings.get(key)) {
                    logger.warn("ATTENTION: DUPLICATE MAP EXISTS: Mapping for key [{}] already exists with value [{}] and would be replaced with new value [{}] from the file [{}]", new Object[]{key, mappings.get(key), value, fileName});
                }
                if (key.isEmpty()) {
                    logger.warn("ATTENTION: Added Mapping with empty key and with value [{}] from the file [{}]", (Object)value, (Object)fileName);
                }
                if (StringUtils.startsWith((CharSequence)value, (CharSequence)CIPHER_TAG) && StringUtils.length((CharSequence)value) > 8) {
                    String decryptedValue = value;
                    if (this.springCloudConfigRefreshService != null && StringUtils.isNotBlank((CharSequence)this.configServerUrl)) {
                        decryptedValue = this.springCloudConfigRefreshService.decrypt(this.configServerUrl, StringUtils.removeStart((String)value, (String)CIPHER_TAG));
                    }
                    mappings.put(key, decryptedValue);
                } else {
                    mappings.put(key, value);
                }
            }
        });
        return mappings;
    }

    public static Stream<String> getLines(String mappingFilePath) throws IOException {
        InputStream inputStream = JobContextParamsSetupConfiguration.class.getResourceAsStream(mappingFilePath);
        if (inputStream != null) {
            logger.info("Mapping file path [{}] found on classpath", (Object)mappingFilePath);
            return new BufferedReader(new InputStreamReader(inputStream)).lines();
        }
        logger.info("File path [{}] is not a classpath resource will use filesystem", (Object)mappingFilePath);
        try {
            return Files.lines(Paths.get(mappingFilePath, new String[0]));
        }
        catch (NoSuchFileException e) {
            logger.error("ATTENTION: File path [{}] does not exist. Skipping!", (Object)mappingFilePath);
            return Stream.empty();
        }
    }
}

